<?php


class CalendarModel extends MY_Model {
    public $branch;
    public $business;

    public function __construct() {
        parent::__construct();
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
    }

    public function events() {
        $this->db->where('event_business_key',$this->business)
            ->join('business','business.business_key=events.event_business_key','left');
        $query = $this->db->get('events');
        return $query->result_array();
    }

    public function side_events() {
        $this->db->where('event_business_key',$this->business)
            ->join('business','business.business_key=events.event_business_key','left');
        $query = $this->db->order_by('event_id','DESC')->get('events','4');
        return $query->result_array();
    }

    public function key(){
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );
        $query = $this->db->where( 'event_key', $random_unique_int )->get_where( 'events');
        if( $query->num_rows() > 0 ) {
            $query->free_result();
            return $this->taskKey();
        }
        return $random_unique_int;
    }

}