<?php

class ConfigurationModel extends My_model {

  public function __construct() {
        parent::__construct();
    }

    public function loadConfigs() {
      $business = !empty(runningBusiness()->business_key) ? runningBusiness()->business_key : NULL;
      $this->db->where('config_business',$business);
      return $this->db->get('configuration')->row();
    }

    public function saveconfiguration($data){
      $this->db->update('configuration',$data);
      return $this->db->affected_rows();
    }

    function updateConfigItem($key,$val){
      $this->db->update('configuration',[$key=>$val]);
      if($this->db->affected_rows()>0){
        return TRUE;
      }else{
        return FALSE;
      }
    }

    public function currencies() {
        return $this->db->get('currencies')->result_array();
    }

    public function currency_add($data) {
        $this->db->insert('currencies',$data);
        if($this->db->affected_rows() > 0){
          $log = array(
            'log_message' => 'Adding currency to the system',
            'log_details' => 'Currency added successfull',
            'log_activity' => $this->db->insert_id(),
          );
          $this->logActivity($log);
          return TRUE;
        }else{
          $log = array(
            'log_message' => 'Adding currency to the system',
            'log_details' => 'Currency was not added',
            'log_activity' => '',
          );
          $this->logActivity($log);
          return FALSE;
        }
    }

    public function currency_update($id,$data) {
        $this->db->where('currency_id',$id);
        $this->db->limit(1);
        $this->db->update('currencies',$data);
        if($this->db->affected_rows() > 0){
          $log = array(
            'log_message' => 'Updating currency',
            'log_details' => 'Currency updated successfull',
            'log_activity' => $id,
          );
          $this->logActivity($log);
          return TRUE;
        }else{
          $log = array(
            'log_message' => 'Updating currency',
            'log_details' => 'Currency was not updated'
          );
          $this->logActivity($log);
          return FALSE;
        }
    }

    public function currency_delete($id) {
      if( ! $this->currency_is_default($id)):
        $this->db->where('currency_id',$id);
        $this->db->limit(1);
        $this->db->delete('currencies');
        if($this->db->affected_rows() > 0){
          $log = array(
            'log_message' => 'Deleting currency',
            'log_details' => 'Currency deleted successfull',
            'log_activity' => $id,
          );
          $this->logActivity($log);
          return TRUE;
        }else{
          $log = array(
            'log_message' => 'Deleting currency',
            'log_details' => 'Currency was not deleted',
            'log_activity' => $id,
          );
          $this->logActivity($log);
          return FALSE;
        }
       else:
         $log = array(
           'log_message' => 'Deleting currency',
           'log_details' => 'Currency was not deleted because is default currency',
           'log_activity' => $id,
         );
         $this->logActivity($log);
           return FALSE;
       endif;
    }

    public function currency($id) {
        $query = $this->db->where('currency_id',$id)
                ->get('currencies');
        return ($query->num_rows() ==1)? $query->row() : FALSE;
    }

    public function currency_is_default($id) {
        $query = $this->db->where('currency_id',$id)
                ->where('currency_default',TRUE)
                ->get('currencies');
        return ($query->num_rows() > 0)? TRUE : FALSE;
    }

    public function currency_get_default() {
        $query = $this->db->where('currency_default',TRUE)
                ->get('currencies');
        return ($query->num_rows()>0)? $query->row() : FALSE;
    }

    public function currency_make_default($id) {
        $default = $this->currency_get_default()->currency_id;
        $data['currency_default'] = TRUE;
        $this->db->where('currency_id',$id)
                ->update('currencies',$data);
        if($this->db->affected_rows()>0):
            $this->currency_remove_default($default);
            $log = array(
              'log_message' => 'Making currency default',
              'log_details' => 'Currency was made default currency',
              'log_activity' => $id,
            );
            $this->logActivity($log);
            return TRUE;
         else:
           $log = array(
             'log_message' => 'Making currency default',
             'log_details' => 'Currency was not made default currency',
             'log_activity' => $id,
           );
           $this->logActivity($log);
             return FALSE;
        endif;
    }

    public function currency_remove_default($id) {
        $data['currency_default'] = FALSE;
        $this->db->where('currency_id',$id)
                ->update('currencies',$data);
                if($this->db->affected_rows() > 0){
                  $log = array(
                    'log_message' => 'Remove default currency',
                    'log_details' => 'Currency was removed successfull',
                    'log_activity' => $id,
                  );
                  $this->logActivity($log);
                  return TRUE;
                }else{
                  $log = array(
                    'log_message' => 'Remove default currency',
                    'log_details' => 'Currency was not removed',
                    'log_activity' => $id,
                  );
                  $this->logActivity($log);
                  return FALSE;
                }
    }
}
