<?php

/**
*
* @author Kelvin Benard
*/

class BusinessModel extends MY_Model{

  public function business($key) {
    $this->db->where('business_key',$key);
    return $this->db->get('business')->row();
  }

    public function businesses(){
        $query =  $this->db->get('business');
        return $query->num_rows()>0 ? $query->result_array() : FALSE;
    }


    public function businessUpdate($key,$data)
    {
        $this->db->limit(1);
        $this->db->where('business_key',$key);
        $this->db->update( 'business',$data);
        if($this->db->affected_rows()>0){
            return TRUE;
        }else{
            return FALSE;
        }
    }

    public function businessDelete($key)
    {
        $this->db->limit(1);
        $this->db->where('business_key',$key);
        $this->db->delete('business');
        if($this->db->affected_rows()>0){
            return TRUE;
        }else{
            return FALSE;
        }
    }

    function businessRegister($data){
        $data['business_key'] = $this->businessKey();
        $this->db->insert('business',$data);
        if($this->db->affected_rows()>0){
            return TRUE;
        }else{
            return FALSE;
        }
    }

    public function businessKey()
    {
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'business_key', $random_unique_int )
            ->get_where( 'business' );

        if( $query->num_rows() > 0 )
        {
            $query->free_result();

            // If the random user_id is already in use, try again
            return $this->businessKey();
        }

        return $random_unique_int;
    }
    

}
