<?php

/**
*
* @author Kelvin Benard
*/

class BranchesModel extends MY_Model{

public function branches(){
    $query =  $this->db->get('branches');
    return $query->num_rows()>0 ? $query->result_array() : FALSE;
}

public function branch($key='') {

    if(empty($key)){
      $key = profileSimple()->user_branch;
    }

    $this->db->where('branch_key',$key);

  return $this->db->get('branches')->row();

}

    public function branchDefault($key='') {

        $business = profileSimple()->user_branch;
        $this->db->where('branch_primary',1);
        $this->db->where('branch_business',$business);

        return $this->db->get('branches')->row();

    }

public function branchUpdate($key,$data)
{
  $this->db->limit(1);
  $this->db->where('branch_key',$key);
  $this->db->update( 'branches',$data);
  if($this->db->affected_rows()>0){
    return TRUE;
  }else{
    return FALSE;
  }
}

public function branchDelete($key)
{
  $this->db->limit(1);
  $this->db->where('branch_key',$key);
  $this->db->delete('branches');
  if($this->db->affected_rows()>0){
    return TRUE;
  }else{
    return FALSE;
  }
}

function branchRegister($data){
  $data['branch_key'] = $this->branchKey();
  $this->db->insert('branches',$data);
  if($this->db->affected_rows()>0){
    return TRUE;
  }else{
    return FALSE;
  }
}

public function branchKey()
{
    // Create a random user id between 1200 and 4294967295
    $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

    // Make sure the random user_id isn't already in use
    $query = $this->db->where( 'branch_key', $random_unique_int )
        ->get_where( 'branches' );

    if( $query->num_rows() > 0 )
    {
        $query->free_result();

        // If the random user_id is already in use, try again
        return $this->branchKey();
    }

    return $random_unique_int;
}

}
