<?php

/**
 * Description of AdministrationModel
 *
 * @author Kelvin Benard
 */

class Administration extends My_model {

  public function __construct() {
    parent::__construct();
  }
  
  function office_update($data,$key){
    $this->db->where('office_key',$key)
    ->update('offices',$data);
    return $this->db->affected_rows();
  }

  function office_register($data){
    $this->db->insert('offices',$data);
    return $this->db->affected_rows();
  }

  function office_delete($key){
    $this->db->where('office_key',$key)
    ->delete('offices');
    return $this->db->affected_rows();
  }

  function office($key){
    return  $this->db->where('office_key',$key)
    ->get('offices')->row();
  }

  function officeDefault(){
    return  $this->db->where('office_default',TRUE)
    ->get('offices')->row();
  }

  function offices(){
    return  $this->db->get('offices')->result_array();
  }

  public function unused_office_key()
  {
      // Create a random user id between 1200 and 4294967295
      $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

      // Make sure the random user_id isn't already in use
      $query = $this->db->where( 'office_key', $random_unique_int )
          ->get_where( 'offices' );

      if( $query->num_rows() > 0 )
      {
          $query->free_result();

          // If the random user_id is already in use, try again
          return $this->unused_office_key();
      }

      return $random_unique_int;
  }

}
