<?php

class TransactionsModel extends My_model {

  public function __construct() {
      parent::__construct();
  }

  public function transactions() {
    $business = $this->businessModel->business(profile()->user_business)->business_key;
    $store = $this->storesModel->store()->store_key;
    $query = $this->db
      ->order_by('trans_id','DESC')
      ->where('trans_business',$business)
      ->where('trans_store',$store)
      ->join('accounts','accounts.account_id=trans_account','both')
      ->from( 'transactions' )
      ->get();
      return $query->result_array();
  }

  public function transactionDetails($transKey='') {
    $query = $this->db
      ->where('trans_key',$transKey)
      ->join('accounts','accounts.account_id=trans_account','both')
      ->from( 'transactions' )
      ->get();
      return $query->row();
  }

}
