<?php

class AssetsModel extends My_model {

public function __construct() {
    parent::__construct();
    $this->branch = runningBranch()->branch_key;
    $this->business = runningBusiness()->business_key;
}

public function asset($asset) {
  $query = $this->db->where( 'asset_key',$asset )
    ->where('asset_branch',$this->branch)
    ->where('asset_business',$this->business)
    ->join('asset_types','asset_types'.'.asset_type_key='.'assets'.'.asset_type','left')
    ->from('assets')
    ->get();
return ($query->num_rows()>0)? $query->row() : FALSE;
}

public function assets() {
    $query = $this->db->select( '*')
    ->select('DATE_FORMAT(asset_date, "%Y/%M/%d") as asset_date', FALSE)
    ->order_by( 'asset_id','DESC' )
    ->where('asset_branch',$this->branch)
    ->where('asset_business',$this->business)
    ->join('asset_types','asset_types'.'.asset_type_key='.'assets'.'.asset_type','left')
    ->from('assets')
    ->get();
return $query->result_array();
}

public function newAsset($asset) {
    $asset['asset_key'] = $this->asset_key();
    $assetType = $this->assetType($asset['asset_type']);
    $drAccount['trans_branch'] = $this->branch;
    $drAccount['trans_business'] = $this->business;
    $drAccount['trans_key'] = $this->transactionKey();
    $drAccount['trans_action'] = 'debit';
    $drAccount['trans_amount'] = $asset['asset_total_cost'];
    $drAccount['trans_origin'] = $asset['asset_key'];
    $drAccount['trans_account'] = $assetType->asset_type_account;
    $drAccount['trans_type'] = 'Purchase assets from a supplier';
    $drAccount['trans_date'] = $asset['asset_date'];
    $drAccount['trans_details'] = $asset['asset_description'];
    $drAccount['trans_payee'] = $asset['asset_bougth_from'];
    $drAccount['trans_employee'] = config_item('auth_user_id');

    $crAccount['trans_branch'] = $this->branch;
    $crAccount['trans_business'] = $this->business;
    $crAccount['trans_key'] = $this->transactionKey($drAccount['trans_key']);
    $crAccount['trans_action'] = 'credit';
    $crAccount['trans_amount'] = -$asset['asset_total_cost'];
    $crAccount['trans_origin'] = $asset['asset_key'];
    $crAccount['trans_account'] = $asset['asset_withdraw_account'];
    $crAccount['trans_type'] = 'Purchase assets from a supplier';
    $crAccount['trans_date'] = $asset['asset_date'];
    $crAccount['trans_details'] = $asset['asset_description'];
    $crAccount['trans_payee'] = $asset['asset_bougth_from'];
    $crAccount['trans_employee'] = config_item('auth_user_id');

    $this->db->trans_start();
    $this->db->insert('transactions',$drAccount);
    $this->db->insert('transactions',$crAccount);

    $asset['asset_branch'] = $this->branch;
    $asset['asset_actions'] = optionActions('asset',$asset['asset_key']);
    $asset['asset_business'] = $this->business;
    $this->db->insert('assets',$asset);
    $this->db->trans_complete();
    if($this->db->trans_status()){
      return TRUE;
    }else{
      return FALSE;
    }
}

public function newAssetType($data) {
  $data['asset_type_branch']= $this->branch;
  $data['asset_type_business'] = $this->business;
  $data['asset_type_key'] = $this->asset_type_key();
  $this->db->insert('asset_types',$data);
  if($this->db->affected_rows() > 0){
    return TRUE;
  }else{
    return FALSE;
  }
}

public function assetTypes() {
  $this->db->where('asset_type_business',$this->business);
  //$this->db->where('asset_type_branch',$this->branch);
  $this->db->join('accounts','accounts.account_id=asset_type_account','left');
  $query = $this->db->order_by('asset_type_id','DESC')->join('asset_categories','asset_categories'.'.category_key='.'asset_types'.'.asset_type_category','left')->get('asset_types');
  return $query->result_array();
}

public function assetType($assetType) {
  $this->db->where('asset_type_business',$this->business);
  $this->db->where('asset_type_branch',$this->branch);
	$query = $this->db->where('asset_type_key',$assetType)->join('asset_categories','asset_categories'.'.category_key='.'asset_types'.'.asset_type_category','left')->get('asset_types');
	return $query->row();
}

public function assetCategories() {
  $query = $this->db->get('asset_categories');
  return $query->result_array();
}

public function deleteAsset($assetKey) {
  $this->db->trans_start();
  $this->deleteTransOrigin($assetKey);

  $this->db->where('asset_business',$this->business);
  $this->db->where('asset_branch',$this->branch);
  $this->db->limit(1)
    ->where('asset_key=',$assetKey)
    ->delete('assets');
  $this->db->trans_complete();
    if($this->db->trans_status()){
      return TRUE;
    }else{
      return FALSE;
    }
}

public function deleteAssetType($assetTypeKey) {
  $this->db->where('asset_type_business',$this->business);
  //$this->db->where('asset_type_branch',$this->branch);
  $this->db->limit(1)
    ->where('asset_type_key=',$assetTypeKey)
    ->delete('asset_types');
    if($this->db->affected_rows() > 0){
      $log = array(
        'log_message' => 'Delete Asset Type',
        'log_details' => 'Asset Type deleted successfull',
        'log_activity' => $assetTypeKey,
      );
      $this->logActivity($log);
      return TRUE;
    }else{
      $log = array(
        'log_message' => 'Delete Asset Type',
        'log_details' => 'Asset Type was not deleted',
        'log_activity' => $assetTypeKey,
      );
      $this->logActivity($log);
      return FALSE;
    }
}

public function updateAsset($assetKey,$asset) {
  $assetType = $this->assetType($asset['asset_type']);
  $drAccount['trans_branch'] = $this->branch;
  $drAccount['trans_business'] = $this->business;
  $drAccount['trans_key'] = $this->transactionKey();
  $drAccount['trans_action'] = 'debit';
  $drAccount['trans_amount'] = $asset['asset_total_cost'];
  $drAccount['trans_origin'] = $assetKey;
  $drAccount['trans_account'] = $assetType->asset_type_account;
  $drAccount['trans_type'] = 'Expense';
  $drAccount['trans_date'] = $asset['asset_date'];
  $drAccount['trans_details'] = $asset['asset_description'];
  $drAccount['trans_payee'] = $asset['asset_bougth_from'];
  $drAccount['trans_employee'] = config_item('auth_user_id');

  $crAccount['trans_branch'] = $this->branch;
  $crAccount['trans_business'] = $this->business;
  $crAccount['trans_key'] = $this->transactionKey($drAccount['trans_key']);
  $crAccount['trans_action'] = 'credit';
  $crAccount['trans_amount'] = -$asset['asset_total_cost'];
  $crAccount['trans_origin'] = $assetKey;
  $crAccount['trans_account'] = $asset['asset_withdraw_account'];
  $crAccount['trans_type'] = 'Expense';
  $crAccount['trans_date'] = $asset['asset_date'];
  $crAccount['trans_details'] = $asset['asset_description'];
  $crAccount['trans_payee'] = $asset['asset_bougth_from'];
  $crAccount['trans_employee'] = config_item('auth_user_id');

  $this->db->trans_start();
  $this->deleteTransOrigin($assetKey);

  $this->db->insert('transactions',$drAccount);
  $this->db->insert('transactions',$crAccount);

  $this->db->where('asset_branch',$this->branch);
  $this->db->where('asset_business',$this->business);
  $this->db->where('asset_key',$assetKey);
  $this->db->update('assets',$asset);
  $this->db->trans_complete();
  if($this->db->trans_status()){
    return TRUE;
  }else{
    return FALSE;
  }
}

public function updateAssetType($assetTypeKey,$data) {
  $this->db->where('asset_type_business',$this->business);
  //$this->db->where('asset_type_branch',$this->branch);
  $this->db->limit(1)
    ->where('asset_type_key',$assetTypeKey)
    ->update( 'asset_types',$data );
    if($this->db->affected_rows() > 0){
      return TRUE;
    }else{
      return FALSE;
    }
}

public function asset_key()
{
    // Create a random user id between 1200 and 4294967295
    $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

    // Make sure the random user_id isn't already in use
    $query = $this->db->where( 'asset_key', $random_unique_int )
        ->get_where( 'assets' );

    if( $query->num_rows() > 0 )
    {
        $query->free_result();

        // If the random user_id is already in use, try again
        return $this->asset_key();
    }

    return $random_unique_int;
}

public function asset_type_key()
{
    // Create a random user id between 1200 and 4294967295
    $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

    // Make sure the random user_id isn't already in use
    $query = $this->db->where( 'asset_type_key', $random_unique_int )
        ->get_where( 'asset_types' );

    if( $query->num_rows() > 0 )
    {
        $query->free_result();

        // If the random user_id is already in use, try again
        return $this->asset_type_key();
    }

    return $random_unique_int;
}

}
