<?php

class Accounting extends My_model {

    public $offset = false;
    public $limit = false;

  public function __construct() {
      parent::__construct();
      $this->business = runningBusiness()->business_key;
      $this->branch = runningBranch()->branch_key;
  }

  public function account($account) {
    $query = $this->db->select( '*')
      ->where( 'account_key',$account)
      ->where('account_business',$this->business)
      ->join('accounting_types','accounting_types'.'.type_key='.'accounting_accounts'.'.account_type','left')
      ->join('accounting_sub_types','accounting_sub_types'.'.subtype_key='.'accounting_accounts'.'.account_sub_type','left')
      ->from('accounting_accounts')
      ->get();
  return ($query->num_rows()>0)? $query->row() : FALSE;
  }

  public function accountsTypes($types) {

      if($this->offset && $this->limit){
          $this->db->limit($this->offset,$this->limit);
      }

      if($this->offset){
          $this->db->limit($this->offset);
      }

    $this->db->like($types,'both');
    $query = $this->db->get("accounting_types");
  return $query->result_array();

  } 

  public function accountsByType($type) {
        $query = $this->db->select( '*' )
            ->where('account_business',$this->business)
            ->where('account_type',$type)
            ->order_by( 'account_id','DESC' )
            ->group_by('account_id')
            ->join('accounting_types','accounting_types'.'.type_key='.'accounting_accounts'.'.account_type','both')
            ->from('accounting_accounts')
            ->get();
        return $query->result_array();
    }

  public function accountsByTypeText($type) {
        $query = $this->db->select( '*' )
            ->where('account_business',$this->business)
            ->where('actype_text',$type)
            ->order_by( 'account_id','DESC' )
            ->group_by('account_id')
            ->join('accounting_types','accounting_types'.'.type_key='.'accounting_accounts'.'.account_type','both')
            ->from('accounting_accounts')
            ->get();
        return $query->result_array();
    }
    
  public function expenseAccounts() {
        $query = $this->db->select( '*' )
            ->where('account_business',$this->business)
            ->join('accounting_types','accounting_types'.'.type_key='.'accounting_accounts'.'.account_type','both')
            ->where('type_key',1010)
            ->get('accounting_accounts');
        return $query->result_array();
    } 

  public function cashAccounts() {
        $query = $this->db->select( '*' )
            ->join('accounting_types','accounting_types'.'.type_key='.'accounting_accounts'.'.account_type','both')
            ->where('account_business',$this->business)
            ->where('actype_text','cash')
            ->from('accounting_accounts')
            ->get();
        return $query->result_array();
    }

  public function accounts() {
        $query = $this->db->select( '*')
        ->join('accounting_types','accounting_types'.'.type_key='.'accounting_accounts'.'.account_type','both')
        ->join('accounting_sub_types','accounting_sub_types'.'.subtype_key='.'accounting_accounts'.'.account_sub_type','both')
          ->where('account_business',$this->business)
          ->order_by('account_id','DESC' )
          ->from('accounting_accounts')
          ->get();
    return $query->result_array();
    }

  public function newAccount($data) {
      $data['account_id'] = $this->account_id();
      $data['account_number'] = branchCode().'-'.$data['account_id'];
      $data['account_business'] = $this->business;
      $this->db->insert('accounting_accounts',$data);
      if($this->db->affected_rows() > 0){
        $log = array(
          'log_message' => 'Adding account to the system',
          'log_details' => 'Account added successfully',
          'log_activity' => $this->db->insert_id(),
        );
        $this->logActivity($log);
        return TRUE;
      }else{
        $log = array(
          'log_message' => 'Adding Account to the system',
          'log_details' => 'Account was not added',
          'log_activity' => '',
        );
        $this->logActivity($log);
        return FALSE;
      }
  }

  public function transactions() {
    $query = $this->db
      ->order_by('trans_id','DESC')
      ->where('trans_business',$this->business)
      ->where('trans_branch',$this->branch)
      ->join('accounting_accounts acc','acc.account_id=trans_account','both')
      ->from( 'transactions' )
      ->get();
      return $query->result_array();
  }

  public function transactionDetails($transKey='') {
    $query = $this->db
      ->where('trans_key',$transKey)
      ->join('accounting_accounts','accounts.account_id=trans_account','both')
      ->from( 'transactions' )
      ->get();
      return $query->row();
  }

  public function accountTypes() {
        $query = $this->db->get('accounting_types');
        return $query->result_array();
    }

  public function accountSubTypeDetails($type) {
        $this->db->where('subtype_key',$type);
        $query = $this->db->get('accounting_sub_types');
        return ($query->num_rows()>0)? $query->row() : FALSE;
    }

  public function accountSubTypes($type) {
    $this->db->where('subtype_type_key',$type);
    $query = $this->db->get('accounting_sub_types');
    return $query->result_array();
  }

  public function accountSubTypesAll() {
        $query = $this->db->get('accounting_sub_types');
        return $query->result_array();
    }

  public function accountTypeDetails($type) {
        $this->db->where('type_key',$type);
        $query = $this->db->get('accounting_types');
        return ($query->num_rows()>0)? $query->row() : FALSE;
    }

  public function accountingRules() {
      $query = $this->db->select( '*' )
      ->from('accounting_rules')
      ->get();
      return $query->result_array();
  }

  public function deleteAccount($id) {
    $this->db->limit(1)
      ->where('account_key=',$id)
      ->delete('accounting_accounts');
      if($this->db->affected_rows() > 0){
        return TRUE;
      }else{
        return FALSE;
      }
  }

  public function updateAccount($id,$data) {
    $this->db->limit(1)
      ->where('account_id',$id)
      ->update( 'accounting_accounts',$data );
      if($this->db->affected_rows() > 0){
        $log = array(
          'log_message' => 'Update account',
          'log_details' => 'Account updated successfull',
          'log_activity' => $id,
        );
        $this->logActivity($log);
        return TRUE;
      }else{
        $log = array(
          'log_message' => 'Update account',
          'log_details' => 'Account was not Updated',
          'log_activity' => $id,
        );
        $this->logActivity($log);
        return FALSE;
      }
  }

  function datasourceapprove(){
    $data = $alldata = $this->loansModel->paymentstoapprove();
    $columnsDefault = [
      'app_id'     => true,
      'loan_payment_id'  => true,
      'app_key'     => true,
      'duedate'     => true,
      'firstname'    => true,
      'customer'    => true,
      'loan_name'      => true,
      'principal'     => true,
      'interest'     => true,
      'amount'     => true,
      'charges'     => true,
      'balance'     => true,
      'paid'     => true,
      'number'     => true,
      'status'  => true,
    ];
  $this->sourcedataserver($data,$columnsDefault);
  }

  public function account_key()
  {
      // Create a random user id between 1200 and 4294967295
      $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

      // Make sure the random user_id isn't already in use
      $query = $this->db->where( 'account_key', $random_unique_int )
          ->get_where( 'accounting_accounts' );

      if( $query->num_rows() > 0 )
      {
          $query->free_result();

          // If the random user_id is already in use, try again
          return $this->account_key();
      }

      return $random_unique_int;
  }

}
