<?php

require_once APPPATH .'third_party/pusher/vendor/autoload.php';

Class Source {

    protected $pusher;
    protected $options;
    protected $lmk;
    protected $settings;

    public function __construct(){
        $this->lmk =& get_instance();
    }

    function pusherObj(){
        $this->settings = $this->pusherSettings();

        $this->options = array(
            'cluster' => $this->settings->pusher_cluster,
            'useTLS' => true,
            'debug' => true
        );

        $this->pusher = new Pusher\Pusher(
            $this->settings->pusher_key,
            $this->settings->pusher_secret,
            $this->settings->pusher_id,
            $this->options
        );

        return $this->pusher;
    }

    function pusherSettings(){
        $query = $this->lm->db->get('pusher');
        return $query->num_rows()>0 ? $query->row(): false;
    }

}
