<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of ApiLibrary
 *
 * @author kelvin Benard
 * @modified by Noely hero
 */

require_once __DIR__.'/vendor/autoload.php';
use infobip\api\configuration\BasicAuthConfiguration;

use infobip\api\client\SendSingleTextualSms;
use infobip\api\client\GetAccountBalance;
use infobip\api\client\GetSentSmsLogs;
use infobip\api\client\SendMultipleTextualSmsAdvanced;

use infobip\api\model\Destination;
use infobip\api\model\sms\mt\send\Message;
use infobip\api\model\sms\mt\send\textual\SMSAdvancedTextualRequest;
use infobip\api\model\sms\mt\logs\GetSentSmsLogsExecuteContext;
use infobip\api\model\sms\mt\send\textual\SMSTextualRequest;

class InfobipLibrary {

    protected $api;
    protected $curl;
    protected $authorization;
    protected $client;

    public function __construct()
    {
        $this->api =& get_instance();
        define("PASSWORD", "Nyambura1!");
        define("USERNAME", "lockminds");
    }

    function smsLog($limit, $start)
    {
        $this->api->db->order_by('sms_id', 'DESC');
        $this->api->db->where('sms_is_bulk',1);
        $this->api->db->limit($limit, $start);
        $query = $this->api->db->get('bulksms');
        return $query->num_rows() > 0 ? $query->result_array() : false;
    }

    function smsLogBulk()
    {
        $this->api->db->select('*');
        $this->api->db->order_by('sms_id', 'DESC');
        $this->api->db->where('sms_is_bulk',0);
        $this->api->db->group_by('sms_bulk_id');
        $this->api->db->select_sum('sms_is_bulk','total');
        $query = $this->api->db->get('bulksms');
        return $query->num_rows() > 0 ? $query->result_array() : false;
    }

    function getBulkSms($bulkId)
    {
        $this->api->db->order_by('sms_id', 'DESC');
        $this->api->db->where('sms_is_bulk',true);
        $this->api->db->where('sms_bulk_id',$bulkId);
        $query = $this->api->db->get('bulksms');
        return $query->num_rows() > 0 ? $query->result_array() : false;
    }

    function getmessage($messageId)
    {
        $this->api->db->where('sms_message_id',$messageId);
        $query = $this->api->db->get('bulksms');
        return $query->num_rows() > 0 ? $query->row() : false;
    }

    public function sendBulk($param)
    {

        $bulkId = $this->bulkId();

        $this->client = new SendMultipleTextualSmsAdvanced(new BasicAuthConfiguration(USERNAME, PASSWORD));

        // A destination object is created for each phone number:
        $destinations = array();
        foreach ($param['recipients'] as $phoneNumber) {
            $destination = new Destination();
            $destination->setTo($phoneNumber);
            $destinations[] = $destination;
        }

        // Message that uses $destinations array
        $message = new Message();
        $message->setFrom($param['sender']);
        $message->setDestinations($destinations);
        $message->setText($param['text']);
        $message->setNotifyUrl(base_url('communication/sms/index/processCallbackBulk'));

        $requestBody = new SMSAdvancedTextualRequest();
        $requestBody->setMessages([$message]);
        $requestBody->setBulkId($bulkId);

        // Executing response
        try {

            $response = $this->client->execute($requestBody);

            foreach ($response->getMessages() as $index => $sentMessageInfo) {
                $localSms['sms_bulk_id'] = $bulkId;
                $localSms['sms_is_bulk'] = true;
                $localSms['sms_to'] = $sentMessageInfo->getTo();
                $localSms['sms_text'] = $param['text'];
                $localSms['sms_bulk_title'] = $param['title'];
                $localSms['sms_messageId'] = $sentMessageInfo->getMessageId();
                $localSms['sms_status_name'] = $sentMessageInfo->getStatus()->getName();
                $localSms['sms_status_groupName'] = $sentMessageInfo->getStatus()->getGroupName();
                $localSms['sms_status_desc'] = $sentMessageInfo->getStatus()->getDescription();
                $this->api->db->insert('bulksms', $localSms);
            }

            $count = $index + 1;
            $data['status'] = true;
            $data['message'] = $count . " message(s) hae been sent";

        } catch (Exception $exception) {

            $result = json_decode($exception->getMessage())->requestError->serviceException;
            $data['status'] = false;
            $data['message'] = $result->text;

        }

        return $data;

    }

    public function sendSingleSms($sender, $recipient, $text)
    {

        $this->client = new SendMultipleTextualSmsAdvanced(new BasicAuthConfiguration(USERNAME, PASSWORD));

        $destination = new Destination();
        $destination->setTo($recipient);

        $message = new Message();
        $message->setFrom($sender);
        $message->setDestinations([$destination]);
        $message->setText($text);
        $message->setNotifyUrl(base_url('communication/sms/index/processCallback'));

        $requestBody = new SMSAdvancedTextualRequest();
        $requestBody->setMessages([$message]);

        // Executing request
        try {
            $response = $this->client->execute($requestBody);
            $sentMessageInfo = $response->getMessages()[0];

            $localSms['sms_to'] = $recipient;
            $localSms['sms_text'] = $text;
            $localSms['sms_messageId'] = $sentMessageInfo->getMessageId();
            $localSms['sms_status_name'] = $sentMessageInfo->getStatus()->getName();
            $localSms['sms_status_groupName'] = $sentMessageInfo->getStatus()->getGroupName();
            $localSms['sms_status_desc'] = $sentMessageInfo->getStatus()->getDescription();
            $this->api->db->insert('bulksms', $localSms);

            $data['status'] = true;
            $data['message'] = 'Message sent';


        } catch (Exception $exception) {
            $result = json_decode($exception->getMessage())->requestError->serviceException;
            $data['status'] = false;
            $data['message'] = $result->text;
        }

        return $data;
    }

    public function getBalance()
    {
        // Initializing GetAccountBalance client with appropriate configuration
        $this->client = new GetAccountBalance(new BasicAuthConfiguration(USERNAME, PASSWORD));
        // Executing request
        $response = $this->client->execute();

        $response = $this->client->execute();
        $data['balance'] = $response->getBalance();
        $data['currency'] = $response->getCurrency();

        return $data;
    }

    public function sentSms()
    {
        $this->client = new GetSentSmsLogs(new BasicAuthConfiguration(USERNAME, PASSWORD));

        $context = new GetSentSmsLogsExecuteContext();
        //$context->setGeneralStatus("SENT");

        // Executing request
        $response = $this->client->execute($context);

        return $response;
    }

    public function deliveredSms()
    {
        $client = new GetSentSmsLogs(new BasicAuthConfiguration(USERNAME, PASSWORD));

        // Creating execution context
        $context = new GetSentSmsLogsExecuteContext();
        $context->setGeneralStatus("DELIVERED");

        // Executing request
        $response = $client->execute($context);

        return $response;
    }

    public function processNotifyUrl()
    {

        $json = json_decode($this->api->input->raw_input_stream);
        $responses = $json->results;

        foreach ($responses as $response) {
            $data['sms_doneAt'] = date("Y-m-d H:i:s", strtotime($response->doneAt));
            $data['sms_sentAt'] = date("Y-m-d H:i:s", strtotime($response->sentAt));
            $data['sms_smsCount'] = $response->smsCount;
            $data['sms_status_groupName'] = $response->status->groupName;
            $data['sms_error_groupName'] = $response->error->groupName;
            $data['sms_status_name'] = $response->status->name;
            $data['sms_status_desc'] = $response->status->description;
            $data['sms_error_name'] = $response->error->description;

            $this->api->db->where('sms_messageId', $response->messageId);
            $this->api->db->update('bulksms', $data);
        }
    }

    public function processNotifyUrlBulk()
    {

        $json = json_decode($this->api->input->raw_input_stream);
        $responses = $json->results;

        foreach ($responses as $response) {
            $data['sms_doneAt'] = date("Y-m-d H:i:s", strtotime($response->doneAt));
            $data['sms_sentAt'] = date("Y-m-d H:i:s", strtotime($response->sentAt));
            $data['sms_smsCount'] = $response->smsCount;
            $data['sms_status_groupName'] = $response->status->groupName;
            $data['sms_error_groupName'] = $response->error->groupName;
            $data['sms_status_name'] = $response->status->name;
            $data['sms_status_desc'] = $response->status->description;
            $data['sms_error_name'] = $response->error->description;

            $this->api->db->where('sms_bulk_id', $response->bulkId);
            $this->api->db->where('sms_messageId', $response->messageId);
            $this->api->db->update('bulksms', $data);
        }
    }

    public function bulkId()
    {
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand(-2147482448, 2147483647);

        // Make sure the random user_id isn't already in use
        $query = $this->api->db->where('sms_bulk_id', $random_unique_int)
            ->get_where('bulksms');

        if ($query->num_rows() > 0) {
            $query->free_result();

            // If the random user_id is already in use, try again
            return $this->taxKey();
        }

        return $random_unique_int;
    }
}