<?php

    function topMenuGeneralLedger($flag=""){?>
        <div class="kt-subheader   kt-grid__item" id="kt_subheader">
            <div class="kt-container">
            <div class="kt-subheader__main">
                <h3 class="kt-subheader__title">General Ledger Report</h3>
            </div>
            <div class="kt-subheader__toolbar">
                <div class="kt-subheader__wrapper">
                    <?php lmDates();?>
                    <button class="btn btn-sm btn-outline-dark btn-icon"><i class="fa fa-cog"></i></button>
                </div>
            </div>
            </div>
        </div>
    <?php }

function topMenuBalanceSheet($flag=""){?>
    <div class="kt-subheader   kt-grid__item" id="kt_subheader">
        <div class="kt-container">
            <div class="kt-subheader__main">
                <h3 class="kt-subheader__title">Balance Sheet</h3>
            </div>
            <div class="kt-subheader__toolbar">
                <div class="kt-subheader__wrapper">
                    <?php lmDates();?>
                    <button class="btn btn-sm btn-outline-dark btn-icon"><i class="fa fa-cog"></i></button>
                </div>
            </div>
        </div>
    </div>
<?php }
 
function topMenuIncomeStatement($flag=""){?>
    <div class="kt-subheader   kt-grid__item" id="kt_subheader">
        <div class="kt-container">
            <div class="kt-subheader__main">
                <h3 class="kt-subheader__title">Income Statement</h3>
            </div>
            <div class="kt-subheader__toolbar">
                <div class="kt-subheader__wrapper">
                    <?php lmDates();?>
                    <button class="btn btn-sm btn-outline-dark btn-icon"><i class="fa fa-cog"></i></button>
                </div>
            </div>
        </div>
    </div>
<?php }

function topMenuTrialBalance($flag=""){?>
    <div class="kt-subheader   kt-grid__item" id="kt_subheader">
        <div class="kt-container">
            <div class="kt-subheader__main">
                <h3 class="kt-subheader__title">Trial Balance</h3>
            </div>
            <div class="kt-subheader__toolbar">
                <div class="kt-subheader__wrapper">
                    <?php lmDates();?>
                    <button class="btn btn-sm btn-outline-dark btn-icon"><i class="fa fa-cog"></i></button>
                </div>
            </div>
        </div>
    </div>
<?php }

function accountHasTransactions($account,$dates=''){
    $business = runningBusiness()->business_key;
    $branch = runningBranch()->branch_key;
    $lm =& get_instance();
    if(!empty($dates['start_date'])){
        $lm->db->where('gl_date >= ',$dates['start_date']);
    }
    if(!empty($dates['end_date'])){
        $lm->db->where('gl_date <= ',$dates['end_date']);
    }
    $query = $lm->db
        ->where( 'gl_account',$account)
        ->where('gl_business',$business)
        ->where('gl_branch',$branch)
        ->from('accounting_general_ledger')
        ->get();
    return ($query->num_rows()>0)? true: false;
}

function accountBalanceDebit($account,$dates=''){
    $business = runningBusiness()->business_key;
    $branch = runningBranch()->branch_key;
    $lm =& get_instance();
    if(!empty($dates['start_date'])){
        $lm->db->where('gl_date >= ',$dates['start_date']);
    }
    if(!empty($dates['end_date'])){
        $lm->db->where('gl_date <= ',$dates['end_date']);
    }
    $query = $lm->db->select_sum( 'gl_debit')
        ->where( 'gl_account',$account)
        ->where('gl_business',$business)
        ->where('gl_branch',$branch)
        ->from('accounting_general_ledger')
        ->get();
    return ($query->num_rows()>0)? $query->row()->gl_debit : 0;
}

function accountBalanceCredit($account,$dates=''){
    $business = runningBusiness()->business_key;
    $branch = runningBranch()->branch_key;
    $lm =& get_instance();
    if(!empty($dates['start_date'])){
        $lm->db->where('gl_date >= ',$dates['start_date']);
    }
    if(!empty($dates['end_date'])){
        $lm->db->where('gl_date <= ',$dates['end_date']);
    }
    $query = $lm->db->select_sum( 'gl_credit')
        ->where( 'gl_account',$account)
        ->where('gl_business',$business)
        ->where('gl_branch',$branch)
        ->from('accounting_general_ledger')
        ->get();
    return ($query->num_rows()>0)? $query->row()->gl_credit : 0;
}

function accountBalance($account){
    $business = runningBusiness()->business_key;
    $branch = runningBranch()->branch_key;
    $lm =& get_instance();
    $query = $lm->db->select('*')
        ->where( 'account_key',$account)
        ->where('account_business',$business)
        ->get('accounting_accounts');

    $acc =  ($query->num_rows()>0)? $query->row() : false;

    if($acc == false ){
        return 0;
    }

    $where = 'gl_'.$acc->account_to_increase;
    $increase = $lm->db->select_sum( $where)
        ->where( 'gl_account',$account)
        ->where('gl_business',$business)
        ->where('gl_branch',$branch)
        ->from('accounting_general_ledger')
        ->get();

    $total_increase =  ($increase->num_rows()>0)? $increase->row()->$where : 0;

    $where = 'gl_'.$acc->account_to_decrease;
    $decrease = $lm->db->select_sum($where)
        ->where('gl_account',$account)
        ->where('gl_business',$business)
        ->where('gl_branch',$branch)
        ->from('accounting_general_ledger')
        ->get();

    $total_decrease =  ($decrease->num_rows()>0)? $decrease->row()->$where : 0;

    return $total_increase - $total_decrease;

}

function payrollAccountBalance($account){
    $business = runningBusiness()->business_key;
    $branch = runningBranch()->branch_key;
    $lm =& get_instance();
    $query = $lm->db->select('*')
        ->where( 'account_key',$account)
        ->where('account_business',$business)
        ->get('accounting_accounts');

    $acc =  ($query->num_rows()>0)? $query->row() : false;

    if($acc == false ){
        return 0;
    }

    $where = 'gl_'.$acc->account_to_increase;
    $increase = $lm->db->select_sum( $where)
        ->where( 'gl_account',$account)
        ->where('gl_business',$business)
        ->where('gl_branch',$branch)
        ->from('accounting_general_ledger')
        ->get();

    $total_increase =  ($increase->num_rows()>0)? $increase->row()->$where : 0;

    $where = 'gl_'.$acc->account_to_decrease;
    $decrease = $lm->db->select_sum($where)
        ->where('gl_account',$account)
        ->where('gl_business',$business)
        ->where('gl_branch',$branch)
        ->from('accounting_general_ledger')
        ->get();

    $total_decrease =  ($decrease->num_rows()>0)? $decrease->row()->$where : 0;

    return $total_increase - $total_decrease;

}

