<?php

function payrollsSettings(){
    $bms =& get_instance();
    $branch = runningBranch()->branch_key;
    $business = runningBusiness()->business_key;
    $bms->db->where('set_branch',$branch);
    $bms->db->where('set_business',$business);
    $settings = $bms->db->get("payroll_settings");
    return $settings->num_rows()>0 ? $settings->row() : false;
}

function topToolBarPayrolls($link=''){?>
    <div class="kt-subheader   kt-grid__item" id="kt_subheader">
        <div class="kt-container  kt-container--fluid ">
            <div class="kt-subheader__main">
                <h3 class="kt-subheader__title">Payrolls</h3>
                <span class="kt-subheader__separator kt-subheader__separator--v"></span>
                <a href="<?php echo base_url('payrolls');?>" class="<?php if($link == 'payrolls') echo 'active';?> btn btn-label-brand btn-bold btn-sm btn-icon-h kt-margin-l-10">
                    Payrolls
                </a>
                <a href="<?php echo base_url('payrolls/insurance');?>"  class="<?php if($link == 'insurance') echo 'active';?> btn btn-label-brand btn-bold btn-sm btn-icon-h kt-margin-l-10">
                    Insurance
                </a>
                <a href="<?php echo base_url('payrolls/deductions');?>"  class="<?php if($link == 'deductions') echo 'active';?> btn btn-label-brand btn-bold btn-sm btn-icon-h kt-margin-l-10">
                    Deductions
                </a>
                <a href="<?php echo base_url('payrolls/allowances');?>"  class="<?php if($link == 'allowances') echo 'active';?> btn btn-label-brand btn-bold btn-sm btn-icon-h kt-margin-l-10">
                    Allowances
                </a>
                <!--            <a href="--><?php //echo base_url('payrolls/benefits');?><!--"  class="--><?php //if($link == 'benefits') echo 'active';?><!-- btn btn-label-brand btn-bold btn-sm btn-icon-h kt-margin-l-10">-->
                <!--                Benefits-->
                <!--            </a>-->
                <!--            <a href="--><?php //echo base_url('payrolls/paye');?><!--"  class="--><?php //if($link == 'paye') echo 'active';?><!-- btn btn-label-brand btn-bold btn-sm btn-icon-h kt-margin-l-10">-->
                <!--                PAYE-->
                <!--            </a>-->
                <a href="<?php echo base_url('payrolls/index/process');?>"  class="<?php if($link == 'process') echo 'active';?> btn btn-label-brand btn-bold btn-sm btn-icon-h kt-margin-l-10">
                    Process
                </a>
                <a href="<?php echo base_url('accounting/settings/payroll');?>"  class="<?php if($link == 'settings') echo 'active';?> btn btn-label-brand btn-bold btn-sm btn-icon-h kt-margin-l-10">
                    Settings
                </a>
            </div>
        </div>
    </div>
<?php }

function topToolBarPayrollsCompany($link=''){?>
    <!-- begin:: Content Head -->
    <div class="kt-subheader   kt-grid__item" id="kt_subheader">
        <div class="kt-container  kt-container--fluid ">
            <div class="kt-subheader__main">
                <h3 class="kt-subheader__title">Payrolls</h3>
                <span class="kt-subheader__separator kt-subheader__separator--v"></span>
                <a href="<?php echo base_url('payrolls/company');?>" class="<?php if($link == 'company') echo 'active';?> btn btn-label-brand btn-bold btn-sm btn-icon-h kt-margin-l-10 text-uppercase">
                    Company Liabilities
                </a>
            </div>
        </div>
    </div>
<?php }

function topToolBarPayrollsEmployees($link=''){?>
    <!-- begin:: Content Head -->
    <div class="kt-subheader   kt-grid__item" id="kt_subheader">
        <div class="kt-container  kt-container--fluid ">
            <div class="kt-subheader__main">
                <h3 class="kt-subheader__title">Payrolls</h3>
                <span class="kt-subheader__separator kt-subheader__separator--v"></span>
                <a href="<?php echo base_url('payrolls/employees');?>" class="<?php if($link == 'employees') echo 'active';?> btn btn-label-brand btn-bold btn-sm btn-icon-h kt-margin-l-10 text-uppercase">
                    Employees Liabilities
                </a>
            </div>
        </div>
    </div>
<?php }

function payeCalculator($amount){

    if($amount < 270001){
        $paye = 0;
    }elseif($amount > 270000 && $amount < 520001){
        $taxable = $amount - 270000;
        $tax = $taxable * 0.09;
        $paye = to_dollar($tax);
    }elseif ($amount > 520000 && $amount < 760001){
        $taxable = $amount - 520000;
        $tax = $taxable * 0.2;
        $paye = to_dollar(17100 + $tax);
    }elseif ($amount > 760000 && $amount < 1000001){
        $taxable = $amount - 760000;
        $tax = $taxable * 0.25;
        $paye = to_dollar(17100 + 36000 + $tax);
    }else{
        $taxable = $amount - 1000000;
        $tax = $taxable * 0.3;
        $paye = to_dollar(17100 + 36000 + 45000 + $tax);
    }
    return $paye;
}

function PAYE_calc($amount){
    /**
     ** @author Elieza Kalaita
     *
    * Monthly Income Tax Payable after deducting PPF, NSSF or PSPF Contribution
    *
    * Where total income does not exceed Tshs 270,000/=     NIL
    *
    * Where total income exceeds Tshs 270,000/= but does not exceed 520,000/=
    * 9% of the amount in excess of Tshs 270,000/=
    *
    * Where total income exceeds shs. 520,000/= but does not exceed 760,000/=
    * Tshs 22,500/= plus 20% of the amount in excess of Tshs 520,000/=
    *
    * Where total income exceeds 760,000/= but does not exceed 1,000,000/=
    * Tshs 70,500/= plus 25% of the amount in excess of Tshs 760,000/=
    *
    * Where total income exceeds Tshs 1,000,000/=
    * Tshs 130,500/= plus 30% of the amount in excess of Tshs 1,000,000/=
    *
     **/

    if($amount <= 270000){
        $paye = 0;
    }elseif($amount > 270000 && $amount <= 520000){
        $paye = 0.09 * ($amount - 270000);
    } elseif($amount > 520000 && $amount <= 760000){
        $paye = 22500 + 0.2 * ($amount - 520000);
    } elseif($amount > 760000 && $amount <= 1000000){
        $paye = 70500 + 0.25 * ($amount - 760000);
    } elseif($amount > 1000000){
        $paye = 130500 + 0.3 * ($amount - 1000000);
    }
    return $paye;
}

function payeCalculator1($amount){

    if($amount < 170001){
        $paye = 0;
    }elseif($amount > 170000 && $amount < 360001){
        $taxable = $amount - 170000;
        $tax = $taxable * 0.09;
        $paye = to_dollar($tax);
    }elseif ($amount > 360000 && $amount < 540001){
        $taxable = $amount - 360000;
        $tax = $taxable * 0.2;
        $paye = to_dollar(17100 + $tax);
    }elseif ($amount > 540000 && $amount < 720001){
        $taxable = $amount - 540000;
        $tax = $taxable * 0.25;
        $paye = to_dollar(17100 + 36000 + $tax);
    }else{
        $taxable = $amount - 720000;
        $tax = $taxable * 0.3;
        $paye = to_dollar(17100 + 36000 + 45000 + $tax);
    }
    return $paye;
}

function isEmployeeTax($employee,$tax){
    $bms =& get_instance();
    //$store = $bms->storesModel->store()->store_key;
    //$business = $bms->businessModel->business(profile()->user_business)->business_key;
    $bms->db->where('et_tax_key',$tax);
    $bms->db->where('et_employee_key',$employee);
    $query = $bms->db->get('employee_taxes');
    return $query->num_rows()>0 ? $query->row() : FALSE;
}

function isProcessedThisMonth($employee){
    $dt = date('Y-m-d');
    $firstday = date("Y-m-01", strtotime($dt));
    $lastday = date("Y-m-t", strtotime($dt));
    $bms =& get_instance();
    $bms->db->where('payroll_timestamp >=',$firstday);
    $bms->db->where('payroll_timestamp <=',$lastday);
    $bms->db->where('payroll_employee',$employee);
    $query = $bms->db->get('employees_payroll');
    return $query->num_rows()>0 ? $query->row() : FALSE;
}

function isProcessedThisMonth1($employee){
    $dt = date('Y-m-d');
    $firstday = date("Y-m-01", strtotime($dt));
    $lastday = date("Y-m-t", strtotime($dt));
    $bms =& get_instance();
    $bms->db->where('payroll_date >=',$firstday);
    $bms->db->where('payroll_date <=',$lastday);
    $bms->db->where('payroll_employee',$employee);
    $query = $bms->db->get('employees_payroll');
    return $query->num_rows()>0 ? $query->row() : FALSE;
}

function lastProcessed($employee){
    $bms =& get_instance();
    $bms->db->select_max('payroll_timestamp');
    //$bms->db->select_max('payroll_date');
    $bms->db->where('payroll_employee',$employee);
    $query = $bms->db->get('employees_payroll');
    return $query->num_rows()>0 ? $query->row() : FALSE;
}

function firstlastdate($point){
    $dt = date('Y-m-d');
    $firstday = date("Y-m-01", strtotime($dt));
    $lastday = date("Y-m-t", strtotime($dt));
    switch ($point) {
        case 'first':
            return $firstday;
            break;
        case 'last':
            return $lastday;
        default:
            return $dt;
            break;
    }
}

function employee_payroll($key){
    $bms =& get_instance();
    $branch = runningBranch()->branch_key;
    $business = runningBusiness()->business_key;

    $query = $bms->db->where('payroll_employee',$key)
        ->where('employee_branch',$branch)
        ->where('employee_business',$business)
        ->get('employees_payroll');
    return !empty($query) && $query->num_rows()>0? $query->row() : false;
}

function employee_allowance($key){
    $bms =& get_instance();
    $branch = runningBranch()->branch_key;
    $business = runningBusiness()->business_key;

    $query = $bms->db->where('allowance_employee',$key)
        ->where('allowance_branch',$branch)
        ->where('allowance_business',$business)
        ->get('employees_allowances');

    return !empty($query) && $query->num_rows()>0 ? $query->result_array(): false;
}

function employee_allowance_total($key){
    $bms =& get_instance();
    $branch = runningBranch()->branch_key;
    $business = runningBusiness()->business_key;

    $query = $bms->db->where('allowance_employee',$key)
        ->where('allowance_branch',$branch)
        ->where('allowance_business',$business)
        ->select_sum('allowance_value','total')
        ->get('employees_allowances');

    return !empty($query) && $query->num_rows()>0 ? $query->row()->total: 0;
}

function employee_insurance($key){
    $bms =& get_instance();
    $branch = runningBranch()->branch_key;
    $business = runningBusiness()->business_key;

    $query = $bms->db->where('insurance_employee',$key)
        ->where('insurance_branch',$branch)
        ->where('insurance_business',$business)
        ->get('employees_insurance');

    return !empty($query) && $query->num_rows()>0 ? $query->result_array(): false;
}

function employee_insurance_total($key){
    $bms =& get_instance();
    $branch = runningBranch()->branch_key;
    $business = runningBusiness()->business_key;

    $query = $bms->db->where('insurance_employee',$key)
        ->where('insurance_branch',$branch)
        ->where('insurance_business',$business)
        ->select_sum('employee_cost','percent')
        ->select_sum('employee_cost_amount','amount')
        ->get('employees_insurance');

    return !empty($query) && $query->num_rows()>0 ? $query->row(): 0;
}

function employee_deductions($key){
    $bms =& get_instance();
    $branch = runningBranch()->branch_key;
    $business = runningBusiness()->business_key;

    $query = $bms->db->where('emp_deduction_employee',$key)
        //->where('deduction_branch',$branch)
        //->where('deduction_business',$business)
        ->join('payroll_deductions pd','pd.deduction_key=emp_deduction_key','left')
        ->get('employees_deductions');

    return !empty($query) && $query->num_rows()>0 ? $query->result_array(): false;
}

function employee_deductions_total($key){
    $bms =& get_instance();
    $branch = runningBranch()->branch_key;
    $business = runningBusiness()->business_key;

    $query = $bms->db->where('emp_deduction_employee',$key)
        ->where('deduction_branch',$branch)
        ->where('deduction_business',$business)
        ->select_sum('deduction_value','total')
        ->get('employees_deductions');

    return !empty($query) && $query->num_rows()>0 ? $query->row()->total: 0;
}

function employee_benefits($key){
    $bms =& get_instance();
    $branch = runningBranch()->branch_key;
    $business = runningBusiness()->business_key;

    $query = $bms->db->where('benefit_employee',$key)
        ->where('benefit_branch',$branch)
        ->where('benefit_business',$business)
        ->get('employees_benefits');

    return !empty($query) && $query->num_rows()>0 ? $query->result_array(): false;
}

function employee_benefits_total($key){
    $bms =& get_instance();
    $branch = runningBranch()->branch_key;
    $business = runningBusiness()->business_key;

    $query = $bms->db->where('benefit_employee',$key)
        ->where('benefit_branch',$branch)
        ->where('benefit_business',$business)
        ->select_sum('benefit_value','total')
        ->get('employees_benefits');

    return !empty($query) && $query->num_rows()>0 ? $query->row()->total: 0;
}