<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Dashboard
 *
 * @author test
 */
class Index extends MY_Controller{

    public  $appdata;

    function __construct() {
        parent::__construct();

        $this->require_min_level(1);
        $this->appdata['title']= 'Tax Manager';
        $this->load->model(array(
            'taxes/TaxesModel'=>'taxesModel',
        ));
        $this->load->helper('taxes/helper');
    }

    function index() {
        $this->load->helper('form');
        $this->appdata['link']= 'taxes';
        $this->load->vars($this->appdata);
        $this->load->view('taxes/taxes');
    }

    function classes() {
        $this->load->helper('form');
        $this->appdata['link']= 'taxes';
        $this->load->vars($this->appdata);
        $this->load->view('taxes/tax_classes');
    }

    function settaxclassstatus($tax='',$status=''){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $this->db->trans_start();
        $data['tax_class_status'] = urldecode($status);
        $this->db->where('tax_class_key',$tax);
        $this->db->update('tax_class_key',$data);

        $this->db->trans_complete();
        if($this->db->trans_status() === TRUE){
            publishEventFlash("tax_class_updated");
            $results['message'] = 'Changes applied successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to save changes';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function settaxstatus($tax='',$status=''){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $this->db->trans_start();

        $data['tax_status'] = urldecode($status);
        $this->db->where('tax_key',$tax);
        $this->db->update('taxes',$data);

        $this->db->trans_complete();
        if($this->db->trans_status() === TRUE){
            publishEventFlash("tax_updated");
            $results['message'] = 'Changes applied successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to save changes';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function taxdetails($tax='') {
        $this->load->helper('form');
        $this->appdata['tax'] = $this->taxesModel->taxDetails($tax);
        $this->load->vars($this->appdata);
        $this->load->view('taxes/tax_details');
    }

    function taxclassdetails($tax='') {
        $this->load->helper('form');
        $this->appdata['class']= $this->taxesModel->taxClassDetails($tax);
        $this->load->vars($this->appdata);
        $this->load->view('taxes/class_details');
    }
    
    function deleteclass($tax)
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $this->db->where('tax_class_key',$tax);
        $this->db->delete('tax_classes');

        if($this->db->affected_rows()>0){
            publishEventFlash("tax_class_updated");
            $results['message'] = 'Class deleted successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to delete Class';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function deletetax($tax)
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $this->db->where('tax_key',$tax);
        $this->db->delete('taxes');

        if($this->db->affected_rows()>0){
            publishEventFlash("tax_updated");
            $results['message'] = 'Tax deleted successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to delete Tax';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }
    
    function updatetax()
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $data['tax_title'] = $this->input->get("tax_title",TRUE);
        $data['tax_class'] = $this->input->get("tax_class",TRUE);
        $data['tax_type_value'] = $this->input->get("tax_type_value",TRUE);
        $data['tax_type'] = $this->input->get("tax_type",TRUE);
        $data['tax_status'] = $this->input->get("tax_status",TRUE);

        $tax = $this->input->get("tax_key",TRUE);

        $this->db->where('tax_key',$tax);
        $this->db->update('taxes',$data);

        if($this->db->affected_rows()>0){
            publishEventFlash("tax_updated");
            $results['message'] = 'Tax changed successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to update Tax';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function updatetaxclass()
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $class = $this->input->get("tax_class_key",TRUE);
        $data['tax_class_title'] = $this->input->get("tax_class_title",TRUE);
        $data['tax_class_details'] = $this->input->get("tax_class_details",TRUE);
        $data['tax_class_status'] = $this->input->get("tax_class_status",TRUE);

        $this->db->where('tax_class_key',$class);
        $this->db->update('tax_classes',$data);

        if($this->db->affected_rows()>0){
            publishEventFlash("tax_class_updated");
            $results['message'] = 'Tax Class changed successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to update Class';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function createtax()
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $data['tax_business'] = runningBusiness()->business_key;
        $data['tax_branch'] = runningBranch()->branch_key;
        $data['tax_status'] = $this->input->get('tax_status', TRUE);
        $data['tax_class'] = $this->input->get('tax_class', TRUE);
        $data['tax_type'] = $this->input->get('tax_type', TRUE);
        $data['tax_title'] = $this->input->get('tax_title', TRUE);
        $data['tax_type_value'] = $this->input->get('tax_type_value', TRUE);
        $data['tax_key'] = $this->taxesModel->taxKey();

        $this->db->trans_start();

        $this->db->insert('taxes', $data);
        $this->db->trans_complete();
        if ($this->db->trans_status() == TRUE) {
            publishEventFlash("tax_register");
            $results['message'] = 'Tax registered successfully ';
            $results['status'] = true;

            } else {
                $results['message'] = 'Failed to register Tax';
                $results['status'] = false;
            }

            echo json_encode($results, JSON_PRETTY_PRINT);
        }

    function createtaxclass()
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $data['tax_class_details'] = $this->input->post("tax_class_details",TRUE);
        $data['tax_class_business'] = runningBusiness()->business_key;
        $data['tax_class_branch'] = runningBranch()->branch_key;
        $data['tax_class_status'] = $this->input->get('tax_class_status', TRUE);
        $data['tax_class_title'] = $this->input->get('tax_class_title', TRUE);
        $data['tax_class_key'] = $this->taxesModel->taxClassKey();

        $this->db->trans_start();

        $this->db->insert('tax_classes', $data);
        $this->db->trans_complete();
        if ($this->db->trans_status() == TRUE) {
            publishEventFlash("tax_class_register");
            $results['message'] = 'Tax Class registered successfully ';
            $results['status'] = true;

        } else {
            $results['message'] = 'Failed to register Tax Class';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function datasourcetaxes($when=''){
      $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
      $taxes = $this->taxesModel->taxes($when);
      $columns = [
        'tax_key' => true,
        'tax_title' => true,
        'tax_class_title' => true,
        'tax_class_key' => true,
        'tax_status' => true,
        'tax_created_at' => true,
        'date' => true,
        'tax_type' => true,
        'tax_type_value' => true,
      ];
      print $this->datasourceLibrary->server($taxes,$columns);
    }

    function datasourcetaxclasses($when=''){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $classes = $this->taxesModel->taxClasses($when);
        $columns = [
            'date' => true,
            'tax_class_key' => true,
            'tax_class_title' => true,
            'tax_class_details' => true,
            'tax_class_status' => true,
            'tax_class_created' => true,
        ];
        print $this->datasourceLibrary->server($classes,$columns);
    }

    function get_total_taxes(){

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $taxes = array();

        if(!empty($get = $this->input->get('values'))){
            $taxes = $get;
        }

        if(!empty($post = $this->input->post('value'))){
            $taxes = $post;
        }

        $total = 0;

            foreach ($taxes as $row){
                $tax = $this->taxesModel->taxDetails($row);
                if(strtolower($tax->tax_type) == "percentage"){
                    $total  +=  round(($this->taxesModel->taxDetails($row)->tax_type_value / 100),2);
                }
            }


        $result['total'] = $total;
        print json_encode($result, JSON_PRETTY_PRINT);
    }

    function get_total_tax(){

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $class = null;

        if(!empty($get = $this->input->get('value'))){
            $class = $get;
        }

        if(!empty($post = $this->input->post('value'))){
            $class = $post;
        }

        $taxes = $this->db->where('tax_class',$class)->get('bms_taxes')->result_array();

        $total = 0;

        foreach ($taxes as $tax){
            if(strtolower($tax['tax_type']) == "percentage"){
                $total  +=  round(($tax['tax_type_value'] / 100),2);
            }
        }


        $result['total'] = $total;
        print json_encode($result, JSON_PRETTY_PRINT);
    }

}
