<?php


class Projects extends MY_Controller {
    public $pagedata;
    public $branch;
    public $business;

    public function __construct() {
        parent::__construct();
        ($this->require_min_level(1));
        $this->pagedata['link']= 'projects';
        $this->load->model(array(
            'task/ProjectModel'=>'projectModel',
            'hrm/Employees'=>'employeesModel',
        ));
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
        $this->load->helper('task/task_helper');
    }

    public function index() {
        has_control('employee_view_all','View all employees');
        $this->pagedata['link'] = 'projects';
        $this->pagedata['title'] = 'Projects | '.$this->config->item('application_name');
        $this->pagedata['projects'] = $this->projectModel->projects();
        $this->load->vars($this->pagedata);
        $this->load->view('task/projects');
    }

    public function ongoing() {
        has_control('employee_view_all','View all employees');
        $this->pagedata['link'] = 'projects';
        $this->pagedata['title'] = 'Projects | '.$this->config->item('application_name');
        $this->pagedata['projects'] = $this->projectModel->ongoing_projects();
        $this->load->vars($this->pagedata);
        $this->load->view('task/ongoing_projects');
    }

    public function finished() {
        has_control('employee_view_all','View all employees');
        $this->pagedata['link'] = 'projects';
        $this->pagedata['title'] = 'Projects | '.$this->config->item('application_name');
        $this->pagedata['projects'] = $this->projectModel->ongoing_projects();
        $this->load->vars($this->pagedata);
        $this->load->view('task/finished_projects');
    }

    function datasourceProject(){
        $data = $this->projectModel->projects();
        $columnsDefault = [
            'project_key' => true,
            'project_title' => true,
            'project_client' => true,
            'project_start_date' => true,
            'project_end_date' => true,
            'project_budget' => true,
            'project_status' => true,
        ];
        $this->sourcedataserver($data,$columnsDefault);
    }

    function datasourceProjectOngoing(){
        $data = $this->projectModel->ongoing_projects();
        $columnsDefault = [
            'project_key' => true,
            'project_title' => true,
            'project_client' => true,
            'project_start_date' => true,
            'project_end_date' => true,
            'project_budget' => true,
            'project_status' => true,
        ];
        $this->sourcedataserver($data,$columnsDefault);
    }

    function datasourceProjectFinished(){
        $data = $this->projectModel->finished_projects();
        $columnsDefault = [
            'project_key' => true,
            'project_title' => true,
            'project_client' => true,
            'project_start_date' => true,
            'project_end_date' => true,
            'project_budget' => true,
            'project_status' => true,
        ];
        $this->sourcedataserver($data,$columnsDefault);
    }


    function newProject(){
        $project['project_title'] = $this->input->get('project_title',TRUE);
        $project['project_client'] = $this->input->get('project_client',TRUE);
        $project['project_deadline'] = $this->input->get('project_deadline',TRUE);
        $project['project_budget'] = $this->input->get('project_budget',TRUE);
        $project['project_desc'] = $this->input->get('project_desc',TRUE);
        $project['project_start_date'] = $this->input->get('project_start_date',TRUE);
        $project['project_end_date'] = $this->input->get('project_end_date',TRUE);
        $project['project_date_created'] = date('Y-m-d');
        $project['project_time_created'] = $this->input->get('project_time_created',TRUE);

        if (!empty($this->input->get('uploadedfiles'))) {
            $raw = explode('LM-55', $_GET['uploadedfiles']);
            foreach ($raw as $key => $file) {
                $file = unserialize($file);
                if (is_array($file)) {
                    foreach ($file as $dt) {
                        if (!empty($dt)) {
                            $project['project_client_image'] = $dt['project_client_image'];
                        }
                    }
                }
            }
        }
        if($this->projectModel->createProject($project)){
            $result['status'] = 'ok';
            $result['message'] = 'Project registered successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function uploadexpensedocs(){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        $uploadPath = uploadPath('project_client_image/');
        $config['upload_path'] = $uploadPath;
        $config['file_ext_tolower']     = TRUE;
        $config['encrypt_name']         = TRUE;
        $config['allowed_types'] = 'jpg|jpeg|png|docx|doc|pdf|xls|xlsx';

        // Load and initialize upload library
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        $i  = 0;
        if($this->upload->do_upload('file')){
            // Uploaded file data
            $fileData = $this->upload->data();
            $uploadData[$i]['project_client_image'] = $fileData['file_name'];
        }

        if(!empty($uploadData)){
            $files = array();
            $result['status'] = true;
            foreach ($uploadData as $key => $file){
                $files[$key]['project_client_image'] = $file['project_client_image'];
            }
            $result['files'] = serialize($files);
        }else{
            $result['status'] = false;
            $result['files'] = '';
        }

        echo json_encode($result, JSON_PRETTY_PRINT);
    }

    public function modifyProject($projectKey='') {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        $this->pagedata['project'] = $this->projectModel->select_one_project($projectKey);
        $this->load->vars($this->pagedata);
        $this->load->view('task/projectModify');
    }

    function updateProject($projectKey='') {
        $data['project_title'] = $this->input->get('project_title',TRUE);
        $data['project_client'] = $this->input->get('project_client',TRUE);
        $data['project_deadline'] = $this->input->get('project_deadline',TRUE);
        $data['project_budget'] = $this->input->get('project_budget',TRUE);
        $data['project_desc'] = $this->input->get('project_desc',TRUE);
        $data['project_status'] = $this->input->get('project_status',TRUE);
        $data['project_progress'] = $this->input->get('project_progress',TRUE);
        $data['project_start_date'] = $this->input->get('project_start_date',TRUE);
        $data['project_end_date'] = $this->input->get('project_end_date',TRUE);
        if($this->projectModel->projectUpdate($projectKey,$data)){
            $result['status'] = 'ok';
            $result['message'] = 'Project updated successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    public function projectDetails($key='') {
        $this->load->helper('form');
        $this->pagedata['link']= 'projects';
        $this->pagedata['title'] = 'Project | '.$this->config->item('application_name');
        $this->pagedata['project'] = $this->projectModel->select_one_project($key);
        $this->load->vars($this->pagedata);
        $this->load->view('task/project_details');
    }

    public function deleteProject($flag,$key) {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        switch ($flag) {
            case 'project':
                if($this->projectModel->deleteProject($key)){
                    $result['status'] = 'ok';
                    $result['message'] = 'Task deleted';
                }else{
                    $result['status'] = 'no';
                    $result['message'] = checkError($this->dbexeption());
                }
                print json_encode($result);
                break;
            default:
                $result['status'] = 'no';
                $result['message'] = 'No action';
                print json_encode($result);
                break;
        }
    }

}