<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Dashboard
 *
 * @author test
 */

class Index extends MY_Controller{

    public  $appdata;

    function __construct() {
        parent::__construct();

        $this->require_min_level(1);
        $this->appdata['title']= 'Quotation Manager';
        $this->load->model(array(
            'quotations/QuotationsModel'=>'quotationsModel',
            'freight/FreightsModel'=>'freightsModel'
        ));
        $this->load->library(array('qrcode/Qrcodes'=>'qrcodes'));
        $this->load->helper('quotations/helper');
        $this->appdata['link']= 'quotations';
    }

    function index($hash="") {
        $this->load->helper('form');
        $this->appdata['link']= 'quotations';
        $this->appdata['hash']= $hash;
        $this->load->vars($this->appdata);
        $this->load->view('quotations/quotations');
    }

    function filtered($hash="") {
        $this->load->helper('form');
        $this->appdata['link']= 'quotations';
        $this->appdata['hash']= $hash;
        $this->load->vars($this->appdata);
        $this->load->view('quotations/quotations');
    }

    function create() {
        $this->load->model(array('taxes/taxesModel' => 'taxesModel','accounting/accounting' => 'accountingModel'));
        if($this->tokens->match) {
            $this->db->trans_start();
            $invoice = array(
                'quot_payer' => $this->input->post('bms_client',TRUE),
                'quot_issued_date' => date('Y-m-d H:i:s', strtotime($this->input->post('quot_issued_date', TRUE))),
                'quot_status' => $this->input->post('quot_status',TRUE),
                'quot_total_before_tax' => to_dollar(toNumber($this->input->post('quot_sub_total', TRUE))),
                'quot_total_tax' => to_dollar(toNumber($this->input->post('quot_total_tax', TRUE))),
                'quot_total_after_tax' => to_dollar(toNumber($this->input->post('quot_total_after_tax', TRUE))),
                'quot_total_paid' => 0,
                'quot_total_balance' => to_dollar(toNumber($this->input->post('quot_total_after_tax', TRUE))),
                'quot_address' => $this->input->post('quot_address', TRUE),
                'quot_details' => $this->input->post('quot_details', TRUE),
            );
            $invoiceKey = $this->quotationsModel->insert($invoice);

            if(!empty($items = $this->input->post('group_items'))){
                foreach ($items as $item){
                    $itemData['quot_data_item_tax_inclusive'] = $item['quot_item_tax_inclusive'];
                    $itemData['quot_data_item'] = $item['quot_item'];
                    $itemData['quot_data_item_details'] = $item['quot_item_details'];
                    $itemData['quot_data_item_qty'] = $item['quot_item_qty'];
                    $itemData['quot_data_item_price'] = to_dollar(toNumber($item['quot_item_price']));
                    $itemData['quot_data_item_before_tax'] = to_dollar(toNumber($item['quot_item_before_tax']));
                    $itemData['quot_data_item_tax'] = $item['quot_item_tax'];
                    $itemData['quot_data_item_tax_percent'] = $item['quot_item_tax_percent'];
                    $itemData['quot_data_item_tax_value'] = to_dollar(toNumber($item['quot_item_tax_value']));
                    $itemData['quot_data_item_after_tax'] = to_dollar(toNumber($item['quot_item_after_tax']));
                    $itemData['quot_data_item_quotation'] = $invoiceKey;
                    $this->db->insert('quotation_data_items',$itemData);
                }
            }

            $this->db->trans_complete();
            if ($this->db->trans_status() === TRUE) {
                $this->appdata['form_action'] = TRUE;
                $this->appdata['form_message'] = "Congratulation! Quotation created successfully";
                $this->appdata['form_class'] = "success";
            } else {
                $this->appdata['form_action'] = FALSE;
                $this->appdata['form_message'] = "We could not process request successfully please try again later";
                $this->appdata['form_class'] = "danger";
            }
        }

        $this->load->helper('form');
        $this->appdata['link']= 'quotations';
        $this->load->vars($this->appdata);
        $this->load->view('quotations/create_taxing');
    }

    function details($key='') {
        $this->load->model(array('taxes/taxesModel' => 'taxesModel','accounting/accounting' => 'accountingModel'));
        $this->load->helper('form');
        $this->appdata['quotation']= $this->quotationsModel->find($key);
        $this->appdata['items']= $this->quotationsModel->quotationItems($this->appdata['quotation']['quot_id']);
        $this->appdata['taxes']= $this->quotationsModel->quotationTaxes($this->appdata['quotation']['quot_id']);
        $this->load->vars($this->appdata);
        $this->load->view('quotations/details');
    }

    function modify($key='') {
        $this->load->model(array('taxes/taxesModel' => 'taxesModel','accounting/accounting' => 'accountingModel'));
        if($this->tokens->match) {
            $this->db->trans_start();
            $invoice = array(
                'quot_issued_date' => date('Y-m-d H:i:s', strtotime($this->input->post('quot_issued_date', TRUE))),
                'quot_status' => $this->input->post('quot_status',TRUE),
                'quot_total_before_tax' => to_dollar(toNumber($this->input->post('quot_sub_total', TRUE))),
                'quot_total_tax' => to_dollar(toNumber($this->input->post('quot_total_tax', TRUE))),
                'quot_total_after_tax' => to_dollar(toNumber($this->input->post('quot_total_after_tax', TRUE))),
                'quot_total_paid' => 0,
                'quot_total_balance' => to_dollar(toNumber($this->input->post('quot_total_after_tax', TRUE))),
                'quot_address' => $this->input->post('quot_address', TRUE),
                'quot_details' => $this->input->post('quot_details', TRUE),
            );

            $this->quotationsModel->update($key,$invoice);
            $id = $this->quotationsModel->find($key);

            if(!empty($items = $this->input->post('group_items'))){
                $this->db->where('quot_data_item_quotation',$id['quot_id']);
                $this->db->delete('quotation_data_items');
                foreach ($items as $item){
                    $itemData['quot_data_item_tax_inclusive'] = $item['quot_item_tax_inclusive'];
                    $itemData['quot_data_item'] = $item['quot_item'];
                    $itemData['quot_data_item_details'] = $item['quot_item_details'];
                    $itemData['quot_data_item_qty'] = $item['quot_item_qty'];
                    $itemData['quot_data_item_price'] = to_dollar(toNumber($item['quot_item_price']));
                    $itemData['quot_data_item_before_tax'] = to_dollar(toNumber($item['quot_item_before_tax']));
                    $itemData['quot_data_item_tax'] = $item['quot_item_tax'];
                    $itemData['quot_data_item_tax_percent'] = $item['quot_item_tax_percent'];
                    $itemData['quot_data_item_tax_value'] = to_dollar(toNumber($item['quot_item_tax_value']));
                    $itemData['quot_data_item_after_tax'] = to_dollar(toNumber($item['quot_item_after_tax']));
                    $itemData['quot_data_item_quotation'] = $id['quot_id'];
                    $this->db->insert('quotation_data_items',$itemData);
                }
            }

            $this->db->trans_complete();
            if ($this->db->trans_status() === TRUE) {
                $this->appdata['form_action'] = TRUE;
                $this->appdata['form_message'] = "Congratulation! Quotation updated successfully";
                $this->appdata['form_class'] = "success";
            } else {
                $this->appdata['form_action'] = FALSE;
                $this->appdata['form_message'] = "We could not process request successfully please try again later";
                $this->appdata['form_class'] = "danger";
            }
        }
        $this->load->helper('form');
        $this->appdata['quotation']= $this->quotationsModel->find($key);
        $this->appdata['items']= $this->quotationsModel->quotationItems($this->appdata['quotation']['quot_id']);
        $this->appdata['taxes']= $this->quotationsModel->quotationTaxes($this->appdata['quotation']['quot_id']);
        $this->load->vars($this->appdata);
        $this->load->view('quotations/modify');
    }

    function toinvoice($key='') {
        $this->load->model(array('taxes/taxesModel' => 'taxesModel','accounting/accounting' => 'accountingModel','invoices/InvoicesModel'=>'invoicesModel',));
        $this->load->helper('invoices/helper');
        $this->load->helper('accounting/accounting');
        $quote = $this->quotationsModel->find($key);
        if($quote['quot_status'] != "invoice"){
            if($this->tokens->match) {

                $this->db->trans_start();
//                $invoice = array(
//                    'inv_payer' => $this->input->post('bms_client',TRUE),
//                    'inv_issued_date' => date('Y-m-d H:i:s', strtotime($this->input->post('quot_issued_date', TRUE))),
//                    'inv_expiring_date' => date('Y-m-d H:i:s', strtotime($this->input->post('quot_expiring_date', TRUE))),
//                    'inv_status' => "UNPAID",
//                    'inv_tax_inclusive' => !empty($this->input->post('quot_tax_inclusive', TRUE)) ? TRUE : FALSE,
//                    'inv_total_after_tax' => to_dollar(toNumber($this->input->post('quot_total_after_tax', TRUE))),
//                    'inv_custom' => to_dollar(toNumber($this->input->post('quot_custom', TRUE))),
//                    'inv_total_tax' => to_dollar(toNumber($this->input->post('quot_total_tax', TRUE))),
//                    'inv_untaxed' => to_dollar(toNumber($this->input->post('quot_untaxed', TRUE))),
//                    'inv_total' => to_dollar(toNumber($this->input->post('quot_total', TRUE))),
//                    'inv_total_balance' => to_dollar(toNumber($this->input->post('quot_total', TRUE))),
//                    'inv_total_paid' => 0,
//                    'inv_sub_total' => to_dollar(toNumber($this->input->post('quot_sub_total', TRUE))),
//                    'inv_address' => $this->input->post('quot_address', TRUE),
//                    'inv_details' => $this->input->post('quot_details', TRUE),
//                    'inv_credit_account' => $this->input->post('inv_credit_account', TRUE),
//                    'inv_debit_account' => $this->input->post('inv_debit_account', TRUE)
//                );

                $invoice = array(
                    'inv_payer' => $this->input->post('bms_client',TRUE),
                    'inv_issued_date' => date('Y-m-d H:i:s', strtotime($this->input->post('quot_issued_date', TRUE))),
                    'inv_expiring_date' => date('Y-m-d H:i:s', strtotime($this->input->post('quot_expiring_date', TRUE))),
                    'inv_status' => $this->input->post('quot_status',TRUE),
                    'inv_total_after_tax' => to_dollar(toNumber($this->input->post('quot_total_after_tax', TRUE))),
                    'inv_total_before_tax' => to_dollar(toNumber($this->input->post('quot_sub_total', TRUE))),
                    'inv_total_tax' => to_dollar(toNumber($this->input->post('quot_total_tax', TRUE))),
                    'inv_total_balance' => to_dollar(toNumber($this->input->post('quot_total_after_tax', TRUE))),
                    'inv_total_paid' => 0,
                    'inv_address' => $this->input->post('quot_address', TRUE),
                    'inv_details' => $this->input->post('quot_details', TRUE),
                    'inv_credit_account' => $this->input->post('inv_receivable_account', TRUE),
                    'inv_debit_account' => $this->input->post('inv_revenue_account', TRUE)
                );

                $id = $this->invoicesModel->insert($invoice);
                if($id){
                    $invoice = array(
                        'quot_status' => "INVOICE",
                    );

                    $this->quotationsModel->update($key,$invoice);
                }

                if(!empty($items = $this->input->post('group_items'))){
                    $this->db->where('quot_data_item_quotation',$id['quot_id']);
                    $this->db->delete('quotation_data_items');
                    foreach ($items as $item){
                        $itemData['inv_data_item_tax_inclusive'] = $item['quot_item_tax_inclusive'];
                        $itemData['inv_data_item'] = $item['quot_item'];
                        $itemData['inv_data_item_details'] = $item['quot_item_details'];
                        $itemData['inv_data_item_qty'] = $item['quot_item_qty'];
                        $itemData['inv_data_item_price'] = to_dollar(toNumber($item['quot_item_price']));
                        $itemData['inv_data_item_before_tax'] = to_dollar(toNumber($item['quot_item_before_tax']));
                        $itemData['inv_data_item_tax'] = $item['quot_item_tax'];
                        $itemData['inv_data_item_tax_percent'] = $item['quot_item_tax_percent'];
                        $itemData['inv_data_item_tax_value'] = to_dollar(toNumber($item['quot_item_tax_value']));
                        $itemData['inv_data_item_after_tax'] = to_dollar(toNumber($item['quot_item_after_tax']));
                        $itemData['inv_data_item_invoice'] = $id;
                        $this->db->insert('invoice_data_items',$itemData);

//                        $itemData['inv_data_item'] = $item['quot_item'];
//                        $itemData['inv_data_item_details'] = $item['quot_item_details'];
//                        $itemData['inv_data_item_qty'] = $item['quot_item_qty'];
//                        $itemData['inv_data_item_price'] = to_dollar(toNumber($item['quot_item_price']));
//                        $itemData['inv_data_item_total'] = to_dollar(toNumber($item['quot_item_total']));
//                        $itemData['inv_data_item_invoice'] = $id;
//                        $this->db->insert('invoice_data_items',$itemData);
                    }
                }

                if(!empty($taxes = $this->input->post('taxes'))){
                    foreach ($taxes as $item){
                        $taxData['inv_data_tax_tax'] = $item;
                        $taxData['inv_data_tax_value'] = $this->taxesModel->taxDetails($item)->tax_type_value;
                        $taxData['inv_data_tax_invoice'] = $id;
                        $this->db->insert('invoice_data_taxes',$taxData);
                    }
                }
                $this->quotationsModel->update($key,['quot_status'=>'INVOICE']);
                $this->db->trans_complete();
                if ($this->db->trans_status() === TRUE) {
                    $this->appdata['form_action'] = TRUE;
                    $this->appdata['form_message'] = "Congratulation! Your Quotation was successfully converted to INVOICE";
                    $this->appdata['form_class'] = "success";
                } else {
                    $this->appdata['form_action'] = FALSE;
                    $this->appdata['form_message'] = "We could not process request successfully please try again later";
                    $this->appdata['form_class'] = "danger";
                }
            }
        }


        $this->load->helper('form');
        $this->appdata['quotation'] = $this->quotationsModel->find($key);
        $this->appdata['items']= $this->quotationsModel->quotationItems($this->appdata['quotation']['quot_id']);
        $this->appdata['taxes']= $this->quotationsModel->quotationTaxes($this->appdata['quotation']['quot_id']);
        $this->load->vars($this->appdata);
        $this->load->view('quotations/toinvoice');
    }

    function sourcequotations($hash=''){
      $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
      if(!empty($hash)){
          $invocies = $this->quotationsModel->order_by('quot_created_on', 'DESC')->find_many_by(["quot_status" => $hash]);
      }else{
          $invocies = $this->quotationsModel->order_by('quot_created_on', 'DESC')->find_all();
      }

      $columns = array();
      foreach ($this->quotationsModel->selectable_fields as $field){
          $columns[$field] = TRUE;
      }
      print $this->datasourceLibrary->server($invocies,$columns);
    }

    function sourcequotationsbin($hash=''){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        if(!empty($hash)){
            $this->quotationsModel->where('quot_deleted',1);
            $invocies = $this->quotationsModel->with_deleted()->find_many_by(["quot_status" => $hash]);
        }else{
            $this->quotationsModel->where('quot_deleted',1);
            $invocies = $this->quotationsModel->with_deleted()->find_all();
        }

        $columns = array();
        foreach ($this->quotationsModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($invocies,$columns);
    }

    function deleteinv($inv)
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

            $business = runningBusiness()->business_key;
            $branch = runningBranch()->branch_key;
            $this->quotationsModel->where('quot_business',$business);
            $this->quotationsModel->where('quot_branch',$branch);
            if($this->quotationsModel->delete($inv)){
                $results['message'] = 'Quotation deleted successfully';
                $results['status'] = true;
            }else{
                $results['message'] = 'Failed to delete Quotation';
                $results['status'] = false;
            }


        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function deleteinvforever($inv)
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

            $business = runningBusiness()->business_key;
            $branch = runningBranch()->branch_key;
            $this->quotationsModel->where('quot_business',$business);
            $this->quotationsModel->where('quot_branch',$branch);
            $this->quotationsModel->soft_delete(FALSE);
            if($this->quotationsModel->delete($inv)){
                $this->load->model(array('quotations/QuotationTransactionsModel' => 'invoiceTransactionsModel'));
                $results['message'] = 'Quotation deleted successfully';
                $results['status'] = true;
            }else{
                $results['message'] = 'Failed to delete Quotation';
                $results['status'] = false;
            }


        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function restoreinv($pay)
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        $business = runningBusiness()->business_key;
        $branch = runningBranch()->branch_key;
        $this->quotationsModel->where('quot_business',$business);
        $this->quotationsModel->where('quot_branch',$branch);
        if( $this->quotationsModel->update($pay,['quot_deleted' => 0])){

            $results['message'] = 'Quotation Restored successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to Restore Quotation';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

}
