<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of Dashboard
 *
 * @author test
 */
class Employees extends MY_Controller{

  public $pagedata;

  public function __construct() {
    parent::__construct();
    ($this->require_role('admin'));
    $this->pagedata['link']= 'payrolls';
      $this->load->helper('payroll/payroll');
  }

  public function index() {
    $this->load->helper('form');
    $this->pagedata['title'] = 'Employee liabilities for Payroll | '.$this->config->item('application_name');
    $this->load->vars($this->pagedata);
    $this->load->view('admin/payrolls/employee/employee');
  }

  function details($liability){
    $this->load->helper('form');
    $this->pagedata['liability'] = $this->payrollsModel->employeeLiabilityDetails($liability);
    $this->load->vars($this->pagedata);
    $this->load->view('admin/payrolls/employee/details');
  }

  function addEmployeeLiability(){
    $data['empl_name'] = $this->input->get('empl_name',TRUE);
    $data['empl_rate'] = $this->input->get('empl_rate',TRUE);
    $data['empl_amount'] = to_dollar($this->input->get('empl_amount',TRUE));
    if($this->payrollsModel->addEmployeeLiability($data)){
        $result['status'] = 'ok';
        $result['message'] = 'You have successfully registered Liability';
      }else{
        $result['status'] = 'no';
        $result['message'] = checkError($this->dbexeption());
    }

    print json_encode($result);
  }

  function updateEmployeeLiability($liability=''){
    $data['empl_name'] = $this->input->get('empl_name',TRUE);
    $data['empl_rate'] = $this->input->get('empl_rate',TRUE);
    $data['empl_amount'] = to_dollar($this->input->get('empl_amount',TRUE));
    if($this->payrollsModel->updateEmployeeLiability($liability,$data)){
        $result['status'] = 'ok';
        $result['message'] = 'You have successfully updated Liability';
      }else{
        $result['status'] = 'no';
        $result['message'] = checkError($this->dbexeption());
    }

    print json_encode($result);
  }

  function datasource(){
    $data = $this->payrollsModel->employeeLiabilities();
    $this->sourcedata($data);
  }

  function deleteEmployeeLiability($liability){
    if($this->payrollsModel->deleteEmployeeLiability($liability)){
        $result['status'] = 'ok';
        $result['message'] = 'You have successfully deleted Liability';
      }else{
        $result['status'] = 'no';
        $result['message'] = checkError($this->dbexeption());
    }

    print json_encode($result);
  }

}
