<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of Dashboard
 *
 * @author test
 */
class Company extends MY_Controller{

  public $pagedata;

  public function __construct() {
    parent::__construct();
    ($this->require_role('employee'));
    $this->pagedata['link']= 'payrolls';
      $this->load->helper('payroll/payroll');
  }

  public function index() {
    $this->load->helper('form');
    $this->pagedata['title'] = 'Company liabilities for Payroll | '.$this->config->item('application_name');
    $this->load->vars($this->pagedata);
    $this->load->view('employee/payrolls/company/company');
  }

  function details($liability){
    $this->load->helper('form');
    $this->pagedata['liability'] = $this->payrollsModel->companyLiabilityDetails($liability);
    $this->load->vars($this->pagedata);
    $this->load->view('employee/payrolls/company/details');
  }

  function addCompanyLiability(){
    $data['ctc_name'] = $this->input->get('ctc_name',TRUE);
    $data['ctc_rate'] = $this->input->get('ctc_rate',TRUE);
    $data['ctc_amount'] = to_dollar($this->input->get('ctc_amount',TRUE));
    if($this->payrollsModel->addCompanyLiability($data)){
        $result['status'] = 'ok';
        $result['message'] = 'You have successfully registered Liability';
      }else{
        $result['status'] = 'no';
        $result['message'] = checkError($this->dbexeption());
    }

    print json_encode($result);
  }

  function updateCompanyLiability($liability=''){
    $data['ctc_name'] = $this->input->get('ctc_name',TRUE);
    $data['ctc_rate'] = $this->input->get('ctc_rate',TRUE);
    $data['ctc_amount'] = to_dollar($this->input->get('ctc_amount',TRUE));
    if($this->payrollsModel->updateCompanyLiability($liability,$data)){
        $result['status'] = 'ok';
        $result['message'] = 'You have successfully updated Liability';
      }else{
        $result['status'] = 'no';
        $result['message'] = checkError($this->dbexeption());
    }

    print json_encode($result);
  }

  function datasource(){
    $data = $this->payrollsModel->companyLiabilities();
    $this->sourcedata($data);
  }

  function deleteCompanyLiability($liability){
    if($this->payrollsModel->deleteCompanyLiability($liability)){
        $result['status'] = 'ok';
        $result['message'] = 'You have successfully deleted Liability';
      }else{
        $result['status'] = 'no';
        $result['message'] = checkError($this->dbexeption());
    }

    print json_encode($result);
  }

}
