<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Dashboard
 *
 * @author test
 */
class Index extends MY_Controller{

    public  $appdata;

    function __construct() {
        parent::__construct();

        $this->require_min_level(1);
        $this->appdata['title']= 'Invoice Manager';
        $this->load->model(array(
            'invoices/InvoicesModel'=>'invoicesModel',
            'freight/FreightsModel'=>'freightsModel',
        ));
        $this->load->library(array('qrcode/Qrcodes'=>'qrcodes'));
        $this->load->helper('invoices/helper');        
        $this->appdata['link']= 'invoices';
    }

    function index($hash="") {
        $this->load->helper('form');
        $this->appdata['link']= 'invoices';
        $this->appdata['hash']= $hash;
        $this->load->vars($this->appdata);
        $this->load->view('invoices/invoices');
    }

    function transactions($hash="") {
        $this->load->helper('form');
        $this->appdata['link']= 'invoices';
        $this->appdata['hash']= $hash;
        $this->load->vars($this->appdata);
        $this->load->view('invoices/transactions');
    }

    function filtered($hash="") {
        $this->load->helper('form');
        $this->appdata['link']= 'invoices';
        $this->appdata['hash']= $hash;
        $this->load->vars($this->appdata);
        $this->load->view('invoices/invoices');
    }

    function create() {
        $this->load->model(array('taxes/taxesModel' => 'taxesModel','accounting/accounting' => 'accountingModel'));
        if($this->tokens->match) {
            $this->db->trans_start();
            $invoice = array(
                'inv_payer' => $this->input->post('bms_client',TRUE),
                'inv_issued_date' => date('Y-m-d H:i:s', strtotime($this->input->post('inv_issued_date', TRUE))),
                'inv_expiring_date' => date('Y-m-d H:i:s', strtotime($this->input->post('inv_expiring_date', TRUE))),
                'inv_status' => $this->input->post('inv_status',TRUE),
                'inv_total_before_tax' => to_dollar(toNumber($this->input->post('inv_sub_total', TRUE))),
                'inv_total_tax' => to_dollar(toNumber($this->input->post('inv_total_tax', TRUE))),
                'inv_total_after_tax' => to_dollar(toNumber($this->input->post('inv_total_after_tax', TRUE))),
                'inv_total_paid' => 0,
                'inv_total_balance' => to_dollar(toNumber($this->input->post('inv_total_after_tax', TRUE))),
                'inv_address' => $this->input->post('inv_address', TRUE),
                'inv_details' => $this->input->post('inv_details', TRUE),
                'inv_credit_account' => $this->input->post('inv_revenue_account', TRUE),
                'inv_debit_account' => $this->input->post('inv_receivable_account', TRUE),

//                'inv_payer' => $this->input->post('bms_client',TRUE),
//                'inv_issued_date' => date('Y-m-d H:i:s', strtotime($this->input->post('inv_issued_date', TRUE))),
//                'inv_expiring_date' => date('Y-m-d H:i:s', strtotime($this->input->post('inv_expiring_date', TRUE))),
//                'inv_status' => $this->input->post('inv_status',TRUE),
//                'inv_tax_inclusive' => !empty($this->input->post('inv_tax_inclusive', TRUE)) ? TRUE : FALSE,
//                'inv_total_after_tax' => to_dollar(toNumber($this->input->post('inv_total_after_tax', TRUE))),
//                'inv_custom' => to_dollar(toNumber($this->input->post('inv_custom', TRUE))),
//                'inv_total_tax' => to_dollar(toNumber($this->input->post('inv_total_tax', TRUE))),
//                'inv_untaxed' => to_dollar(toNumber($this->input->post('inv_untaxed', TRUE))),
//                'inv_total' => to_dollar(toNumber($this->input->post('inv_total', TRUE))),
//                'inv_total_balance' => to_dollar(toNumber($this->input->post('inv_total', TRUE))),
//                'inv_total_paid' => 0,
//                'inv_sub_total' => to_dollar(toNumber($this->input->post('inv_sub_total', TRUE))),
//                'inv_address' => $this->input->post('inv_address', TRUE),
//                'inv_details' => $this->input->post('inv_details', TRUE),
//                'inv_credit_account' => $this->input->post('inv_credit_account', TRUE),
//                'inv_debit_account' => $this->input->post('inv_debit_account', TRUE)
            );
            $invoiceKey = $this->invoicesModel->insert($invoice);
            if(!empty($items = $this->input->post('group_items'))){
                foreach ($items as $item){
                    $itemData['inv_data_item_tax_inclusive'] = $item['inv_item_tax_inclusive'];
                    $itemData['inv_data_item'] = $item['inv_item'];
                    $itemData['inv_data_item_details'] = $item['inv_item_details'];
                    $itemData['inv_data_item_qty'] = $item['inv_item_qty'];
                    $itemData['inv_data_item_price'] = to_dollar(toNumber($item['inv_item_price']));
                    $itemData['inv_data_item_before_tax'] = to_dollar(toNumber($item['inv_item_before_tax']));
                    $itemData['inv_data_item_tax'] = $item['inv_item_tax'];
                    $itemData['inv_data_item_tax_percent'] = $item['inv_item_tax_percent'];
                    $itemData['inv_data_item_tax_value'] = to_dollar(toNumber($item['inv_item_tax_value']));
                    $itemData['inv_data_item_after_tax'] = to_dollar(toNumber($item['inv_item_after_tax']));
                    $itemData['inv_data_item_invoice'] = $invoiceKey;
                    $this->db->insert('invoice_data_items',$itemData);

//                    $itemData['inv_data_item'] = $item['inv_item'];
//                    $itemData['inv_data_item_details'] = $item['inv_item_details'];
//                    $itemData['inv_data_item_qty'] = $item['inv_item_qty'];
//                    $itemData['inv_data_item_price'] = to_dollar(toNumber($item['inv_item_price']));
//                    $itemData['inv_data_item_total'] = to_dollar(toNumber($item['inv_item_total']));
//                    $itemData['inv_data_item_invoice'] = $invoiceKey;
                }
            }
            if(!empty($taxes = $this->input->post('taxes'))){
                foreach ($taxes as $item){
                    $taxData['inv_data_tax_tax'] = $item;
                    $taxData['inv_data_tax_value'] = $this->taxesModel->taxDetails($item)->tax_type_value;
                    $taxData['inv_data_tax_invoice'] = $invoiceKey ;
                    $this->db->insert('invoice_data_taxes',$taxData);
                }
            }


            $this->db->trans_complete();
            if ($this->db->trans_status() === TRUE) {
                $this->appdata['form_action'] = TRUE;
                $this->appdata['form_message'] = "Congratulation! Invoice created successfully";
                $this->appdata['form_class'] = "success";
            } else {
                $this->appdata['form_action'] = FALSE;
                $this->appdata['form_message'] = "We could not process request successfully please try again later";
                $this->appdata['form_class'] = "danger";
            }
        }

        $this->load->helper('form');
        $this->appdata['link']= 'invoices';
        $this->load->vars($this->appdata);
        $this->load->view('invoices/create');
    }

    function details($key='') {
        $this->load->model(array('taxes/taxesModel' => 'taxesModel','accounting/accounting' => 'accountingModel'));
        $this->load->helper('form');
        $this->appdata['invoice']= $this->invoicesModel->find($key);
        $this->appdata['items']= $this->invoicesModel->invoiceItems($this->appdata['invoice']['inv_id']);
        $this->appdata['taxes']= $this->invoicesModel->invoiceTaxes($this->appdata['invoice']['inv_id']);
        $this->load->vars($this->appdata);
        $this->load->view('invoices/details');
    }

    function payments($key='') {
        $this->load->model(array('taxes/taxesModel' => 'taxesModel','accounting/accounting' => 'accountingModel','invoices/InvoiceTransactionsModel' => 'invoiceTransactionsModel'));
        if(!empty($this->input->get("del",TRUE)) && $this->input->get("del",TRUE) == 'yes'){
            $business = runningBusiness()->business_key;
            $branch = runningBranch()->branch_key;
            $this->invoiceTransactionsModel->where('inv_pay_invoice',$this->input->get("inv",TRUE));
            $this->invoiceTransactionsModel->where('inv_pay_business',$business);
            $this->invoiceTransactionsModel->where('inv_pay_branch',$branch);
            $this->invoiceTransactionsModel->delete($this->input->get("id",TRUE));
        }

        if(!empty($this->input->get("ush",true)) && $this->input->get("ush",true) == 'yes'){
            $flag = $this->invoiceTransactionsModel->find($this->input->get("id",TRUE));
            if(strtolower($flag['inv_pay_post_status']) == "draft"){
                $business = runningBusiness()->business_key;
                $branch = runningBranch()->branch_key;
                $this->invoiceTransactionsModel->where('inv_pay_invoice',$this->input->get("inv",TRUE));
                $this->invoiceTransactionsModel->where('inv_pay_business',$business);
                $this->invoiceTransactionsModel->where('inv_pay_branch',$branch);
                if($this->invoiceTransactionsModel->update($this->input->get("id",TRUE),['inv_pay_post_status' => "PENDING"])){
                    $payment = $this->invoiceTransactionsModel->find($this->input->get("id",TRUE));
                    $invoice = $this->invoicesModel->find($this->input->get("inv",TRUE));
                    $this->load->model(array('accounting/GeneralLedgerModel'=>'generalLedgerModel'));
                    $this->generalLedgerModel->soft_delete(FALSE);
                    $this->generalLedgerModel->where('gl_business',$business);
                    $this->generalLedgerModel->where('gl_branch',$branch);
                    $this->generalLedgerModel->delete_by(['gl_activity' => $invoice,'gl_category' => 'INVOICES']);
                    $this->postPaymentLedger($payment,$invoice);
                }
            }

        }
        $this->load->model(array('taxes/taxesModel' => 'taxesModel','accounting/accounting' => 'accountingModel','invoices/InvoiceTransactionsModel' => 'invoiceTransactionsModel'));
        $this->load->helper('form');
        $this->appdata['invoice']= $this->invoicesModel->find($key);
        $this->appdata['payments']= $this->invoiceTransactionsModel->find_many_by(["inv_pay_invoice" => $key]);
        $this->load->vars($this->appdata);
        $this->load->view('invoices/payments');
    }

    function postpayment($pay)
    {
        $this->load->model(array('invoices/InvoiceTransactionsModel' => 'invoiceTransactionsModel'));
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        $business = runningBusiness()->business_key;
        $branch = runningBranch()->branch_key;
        $this->invoiceTransactionsModel->where('inv_pay_business',$business);
        $this->invoiceTransactionsModel->where('inv_pay_branch',$branch);
        if( $this->invoiceTransactionsModel->update($pay,['inv_pay_post_status' => "PENDING"])){
            $payment = $this->invoiceTransactionsModel->find($pay);
            $invoice = $this->invoicesModel->find($payment['inv_pay_invoice']);
            $this->postPaymentLedger($payment,$invoice);
            $results['message'] = 'Payment Posted successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to Post Payment';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function restorepayment($pay)
    {
        $this->load->model(array('invoices/InvoiceTransactionsModel' => 'invoiceTransactionsModel'));
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        $business = runningBusiness()->business_key;
        $branch = runningBranch()->branch_key;
        $this->invoiceTransactionsModel->where('inv_pay_business',$business);
        $this->invoiceTransactionsModel->where('inv_pay_branch',$branch);
        if( $this->invoiceTransactionsModel->update($pay,['inv_pay_deleted' => 0])){
            $results['message'] = 'Payment Restored successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to Restore Payment';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function deletepaymentforever($pay)
    {
        $this->load->model(array('invoices/InvoiceTransactionsModel' => 'invoiceTransactionsModel'));
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        $business = runningBusiness()->business_key;
        $branch = runningBranch()->branch_key;
        $this->invoiceTransactionsModel->where('inv_pay_business',$business);
        $this->invoiceTransactionsModel->where('inv_pay_branch',$branch);
        $this->invoiceTransactionsModel->soft_delete(FALSE);
        if( $this->invoiceTransactionsModel->delete($pay)){
            $results['message'] = 'Payment Deleted successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to Delete Payment';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function deletepayment($pay)
    {
        $this->load->model(array('invoices/InvoiceTransactionsModel' => 'invoiceTransactionsModel'));
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        $business = runningBusiness()->business_key;
        $branch = runningBranch()->branch_key;
        $this->invoiceTransactionsModel->where('inv_pay_business',$business);
        $this->invoiceTransactionsModel->where('inv_pay_branch',$branch);
        if( $this->invoiceTransactionsModel->delete($pay)){
            $results['message'] = 'Payment Deleted successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to Delete Payment';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function modify($key='') {
        $this->load->model(array('taxes/taxesModel' => 'taxesModel','accounting/accounting' => 'accountingModel'));
        if($this->tokens->match) {
            $this->db->trans_start();
            $invoice = array(
                //'inv_payer' => $this->input->post('bms_client',TRUE),
                'inv_issued_date' => date('Y-m-d H:i:s', strtotime($this->input->post('inv_issued_date', TRUE))),
                'inv_expiring_date' => date('Y-m-d H:i:s', strtotime($this->input->post('inv_expiring_date', TRUE))),
                'inv_status' => $this->input->post('inv_status',TRUE),
                'inv_total_before_tax' => to_dollar(toNumber($this->input->post('inv_sub_total', TRUE))),
                'inv_total_tax' => to_dollar(toNumber($this->input->post('inv_total_tax', TRUE))),
                'inv_total_after_tax' => to_dollar(toNumber($this->input->post('inv_total_after_tax', TRUE))),
                'inv_total_paid' => 0,
                'inv_total_balance' => to_dollar(toNumber($this->input->post('inv_total_after_tax', TRUE))),
                'inv_address' => $this->input->post('inv_address', TRUE),
                'inv_details' => $this->input->post('inv_details', TRUE),
                'inv_credit_account' => $this->input->post('inv_revenue_account', TRUE),
                'inv_debit_account' => $this->input->post('inv_receivable_account', TRUE),

//                'inv_issued_date' => date('Y-m-d H:i:s', strtotime($this->input->post('inv_issued_date', TRUE))),
//                'inv_expiring_date' => date('Y-m-d H:i:s', strtotime($this->input->post('inv_expiring_date', TRUE))),
//                'inv_status' => $this->input->post('inv_status',TRUE),
//                'inv_tax_inclusive' => !empty($this->input->post('inv_tax_inclusive', TRUE)) ? TRUE : FALSE,
//                'inv_total_after_tax' => to_dollar(toNumber($this->input->post('inv_total_after_tax', TRUE))),
//                'inv_custom' => to_dollar(toNumber($this->input->post('inv_custom', TRUE))),
//                'inv_total_tax' => to_dollar(toNumber($this->input->post('inv_total_tax', TRUE))),
//                'inv_untaxed' => to_dollar(toNumber($this->input->post('inv_untaxed', TRUE))),
//                'inv_total' => to_dollar(toNumber($this->input->post('inv_total', TRUE))),
//                'inv_sub_total' => to_dollar(toNumber($this->input->post('inv_sub_total', TRUE))),
//                'inv_address' => $this->input->post('inv_address', TRUE),
//                'inv_details' => $this->input->post('inv_details', TRUE),
//                'inv_credit_account' => $this->input->post('inv_credit_account', TRUE),
//                'inv_debit_account' => $this->input->post('inv_debit_account', TRUE)
            );

            $this->invoicesModel->update($key,$invoice);
            $id = $this->invoicesModel->find($key);
            if(!empty($items = $this->input->post('group_items'))){
                $this->db->where('inv_data_item_invoice',$id['inv_id']);
                $this->db->delete('invoice_data_items');
                foreach ($items as $item){
                    $itemData['inv_data_item_tax_inclusive'] = $item['inv_item_tax_inclusive'];
                    $itemData['inv_data_item'] = $item['inv_item'];
                    $itemData['inv_data_item_details'] = $item['inv_item_details'];
                    $itemData['inv_data_item_qty'] = $item['inv_item_qty'];
                    $itemData['inv_data_item_price'] = to_dollar(toNumber($item['inv_item_price']));
                    $itemData['inv_data_item_before_tax'] = to_dollar(toNumber($item['inv_item_before_tax']));
                    $itemData['inv_data_item_tax'] = $item['inv_item_tax'];
                    $itemData['inv_data_item_tax_percent'] = $item['inv_item_tax_percent'];
                    $itemData['inv_data_item_tax_value'] = to_dollar(toNumber($item['inv_item_tax_value']));
                    $itemData['inv_data_item_after_tax'] = to_dollar(toNumber($item['inv_item_after_tax']));
                    $itemData['inv_data_item_invoice'] = $id['inv_id'];
                    $this->db->insert('invoice_data_items',$itemData);

//                    $itemData['inv_data_item'] = $item['inv_item'];
//                    $itemData['inv_data_item_details'] = $item['inv_item_details'];
//                    $itemData['inv_data_item_qty'] = $item['inv_item_qty'];
//                    $itemData['inv_data_item_price'] = to_dollar(toNumber($item['inv_item_price']));
//                    $itemData['inv_data_item_total'] = to_dollar(toNumber($item['inv_item_total']));
//                    $itemData['inv_data_item_invoice'] = $id['inv_id'];
                }
            }

            if(!empty($taxes = $this->input->post('taxes'))){
                $this->db->where('inv_data_tax_invoice',$id['inv_id']);
                $this->db->delete('invoice_data_taxes');
                foreach ($taxes as $item){
                    $taxData['inv_data_tax_tax'] = $item;
                    $taxData['inv_data_tax_value'] = $this->taxesModel->taxDetails($item)->tax_type_value;
                    $taxData['inv_data_tax_invoice'] = $id['inv_id'];
                    $this->db->insert('invoice_data_taxes',$taxData);
                }
            }

            $this->db->trans_complete();
            if ($this->db->trans_status() === TRUE) {
                $this->appdata['form_action'] = TRUE;
                $this->appdata['form_message'] = "Congratulation! Invoice updated successfully";
                $this->appdata['form_class'] = "success";
            } else {
                $this->appdata['form_action'] = FALSE;
                $this->appdata['form_message'] = "We could not process request successfully please try again later";
                $this->appdata['form_class'] = "danger";
            }
        }
        $this->load->helper('form');
        $this->appdata['invoice'] = $this->invoicesModel->find($key);
        $this->appdata['items']= $this->invoicesModel->invoiceItems($this->appdata['invoice']['inv_id']);
        $this->appdata['taxes']= $this->invoicesModel->invoiceTaxes($this->appdata['invoice']['inv_id']);
        $this->load->vars($this->appdata);
        $this->load->view('invoices/modify');
    }

    function sourceinvoices($hash=''){
      $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
      if(!empty($hash)){
          $invocies = $this->invoicesModel->order_by('inv_created_on','DESC')->find_many_by(["inv_status" => $hash]);
      }else{
          $invocies = $this->invoicesModel->order_by('inv_created_on','DESC')->find_all();
      }

      $columns = array();
      foreach ($this->invoicesModel->selectable_fields as $field){
          $columns[$field] = TRUE;
      }
      print $this->datasourceLibrary->server($invocies,$columns);
    }

    function sourceinvoicesbin($hash=''){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        if(!empty($hash)){
            $this->invoicesModel->where('inv_deleted',1);
            $invocies = $this->invoicesModel->with_deleted()->find_many_by(["inv_status" => $hash]);
        }else{
            $this->invoicesModel->where('inv_deleted',1);
            $invocies = $this->invoicesModel->with_deleted()->find_all();
        }

        $columns = array();
        foreach ($this->invoicesModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($invocies,$columns);
    }

    function sourcetransactions(){
        $this->load->model(array('invoices/InvoiceTransactionsModel' => 'invoiceTransactionsModel'));
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $transactions = $this->invoiceTransactionsModel->find_all();
        $columns = array();
        foreach ($this->invoiceTransactionsModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($transactions,$columns);
    }

    function sourcetransactionsbin(){
        $this->load->model(array('invoices/InvoiceTransactionsModel' => 'invoiceTransactionsModel'));
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $this->invoiceTransactionsModel->where('inv_pay_deleted',1);
        $transactions = $this->invoiceTransactionsModel->with_deleted()->find_all();
        $columns = array();
        foreach ($this->invoiceTransactionsModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($transactions,$columns);
    }

    function deleteinv($inv)
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if(invoiceIsDeletable($inv)){
            $business = runningBusiness()->business_key;
            $branch = runningBranch()->branch_key;
            $this->invoicesModel->where('inv_business',$business);
            $this->invoicesModel->where('inv_branch',$branch);
            if($this->invoicesModel->delete($inv)){
                $this->load->model(array('invoices/InvoiceTransactionsModel' => 'invoiceTransactionsModel'));
                $this->invoiceTransactionsModel->delete_by(['inv_pay_invoice' => $inv]);
                $results['message'] = 'Invoice deleted successfully';
                $results['status'] = true;
            }else{
                $results['message'] = 'Failed to delete Invoice';
                $results['status'] = false;
            }
        }else{
            $results['message'] = 'You can not delete Invoice as it has been posted into General Ledger';
            $results['status'] = false;
        }


        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function deleteinvforever($inv)
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if(invoiceIsDeletable($inv)){
            $business = runningBusiness()->business_key;
            $branch = runningBranch()->branch_key;
            $this->invoicesModel->where('inv_business',$business);
            $this->invoicesModel->where('inv_branch',$branch);
            $this->invoicesModel->soft_delete(FALSE);
            if($this->invoicesModel->delete($inv)){
                $this->load->model(array('invoices/InvoiceTransactionsModel' => 'invoiceTransactionsModel'));
                $this->invoiceTransactionsModel->soft_delete(FALSE);
                $this->invoiceTransactionsModel->delete_by(['inv_pay_invoice' => $inv]);
                $results['message'] = 'Invoice deleted successfully';
                $results['status'] = true;
            }else{
                $results['message'] = 'Failed to delete Invoice';
                $results['status'] = false;
            }
        }else{
            $results['message'] = 'You can not delete Invoice as it has been posted into General Ledger';
            $results['status'] = false;
        }


        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function restoreinv($pay)
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        $business = runningBusiness()->business_key;
        $branch = runningBranch()->branch_key;
        $this->invoicesModel->where('inv_business',$business);
        $this->invoicesModel->where('inv_branch',$branch);
        if( $this->invoicesModel->update($pay,['inv_deleted' => 0])){
            $this->load->model(array('invoices/InvoiceTransactionsModel' => 'invoiceTransactionsModel'));
            $this->invoiceTransactionsModel->where('inv_pay_business',$business);
            $this->invoiceTransactionsModel->where('inv_pay_branch',$branch);
            $this->invoiceTransactionsModel->update_by(['inv_pay_invoice' => $pay],['inv_pay_deleted' => 0]);

            $results['message'] = 'Invoice Restored successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to Restore Invoice';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function addpayment()
    {
        $this->load->model(array('invoices/InvoiceTransactionsModel' => 'invoiceTransactionsModel'));
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $business = runningBusiness()->business_key;
        $branch = runningBranch()->branch_key;
        $invocie = $this->invoicesModel->find($this->input->post('inv_pay_invoice', TRUE));
        $payments = array(
            'inv_pay_business' => $business,
            'inv_pay_branch' => $branch,
            'inv_pay_payer' => $invocie['inv_payer'],
            'inv_pay_receiver' => $this->auth_user_id,
            'inv_pay_invoice' => $invocie['inv_key'],
            'inv_pay_details' => $this->input->post('inv_pay_details', TRUE),
            'inv_pay_method' => $this->input->post('inv_pay_method', TRUE),
            'inv_pay_reference' => $this->input->post('inv_pay_reference', TRUE),
            'inv_pay_amount' => to_dollar(toNumber($this->input->post('inv_pay_amount', TRUE))),
            'inv_pay_credit_account' => $invocie['inv_debit_account'],
            'inv_pay_debit_account' => $invocie['inv_debit_account']
        );


        if($this->invoiceTransactionsModel->insert($payments)){

            $results['message'] = 'Payment added successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to add Payment';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function postPaymentLedger($payment,$invoice){

        $this->load->helper('reports/accounting/helper');
        $this->load->model(array('accounting/GeneralLedgerModel'=>'generalLedgerModel'));

        $ledgerDebit['gl_account'] = $invoice['inv_debit_account'];
        $ledgerDebit['gl_debit'] = $payment['inv_pay_amount'];
        $ledgerDebit['gl_amount'] = $payment['inv_pay_amount'];
        $ledgerDebit['gl_date'] = $payment['inv_pay_date'];
        $ledgerDebit['gl_status'] = "PENDING";
        $ledgerDebit['gl_category'] = "INVOICES";
        $ledgerDebit['gl_type'] = "INVOICE";
        $ledgerDebit['gl_reference'] = $payment['inv_pay_reference'];
        $ledgerDebit['gl_details'] = $payment['inv_pay_details'];
        $ledgerDebit['gl_activity'] = $payment['inv_pay_key'];
        $id = $this->generalLedgerModel->insert($ledgerDebit);
        $balance['gl_balance'] = accountBalance($ledgerDebit['gl_account']);
        $this->generalLedgerModel->update_by(['gl_id'=> $id],$balance);

        $ledgerCredit['gl_account'] = $invoice['inv_credit_account'];
        $ledgerCredit['gl_credit'] = $payment['inv_pay_amount'];
        $ledgerCredit['gl_date'] = $payment['inv_pay_date'];
        $ledgerCredit['gl_status'] = "PENDING";
        $ledgerCredit['gl_category'] = "INVOICES";
        $ledgerCredit['gl_type'] = "INVOICE";
        $ledgerCredit['gl_reference'] = $payment['inv_pay_reference'];
        $ledgerCredit['gl_details'] = $payment['inv_pay_details'];
        $ledgerCredit['gl_activity'] = $payment['inv_pay_key'];
        $ledgerCredit['gl_amount'] = $payment['inv_pay_amount'];
        $id = $this->generalLedgerModel->insert($ledgerCredit);
        $balance['gl_balance'] = accountBalance($ledgerCredit['gl_account']);
        $this->generalLedgerModel->update_by(['gl_id'=> $id],$balance);

    }

}
