<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of Dashboard
 *
 * @author test
 */
class Index extends MY_Controller {

    public $pagedata;
    public $branch;
    public $business;

    public function __construct() {
        parent::__construct();
        ($this->require_min_level(1));
        $this->pagedata['link']= 'administration';
        $this->load->model(array(
            'hrm/leaveModel'=>'leaveModel',
            'hrm/Employees'=>'employeesModel',
        ));
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
        $this->load->helper('hrm/employees');
    }

    public function index() {
        has_control('employee_view_all','View all employees');
        $this->load->helper('hrm/employees');
        $this->pagedata['link'] = 'Leave';
        $this->pagedata['hrm_leave_schemes_key'] = $this->leaveModel->leaves();
        $this->pagedata['leaves'] = $this->leaveModel->leaveScheme();
        $this->pagedata['title'] = 'Leave Schemes | HRM '.$this->config->item('application_name');
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/leave/leaves');
    }

    function datasourceLeave(){
        $data = $this->leaveModel->leaves();
        $columnsDefault = [
            'hrm_leave_schemes_key' => true,
            'hrm_leave_schemes_title' => true,
            'hrm_leave_schemes_created_at' => true,
        ];
        $this->sourcedataserver($data,$columnsDefault);
    }

    function newleave(){
        $leave['hrm_leave_schemes_title'] = $this->input->get('hrm_leave_schemes_title',TRUE);
        if($this->leaveModel->create_leave($leave)){
            $result['status'] = 'ok';
            $result['message'] = 'Leave registered successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function detailsLeave($leave=''){
        $this->load->helper('form');
        $this->pagedata['leave'] = $this->leaveModel->leaveU($leave);
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/leave/details');
    }

    public function modifyLeave($leaveKey='') {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        $this->pagedata['leave'] = $this->leaveModel->leaveU($leaveKey);
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/leave/detailsModify');
    }

    function updateLeave($leaveKey=''){
        $data['hrm_leave_schemes_title'] = $this->input->get('hrm_leave_schemes_title',TRUE);
        if($this->leaveModel->leaveUpdate($leaveKey,$data)){
            $result['status'] = 'ok';
            $result['message'] = 'Leave updated successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    public function delete($flag,$key) {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        switch ($flag) {
            case 'leave':
                if($this->leaveModel->deleteLeave($key)){
                    $result['status'] = 'ok';
                    $result['message'] = 'Charge deleted';
                }else{
                    $result['status'] = 'no';
                    $result['message'] = checkError($this->dbexeption());
                }
                print json_encode($result);
                break;
            default:
                $result['status'] = 'no';
                $result['message'] = 'No action';
                print json_encode($result);
                break;
        }
    }

         //------------Leave here-------------//
    public function leaveScheme() {
        //has_control('employee_view_all','View all employees');
        $this->load->helper('form');
        $this->pagedata['link'] = 'leavescheme';
        $this->pagedata['title'] = 'Leave | HRM '.$this->config->item('application_name');
        $this->pagedata['hrm_leave_schemes_key'] = $this->leaveModel->leaves();
        $this->pagedata['leaves'] = $this->leaveModel->leaveScheme();
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/leave/leave_schemes');
    }

    function datasourceLeaveScheme(){
        $data = $this->leaveModel->leaveScheme();
        $columnsDefault = [
            'hrm_leave_schemes_titles_key' => true,
            'hrm_leave_schemes_title' => true,
            'hrm_leave_schemes_titles_title' => true,
            'hrm_leave_schemes_titles_number_days' => true,
            'hrm_leave_schemes_titles_leave_schemes_key'  => true,
            'hrm_leave_schemes_titles_created_at' => true,
        ];
        $this->sourcedataserver($data,$columnsDefault);
    }

    function newleaveScheme(){
        $leave['hrm_leave_schemes_titles_leave_schemes_key'] = $this->input->get('hrm_leave_schemes_titles_leave_schemes_key',TRUE);
        $leave['hrm_leave_schemes_titles_title'] = $this->input->get('hrm_leave_schemes_titles_title',TRUE);
        $leave['hrm_leave_schemes_titles_number_days'] = $this->input->get('hrm_leave_schemes_titles_number_days',TRUE);
        $leave['hrm_leave_schemes_titles_created_at'] = date('Y-m-d');
        if($this->leaveModel->create_leaveScheme($leave)){
            $result['status'] = 'ok';
            $result['message'] = 'Leave Scheme registered successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function detailsLeaveScheme($leave=''){
        $this->load->helper('form');
        $this->pagedata['leave'] = $this->leaveModel->leaveSchemeU($leave);
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/leave/details_scheme');
    }

    public function modifyLeaveScheme($leaveKey='') {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        $this->pagedata['hrm_leave_schemes_key'] = $this->leaveModel->leaves();
        $this->pagedata['leave'] = $this->leaveModel->leaveSchemeU($leaveKey);
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/leave/schemeModify');
    }

    function updateLeaveScheme($leaveKey=''){
        $data['hrm_leave_schemes_titles_leave_schemes_key'] = $this->input->get('hrm_leave_schemes_titles_leave_schemes_key',TRUE);
        $data['hrm_leave_schemes_titles_title'] = $this->input->get('hrm_leave_schemes_titles_title',TRUE);
        $data['hrm_leave_schemes_titles_number_days'] = $this->input->get('hrm_leave_schemes_titles_number_days',TRUE);
        $data['hrm_leave_schemes_titles_modified_at'] = date('Y-m-d');
        if($this->leaveModel->leaveSchemeUpdate($leaveKey,$data)){
            $result['status'] = 'ok';
            $result['message'] = 'Leave Scheme updated successifully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    public function deleteScheme($flag,$key) {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        switch ($flag) {
            case 'leave':
                if($this->leaveModel->deleteLeaveScheme($key)){
                    $result['status'] = 'ok';
                    $result['message'] = 'Scheme deleted';
                }else{
                    $result['status'] = 'no';
                    $result['message'] = checkError($this->dbexeption());
                }
                print json_encode($result);
                break;
            default:
                $result['status'] = 'no';
                $result['message'] = 'No action performed';
                print json_encode($result);
                break;
        }
    }


    //-------------Leave Request------------//

    public function leaverequest() {
        has_control('employee_view_all','View all employees');
        $this->load->helper('hrm/employees');
        $this->pagedata['link'] = 'request';
        $this->pagedata['hrm_leave_schemes_key'] = $this->leaveModel->leaves();
        $this->pagedata['leaves'] = $this->leaveModel->leaveScheme();
        $this->pagedata['title'] = 'Leave Request | HRM '.$this->config->item('application_name');
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/leave/leavesrequest');
    }

    function datasourceleaverequest(){
        $data = $this->leaveModel->leavesrequest();
        $columnsDefault = [
            'leave_request_key' => true,
            'firstname' => true,
            'user_id' => true,
            'lastname' => true,
            'leave_request_user_id' => true,
            'hrm_leave_schemes_titles_title' => true,
            'leave_request_leave_key' => true,
            'leave_request_desc' => true,
            'leave_request_from'  => true,
            'leave_request_to' => true,
            'leave_request_status'  => true,
            'leave_request_created_at' => true,
        ];
        $this->sourcedataserver($data,$columnsDefault);
    }

    function newleaveRequest(){
        $leave['leave_request_user_id'] = $this->auth_user_id;
        $leave['leave_request_leave_key'] = $this->input->get('leave_request_leave_key',TRUE);
        $leave['leave_request_from'] = $this->input->get('leave_request_from',TRUE);
        $leave['leave_request_to'] = $this->input->get('leave_request_to',TRUE);
        $leave['leave_request_desc'] = $this->input->get('leave_request_desc',TRUE);
        $leave['leave_request_created_at'] = date('Y-m-d');
        if($this->leaveModel->create_leaveRequest($leave)){
            $result['status'] = 'ok';
            $result['message'] = 'Leave Request submitted successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    public function modifyRequest($requestKey='') {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        $this->load->helper('form');
        $this->pagedata['leave'] = $this->leaveModel->leaveRequestU($requestKey);
        $this->pagedata['leaves'] = $this->leaveModel->leaveScheme();
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/leave/requestModify');
    }

    function updateRequest($leaveKey=''){
        $data['leave_request_leave_key'] = $this->input->get('leave_request_leave_key',TRUE);
        $data['leave_request_from'] = $this->input->get('leave_request_from',TRUE);
        $data['leave_request_to'] = $this->input->get('leave_request_to',TRUE);
        $data['leave_request_desc'] = $this->input->get('leave_request_desc',TRUE);
        $data['leave_request_status'] = $this->input->get('leave_request_status',TRUE);
        if($this->leaveModel->updateRequest($leaveKey,$data)){
            $result['status'] = 'ok';
            $result['message'] = 'Leave Request updated successifully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function detailsLeaveRequest($leave=''){
        $this->load->helper('form');
        $this->pagedata['leave'] = $this->leaveModel->leaveRequestU($leave);
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/employees/leave/request_details');
    }

    public function deleteRequest($flag,$key) {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        switch ($flag) {
            case 'leave':
                if($this->leaveModel->deleteLeaveRequest($key)){
                    $result['status'] = 'ok';
                    $result['message'] = 'Request deleted';
                }else{
                    $result['status'] = 'no';
                    $result['message'] = checkError($this->dbexeption());
                }
                print json_encode($result);
                break;
            default:
                $result['status'] = 'no';
                $result['message'] = 'No action performed';
                print json_encode($result);
                break;
        }
    }

    function requestApprove($leave){
        if($this->leaveModel->updateRequest($leave,['leave_request_status'=>'Approved'])){
            $result['status'] = 'ok';
            $result['message'] = 'Request approved successfully';
        }else{
            $result['status'] = 'no';
            //$result['message'] = 'Failed to approve request, Try again later';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function requestNotApprove($leave){
        if($this->leaveModel->updateRequest($leave,['leave_request_status'=>'Not Approved'])){
            $result['status'] = 'ok';
            $result['message'] = 'Request updated successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    public function setReject($flag,$key) {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        switch ($flag) {
            case 'reject':
                if($this->leaveModel->rejectRequest($key)){
                    $result['status'] = 'ok';
                    $result['message'] = 'Request rejected';
                }else{
                    $result['status'] = 'no';
                    $result['message'] = checkError($this->dbexeption());
                }
                print json_encode($result);
                break;
            default:
                $result['status'] = 'no';
                $result['message'] = 'No action performed';
                print json_encode($result);
                break;
        }
    }




    function createLeave(){
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        has_control_ajax('leave_register','Register Leave');
        $data['hrm_leave_schemes_key'] = $this->leaveModel->unused_leave_key();
        $data['hrm_leave_schemes_business_key'] = $this->business;
        $data['hrm_leave_schemes_title'] = $this->input->get('hrm_leave_schemes_title',TRUE);
        $data['hrm_leave_schemes_created_at'] = date('Y-m-d');
        $data['hrm_leave_schemes_created_by'] = $this->auth_user_id;
        if($this->leaveModel->create_leave($data)){
            $result['status'] = 'ok';
            $result['message'] = 'Leave registered successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function createLeaveScheme(){
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        has_control_ajax('leave_register','Register Leave Scheme');
        $data['hrm_leave_schemes_titles_key'] = $this->leaveModel->unused_leave_scheme_key();
        $data['hrm_leave_schemes_titles_business_key'] = $this->business;
        $data['hrm_leave_schemes_titles_leave_schemes_key'] = $this->input->get('hrm_leave_schemes_titles_leave_schemes_key',TRUE);
        $data['hrm_leave_schemes_titles_title'] = $this->input->get('hrm_leave_schemes_titles_title',TRUE);
        $data['hrm_leave_schemes_titles_number_days'] = $this->input->get('hrm_leave_schemes_titles_number_days',TRUE);
        $data['hrm_leave_schemes_titles_created_at'] = date('Y-m-d');
        $data['hrm_leave_schemes_titles_created_by'] = $this->auth_user_id;
        if($this->leaveModel->create_leave_scheme($data)){
            $result['status'] = 'ok';
            $result['message'] = 'Leave scheme registered successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    public function delete1($key){
        $this->db->where('hrm_holiday_schemes_key',$key);
        $this->db->delete('hrm_holiday_schemes');
        if($this->db->affected_rows()>0){
            $result['status'] = 'ok';
            $result['message'] = 'Deleted successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

}