<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of Dashboard
 *
 * @author noely
 */
class Departments extends MY_Controller{

  public $pagedata;
  public $store;
  public $business;

    public function __construct() {
        parent::__construct();
        ($this->require_min_level(1));
        $this->pagedata['link']= 'departments';
        $this->load->helper('hrm/hrm');
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
        $this->load->model(array(
            'hrm/DepartmentsModel' => 'departmentsModel',
            'hrm/Employees'=>'employeesModel',
        ));
    }

  public function index() {
    has_control('departments_view_all','View all Departments');
    $this->load->helper('form');
    $this->pagedata['title'] = 'Departments | '.$this->config->item('application_name');
    $this->pagedata['employees'] = $this->employeesModel->employees();
    $this->load->vars($this->pagedata);
    $this->load->view('hrm/employees/departments/departments');
  }

function details($department=''){
  if (!$this->input->is_ajax_request())
   exit('not direct script allowed');
   has_control_ajax_content('departments_details','View Department details');
  $this->load->helper('form');
  $this->pagedata['department'] = $this->departmentsModel->department($department);
  $this->load->vars($this->pagedata);
  $this->load->view('hrm/employees/departments/details');
}

function modify($department=''){
  if (!$this->input->is_ajax_request())
   exit('not direct script allowed');
   has_control_ajax_content('departments_update','Update Department');
  $this->load->helper('form');
  $this->pagedata['department'] = $this->departmentsModel->department($department);
  $this->pagedata['employees'] = $this->employeesModel->employees();
  $this->load->vars($this->pagedata);
  $this->load->view('hrm/employees/departments/detailsModify');
}

function update($departmentKey=''){
  if (!$this->input->is_ajax_request())
   exit('not direct script allowed');
   has_control_ajax('departments_update','Update Department');
  $department['department_name'] = $this->input->get('department_name',TRUE);
  $department['department_details'] = $this->input->get('department_details',TRUE);
  $department['department_hod'] = $this->input->get('department_hod',TRUE);
  if($this->departmentsModel->departmentUpdate($departmentKey,$department)){
            $result['status'] = 'ok';
            $result['message'] = 'Department updated successifully';
          }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
          }
 print json_encode($result);
}

function newDepartment(){
  if (!$this->input->is_ajax_request())
   exit('not direct script allowed');
   has_control_ajax('departments_register','Register Department');
    $department['department_name'] = $this->input->get('department_name',TRUE);
    $department['department_details'] = $this->input->get('department_details',TRUE);
    $department['department_hod'] = $this->input->get('department_hod',TRUE);
    if($this->departmentsModel->departmentRegister($department)){
              $result['status'] = 'ok';
              $result['message'] = 'Department registered successifully';
            }else{
              $result['status'] = 'no';
              $result['message'] = checkError($this->dbexeption());
            }
   print json_encode($result);
  }

function datasource(){
    $data = $this->departmentsModel->departments();
    $columnsDefault = [
        'department_key' => true,
        'department_name' => true,
        'user_key' => true,
        'firstname' => true,
        'lastname' => true,
        'department_hod' => true,
        'department_details' => true,
    ];
    $this->sourcedataserver($data,$columnsDefault);
}

public function delete($flag,$key) {
if (!$this->input->is_ajax_request())
 exit('not direct script allowed');
  switch ($flag) {
      case 'department':
      has_control_ajax('departments_delete','Delete Department');
      if($this->departmentsModel->deleteDepartment($key)){
                $result['status'] = 'ok';
                $result['message'] = 'Department deleted';
              }else{
                $result['status'] = 'no';
                $result['message'] = checkError($this->dbexeption());
              }
        print json_encode($result);
      break;
      default:
        $result['status'] = 'no';
        $result['message'] = 'No action';
         print json_encode($result);
      break;
  }
}

public function more($key) {
    $this->pagedata['title'] = 'Department Details';
    $this->pagedata['department' ] = $this->departmentsModel->department_more($key);
    $this->pagedata['users' ] = $this->departmentsModel->user_department($key);
    $this->load->vars($this->pagedata);
    $this->load->view('hrm/employees/departments/department_more');
}

function datasourceuser($key){
        $data = $this->departmentsModel->user_department($key);
        $columnsDefault = [
            'middlename' => true,
            'gender' => true,
            'mobilephone' => true,
            'firstname' => true,
            'lastname' => true,
            'city' => true,
            'state' => true,
        ];
        $this->sourcedataserver($data,$columnsDefault);
    }

}