<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
* Description of Dashboard
*
* @author test
*/

class Getdetails extends MY_Controller{

    public function __construct() {
        parent::__construct();
        ( $this->require_role('employee'));
        $this->load->helper('accounting/journals/helper');
        $this->load->model(array(
            'accounting/accounting'=>'accountingModel',
            'accounting/JournalsModel'=>'journalsModel',
            'accounting/GlModel'=>'glModel',
        ));
        $this->iamactive();
    }

    function general($activity=''){
        authWithTimeAjax();
        $this->pagedata['activity'] = $this->journalsModel->activityGeneralDetails($activity);
        $this->load->vars($this->pagedata);
        $this->load->helper('form');
        $this->load->view($this->auth_role.'/accounting/journals/actions/general/details');
    }

    public function expense($expense='') {
        $this->load->model(array(
            'expenses/ExpensesModel'=>'expensesModel',
            'expenses/ExpensesBudgetsModel'=>'expensesBudgetsModel',
            'expenses/ExpensesTypesModel'=>'expensesTypesModel',
            'accounting/Accounting'=>'accountingModel',
            'accounting/GlModel'=>'glModel',
            'expenses/ExpensesCategoriesModel'=>'expensesCategoriesModel'
        ));
        $this->load->helper('form');
        $this->appdata['expense']= $this->expensesModel->expenseDetails($expense);
        $this->load->vars($this->appdata);
        $this->load->view($this->auth_role.'/accounting/journals/actions/expenses/details');
    }

    function loans($activity=''){
        authWithTimeAjax();
        $this->load->model(array(
            'loans/LoanApplicationsModel' => 'loanApplicationsModel'
        ));
        $this->pagedata['activity'] = $this->journalsModel->activityLoansDetails($activity);
        $this->pagedata['activityArray'] = $this->journalsModel->activityLoansDetailsArray($activity);
        $this->pagedata['installments'] = $this->journalsModel->activityLoansDetailsInstalls($activity);
        $this->load->vars($this->pagedata);
        $this->load->helper('form');
        $this->load->view($this->auth_role.'/accounting/journals/actions/loans/return_details');
    }


}
