<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
* Description of Dashboard
*
* @author test
*/

class Getactions extends MY_Controller{

    public function __construct() {
        parent::__construct();
        ( $this->require_role('employee'));
        $this->load->helper('accounting/journals/helper');
        $this->load->model(array(
            'accounting/accounting'=>'accountingModel',
            'accounting/JournalsModel'=>'journalsModel',
            'accounting/GlModel'=>'glModel',
        ));
        $this->iamactive();
    }

    function overview(){
        $this->pagedata['title'] = 'Journals | '.$this->config->item('application_name');
        $this->pagedata['types'] = $this->accountingModel->accountTypes();
        $this->pagedata['rules'] = $this->accountingModel->accountingRules();
        $this->load->vars($this->pagedata);
        $this->load->view($this->auth_role.'/accounting/journals/actions/overview');
    }

    function registerexpense()
    {
        $this->load->model(array(
            'expenses/ExpensesModel'=>'expensesModel',
            'expenses/ExpensesBudgetsModel'=>'expensesBudgetsModel',
            'expenses/ExpensesTypesModel'=>'expensesTypesModel',
            'expenses/ExpensesCategoriesModel'=>'expensesCategoriesModel'
        ));
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');


        $j['j_key'] = $this->journalsModel->jKey();
        $j['j_date'] = date('Y-m-d H:i:s',strtotime($this->input->get('expense_date_posted', TRUE)));
        $j['j_title'] = $this->input->get('expense_journal_title', TRUE);
        $j['j_business'] = runningBusiness()->business_key;
        $j['j_branch'] = runningBranch()->branch_key;
        $j['j_user'] = $this->auth_user_id;

        $data['expense_business'] = runningBusiness()->business_key;
        $data['expense_branch'] = runningBranch()->branch_key;
        $data['expense_creator'] = $this->auth_user_id;
        $data['expense_date_posted'] = date('Y-m-d H:i:s',strtotime($this->input->get('expense_date_posted', TRUE)));
        $data['expense_account'] = $this->input->get('expense_account', TRUE);
        $data['expense_withdraw_account'] = $this->input->get('expense_withdraw_account', TRUE);
        $data['expense_status'] = $this->input->get('expense_status', TRUE);
        $data['expense_payee'] = $this->input->get('expense_payee', TRUE);
        $data['expense_category'] = $this->input->get('expense_category', TRUE);
        $data['expense_type'] = $this->input->get('expense_type', TRUE);
        $data['expense_budget'] = $this->input->get('expense_budget', TRUE);
        $data['expense_details'] = $this->input->get('expense_details', TRUE);
        $data['expense_amount'] = to_dollar(str_ireplace(',', '', $this->input->get('expense_amount', TRUE)));
        $data['expense_paid'] = to_dollar(str_ireplace(',', '', $this->input->get('expense_paid', TRUE)));
        $data['expense_key'] = $this->expensesModel->expenseKey();
        $data['expense_is_journal'] = 1;
        $data['expense_journal'] = $j['j_key'];

        if($data['expense_paid'] >= $data['expense_amount']){
            $data['expense_paid_full'] = 1;
        }

        if($data['expense_paid'] > $data['expense_amount'] & $data['expense_status'] == 'Approved'){
            $results['message'] = 'You can not pay more than '.number_format(to_money($data['expense_amount']));
            $results['status'] = false;
            echo json_encode($results, JSON_PRETTY_PRINT);
            return;
        }

        if($data['expense_status'] == 'Approved'){
            $budgetbalance = $this->expensesBudgetsModel->getBalance($data['expense_budget']);
            if($budgetbalance < $data['expense_paid']){
                $results['message'] = 'You can not spend more than budget, Budget balance is '.number_format(to_money($budgetbalance));
                $results['status'] = false;
                echo json_encode($results, JSON_PRETTY_PRINT);
                return;
            }
        }

        $gl_debit['gl_business'] = runningBusiness()->business_key;
        $gl_debit['gl_branch'] = runningBranch()->branch_key;
        $gl_debit['gl_user'] = $this->auth_user_id;
        $gl_debit['gl_status'] = $data['expense_status'];
        $gl_debit['gl_debit'] = $data['expense_paid'];
        $gl_debit['gl_credit'] = 0;
        $gl_debit['gl_account'] = $this->expensesCategoriesModel->details($data['expense_category'])->category_expense_account;
        $gl_debit['gl_activity'] = $data['expense_key'];
        $gl_debit['gl_category'] = "expenses";
        $gl_debit['gl_date'] = $data['expense_date_posted'];
        $gl_debit['gl_key'] = $this->glModel->glKey();
        $gl_debit['gl_is_journal'] = 1;
        $gl_debit['gl_journal'] = $j['j_key'];

        $gl_credit['gl_business'] = runningBusiness()->business_key;
        $gl_credit['gl_branch'] = runningBranch()->branch_key;
        $gl_credit['gl_user'] = $this->auth_user_id;
        $gl_credit['gl_status'] = $data['expense_status'];
        $gl_credit['gl_debit'] = 0;
        $gl_credit['gl_credit'] = $data['expense_paid'];
        $gl_credit['gl_account'] = $data['expense_withdraw_account'];
        $gl_credit['gl_activity'] = $data['expense_key'];
        $gl_credit['gl_category'] = "expenses";
        $gl_credit['gl_date'] = $data['expense_date_posted'];
        $gl_credit['gl_key'] = $this->glModel->glKey();
        $gl_credit['gl_is_journal'] = 1;
        $gl_credit['gl_journal'] = $j['j_key'];


        $this->db->trans_start();
        $this->db->insert('accounting_general_ledger', $gl_credit);
        $this->db->insert('accounting_general_ledger', $gl_debit);
        $this->db->insert('accounting_journals', $j);

        $this->db->insert('expenses', $data);
        if (!empty($this->input->get('uploadedfiles'))) {
            $raw = explode('LM-55', $_GET['uploadedfiles']);
            foreach ($raw as $key => $file) {
                $file = unserialize($file);
                if (is_array($file)) {
                    foreach ($file as $dt) {
                        if (!empty($dt)) {
                            $filedata['doc_expense'] = $data['expense_key'] ;
                            $filedata['doc_name'] = $dt['doc_name'];
                            $filedata['doc_type'] = $dt['doc_type'];
                            $filedata['doc_ext'] = $dt['doc_ext'];
                            $this->db->insert('expense_docs', $filedata);
                        }
                    }
                }
            }
        }
        $this->db->trans_complete();
        if ($this->db->trans_status() == TRUE) {
            publishEventFlash("expenses_register");
            $results['message'] = 'Expense registered successfully ';
            $results['status'] = true;

        } else {
            $results['message'] = 'Failed to register expense';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }
    function expenses(){
      $this->load->helper('form');
      $this->load->view($this->auth_role.'/accounting/journals/actions/expenses/overview');
  }

    function newexpense(){
        $this->load->model(array(
            'expenses/ExpensesModel'=>'expensesModel',
            'expenses/ExpensesBudgetsModel'=>'expensesBudgetsModel',
            'expenses/ExpensesTypesModel'=>'expensesTypesModel',
            'accounting/Accounting'=>'accountingModel',
            'expenses/ExpensesCategoriesModel'=>'expensesCategoriesModel'
        ));
        $this->load->helper('form');
        $this->load->view($this->auth_role.'/accounting/journals/actions/expenses/newexpense');
    }

    function setgeneralstatus($password='',$activity='',$status=''){

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if (empty($password)) {
            $results['status'] = false;
            $results['message'] = 'You must provide password';
            echo json_encode($results, JSON_PRETTY_PRINT);
            return;
        }

        if (!checkAccessPassword($password)) {
            $results['status'] = false;
            $results['message'] = 'You provided wrong password';
            echo json_encode($results, JSON_PRETTY_PRINT);
            return;
        }

        $this->db->trans_start();
        $data['gl_status'] = urldecode($status);
        $this->db->where('gl_activity',$activity);
        $this->db->where('gl_category',"general");
        $this->db->update("accounting_general_ledger",$data);

        $this->db->trans_complete();
        if($this->db->trans_status() === TRUE){
            publishEventFlash("gl_updated");
            $results['message'] = 'Changes applied successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to save changes';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function general(){
        $this->load->helper('form');
        $this->load->view($this->auth_role.'/accounting/journals/actions/general/overview');
    }

    function newgeneral(){
        $this->load->model(array(
            'expenses/ExpensesModel'=>'expensesModel',
            'expenses/ExpensesBudgetsModel'=>'expensesBudgetsModel',
            'expenses/ExpensesTypesModel'=>'expensesTypesModel',
            'accounting/Accounting'=>'accountingModel',
            'expenses/ExpensesCategoriesModel'=>'expensesCategoriesModel'
        ));

        $this->load->helper('form');
        $this->load->view($this->auth_role.'/accounting/journals/actions/general/newgeneral');
    }

    function registergeneral(){

        if(!isAjax()){
            header('Content-Type: application/json');
            header('Access-Control-Allow-Origin: ' . base_url());
            header('Access-Control-Allow-Methods: GET, POST');
            header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

            $data['j_key'] = $this->journalsModel->jKey();
            $data['j_business'] = runningBusiness()->business_key;
            $data['j_branch'] = runningBranch()->branch_key;
            $data['j_user'] = $this->auth_user_id;
            $data['j_date'] = date('Y-m-d H:i:s',strtotime($this->input->get('j_date', TRUE)));
            $data['j_title'] = $this->input->get('j_title', TRUE);

            $gl_debit['gl_business'] = runningBusiness()->business_key;
            $gl_debit['gl_branch'] = runningBranch()->branch_key;
            $gl_debit['gl_user'] = $this->auth_user_id;
            $gl_debit['gl_status'] = $this->input->get('j_status', TRUE);
            $gl_debit['gl_debit'] = to_dollar(str_ireplace(',', '', $this->input->get('j_amount', TRUE)));
            $gl_debit['gl_credit'] = 0;
            $gl_debit['gl_account'] = $this->input->get('j_debit_account', TRUE);
            $gl_debit['gl_activity'] = $data['j_key'];
            $gl_debit['gl_category'] = "general";
            $gl_debit['gl_date'] = $data['j_date'];
            $gl_debit['gl_key'] = $this->glModel->glKey();
            $gl_debit['gl_is_journal'] = 1;
            $gl_debit['gl_journal'] = $data['j_key'];

            $gl_credit['gl_business'] = runningBusiness()->business_key;
            $gl_credit['gl_branch'] = runningBranch()->branch_key;
            $gl_credit['gl_user'] = $this->auth_user_id;
            $gl_credit['gl_status'] = $this->input->get('j_status', TRUE);
            $gl_credit['gl_debit'] = 0;
            $gl_credit['gl_credit'] = to_dollar(str_ireplace(',', '', $this->input->get('j_amount', TRUE)));
            $gl_credit['gl_account'] = $this->input->get('j_credit_account', TRUE);
            $gl_credit['gl_activity'] = $data['j_key'];
            $gl_credit['gl_category'] = "general";
            $gl_credit['gl_date'] = $data['j_date'];
            $gl_credit['gl_key'] = $this->glModel->glKey();
            $gl_credit['gl_is_journal'] = 1;
            $gl_credit['gl_journal'] = $data['j_key'];
            $this->db->trans_start();

            $this->db->insert('accounting_general_ledger', $gl_credit);
            $this->db->insert('accounting_general_ledger', $gl_debit);
            $this->db->insert('accounting_journals', $data);
            $this->db->trans_complete();
            if ($this->db->trans_status() == TRUE) {
                publishEventFlash("journal_register");
                $results['message'] = 'Journal registered successfully ';
                $results['status'] = true;

            } else {
                $results['message'] = 'Failed to register Journal';
                $results['status'] = false;
            }

            echo json_encode($results, JSON_PRETTY_PRINT);
        }
    }

    function savegeneral($activity){

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $password = $this->input->get('passwd',TRUE);

        if (empty($password)) {
            $results['status'] = false;
            $results['message'] = 'You must provide password';
            echo json_encode($results, JSON_PRETTY_PRINT);
            return;
        }

        if (!checkAccessPassword($password)) {
            $results['status'] = false;
            $results['message'] = 'You provided wrong password';
            echo json_encode($results, JSON_PRETTY_PRINT);
            return;
        }


        $data['j_user'] = $this->auth_user_id;
        $data['j_date'] = date('Y-m-d H:i:s',strtotime($this->input->get('j_date', TRUE)));
        $data['j_title'] = $this->input->get('j_title', TRUE);

        $gl_debit['gl_business'] = runningBusiness()->business_key;
        $gl_debit['gl_branch'] = runningBranch()->branch_key;
        $gl_debit['gl_user'] = $this->auth_user_id;
        $gl_debit['gl_status'] = $this->input->get('j_status', TRUE);
        $gl_debit['gl_debit'] = to_dollar(str_ireplace(',', '', $this->input->get('j_amount', TRUE)));
        $gl_debit['gl_credit'] = 0;
        $gl_debit['gl_account'] = $this->input->get('j_debit_account', TRUE);
        $gl_debit['gl_activity'] = $activity;
        $gl_debit['gl_category'] = "general";
        $gl_debit['gl_date'] = $data['j_date'];
        $gl_debit['gl_key'] = $this->glModel->glKey();
        $gl_debit['gl_is_journal'] = 1;
        $gl_debit['gl_journal'] = $activity;

        $gl_credit['gl_business'] = runningBusiness()->business_key;
        $gl_credit['gl_branch'] = runningBranch()->branch_key;
        $gl_credit['gl_user'] = $this->auth_user_id;
        $gl_credit['gl_status'] = $this->input->get('j_status', TRUE);
        $gl_credit['gl_debit'] = 0;
        $gl_credit['gl_credit'] = to_dollar(str_ireplace(',', '', $this->input->get('j_amount', TRUE)));
        $gl_credit['gl_account'] = $this->input->get('j_credit_account', TRUE);
        $gl_credit['gl_activity'] = $activity;
        $gl_credit['gl_category'] = "general";
        $gl_credit['gl_date'] = $data['j_date'];
        $gl_credit['gl_key'] = $this->glModel->glKey();
        $gl_credit['gl_is_journal'] = 1;
        $gl_credit['gl_journal'] = $activity;

        $this->db->trans_start();

        $this->db->where('gl_activity',$activity);
        $this->db->delete('accounting_general_ledger');

        $this->db->insert('accounting_general_ledger', $gl_credit);
        $this->db->insert('accounting_general_ledger', $gl_debit);

        $this->db->where('j_key',$activity);
        $this->db->update('accounting_journals', $data);

        $this->db->trans_complete();
        if ($this->db->trans_status() === TRUE) {
            publishEventFlash("journal_updated");
            $results['message'] = 'Journal updated successfully ';
            $results['status'] = true;

        } else {
            $results['message'] = 'Failed to update Journal';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function loanreturn(){
        $this->load->helper('form');
        $this->load->view($this->auth_role.'/accounting/journals/actions/loans/return');
    }

    function newreturn(){
        $this->load->model(array(
            'expenses/ExpensesModel'=>'expensesModel',
            'expenses/ExpensesBudgetsModel'=>'expensesBudgetsModel',
            'expenses/ExpensesTypesModel'=>'expensesTypesModel',
            'accounting/Accounting'=>'accountingModel',
            'expenses/ExpensesCategoriesModel'=>'expensesCategoriesModel'
        ));
        $this->load->helper('form');
        $this->load->view($this->auth_role.'/accounting/journals/actions/loans/newreturn');
    }
    
    function registerreturn(){

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        authWithTimeAjax();

        $this->load->library(array(
            'LoanApplicationLibrary'=>'loanApplicationLibrary'
        ));

        $this->load->model(array(
            'loans/LoansModel'=>'loansModel'
        ));

        $installments = $this->input->get('return_payments',TRUE);
        $appKey = $this->input->get('return_application');
        $loanKey = $this->loansModel->applicationDetails($appKey)->app_loan;
        $customer = profile($this->loansModel->applicationDetails($appKey)->app_customer);
        $loan = $this->loansModel->loan($loanKey);
        $amount = str_ireplace(',', '', $this->input->get('return_amount', TRUE));
        $result['message'] = '';
        $error = false;

        if(empty($installments)){
            $result['message'] += 'You must specify installments to process its return.<br/> ';
            $result['status'] = false;
            $error = true;
        }

        if(!$this->loansModel->applicationapproved($appKey)){
            $result['message'] += 'You can not process inactive loan application.<br/>';
            $result['status'] = false;
            $error = true;
        }

        if($amount <= 0){
            $result['message'] += 'Please check well return amount.<br/>';
            $result['status'] = false;
            $error = true;
        }

        if($error){
            print json_encode($result, JSON_PRETTY_PRINT);
            exit();
        }
        
        $this->load->library(array(
           'LoanApplicationLibrary'=>'loanApplicationLibrary'
       ));

       $this->load->model(array(
           'accounting/Accounting'=>'accountingModel',
           'accounting/JournalsModel'=>'journalsModel',
           'accounting/GlModel'=>'glModel',
           'loans/LoansModel'=>'loansModel'
       ));
       
        $this->db->trans_start();

        $data['j_key'] = $this->journalsModel->jKey();
        $data['j_business'] = runningBusiness()->business_key;
        $data['j_branch'] = runningBranch()->branch_key;
        $data['j_user'] = $this->auth_user_id;
        $data['j_date'] = date('Y-m-d H:i:s',strtotime($this->input->get('return_date', TRUE)));
        $data['j_title'] = $customer->firstname.' '.$customer->lastname.' - '.$this->input->get('return_journal_title', TRUE);
        $this->db->insert('accounting_journals', $data);

        foreach ($installments as $row){  
            
            $payment = $this->loansModel->paymentdetails($row);
            $amount = $payment->loan_payment_amount;
            $appKey = $payment->loan_payment_app;
            $loanKey = $this->loansModel->applicationDetails($appKey)->app_loan;
            $customer = profile($payment->loan_payment_customer);
            $loan = $this->loansModel->loan($loanKey);

            $payAmount = $this->loansModel->loanInstallmentAmount($appKey,$installment);
            $balance  =  $amount - round(to_money($payAmount),2);
            
            if($balance > -1){
            $data['j_key'] = $this->journalsModel->jKey();
            $data['j_business'] = runningBusiness()->business_key;
            $data['j_branch'] = runningBranch()->branch_key;
            $data['j_user'] = $this->auth_user_id;
            $data['j_date'] = date('Y-m-d H:i:s');
            $data['j_title'] = $customer->firstname.' '.$customer->lastname.' - loan collection';
            $this->db->insert('accounting_journals', $data);

            $dataPay = $this->loanApplicationLibrary->preparePayment($payment,$amount);

            $data['principal'] = $dataPay['loan_payment_principal_collected'];
            $data['interest'] = $dataPay['loan_payment_interest_collected'];
            $data['charges_repeat'] = $dataPay['loan_payment_charges_collected'];

            $data['status'] = 'Pending';
            $data['app_key'] = $appKey;
            $data['customer'] = $customer->user_id;      

            $this->loanApplicationLibrary->collectApplicationPaymentsJournal($data);
            $this->db->where('loan_payment_id',$payment->loan_payment_id);
                $this->db->update('loan_payments',$dataPay);
                $this->db->trans_complete();
                if($this->db->trans_status()){
                    $result['message'] = 'Congratulations! You have successfully collected payment';
                    $result['status'] = true;
                }else{
                    $result['message'] = 'Unfortunately, You request could not be completed';
                    $result['status'] = false;
                }
                $amount = $amount - round(to_money($payAmount),2);
            
            }else{
                $result['message'] = 'System can not process '.number_format($balance);
                $result['status'] = false;
            }
        }
        
        print json_encode($result, JSON_PRETTY_PRINT);
    }
    
    function updatereturn($journal){

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        authWithTimeAjax();

        $this->load->library(array(
            'LoanApplicationLibrary'=>'loanApplicationLibrary'
        ));

        $this->load->model(array(
            'accounting/Accounting'=>'accountingModel',
            'accounting/Journals'=>'journalsModel',
            'accounting/GlModel'=>'glModel',
            'loans/LoansModel'=>'loansModel'
        ));

        $installments = $this->input->get('return_payments',TRUE);
        $appKey = $this->input->get('return_application');
        $loanKey = $this->loansModel->applicationDetails($appKey)->app_loan;
        $customer = profile($this->loansModel->applicationDetails($appKey)->app_customer);
        $loan = $this->loansModel->loan($loanKey);
        $amount = str_ireplace(',', '', $this->input->get('return_amount', TRUE));
        $result['message'] = '';
        $error = false;

        if(empty($installments)){
            $result['message'] += 'You must specify installments to process its return.<br/> ';
            $result['status'] = false;
            $error = true;
        }

        if(!$this->loansModel->applicationapproved($appKey)){
            $result['message'] += 'You can not process inactive loan application.<br/>';
            $result['status'] = false;
            $error = true;
        }

        if($amount <= 0){
            $result['message'] += 'Please check well return amount.<br/>';
            $result['status'] = false;
            $error = true;
        }

        if($error){
            print json_encode($result, JSON_PRETTY_PRINT);
            exit();
        }
        $this->db->trans_start();

        $data['j_key'] = $journal;
        $data['j_business'] = runningBusiness()->business_key;
        $data['j_branch'] = runningBranch()->branch_key;
        $data['j_user'] = $this->auth_user_id;
        $data['j_date'] = date('Y-m-d H:i:s',strtotime($this->input->get('return_date', TRUE)));
        $data['j_title'] = $this->input->get('return_journal_title', TRUE);
        $this->db->where('j_key',$journal);
        $this->db->update('accounting_journals', $data);

        $this->db->where('gl_activity',$journal);
        $this->db->delete('accounting_general_ledger');

        
        foreach ($installments as $row){  
            
            $payment = $this->loansModel->paymentdetails($row);
            $amount = $payment->loan_payment_amount;
            $appKey = $payment->loan_payment_app;
            $loanKey = $this->loansModel->applicationDetails($appKey)->app_loan;
            $customer = profile($payment->loan_payment_customer);
            $loan = $this->loansModel->loan($loanKey);

            $payAmount = $this->loansModel->loanInstallmentAmount($appKey,$payment->loan_payment_number);
            $balance  =  $amount - round(to_money($payAmount),2);
            
            if($balance > -1){
            $data['j_key'] = $this->journalsModel->jKey();
            $data['j_business'] = runningBusiness()->business_key;
            $data['j_branch'] = runningBranch()->branch_key;
            $data['j_user'] = $this->auth_user_id;
            $data['j_date'] = date('Y-m-d H:i:s');
            $data['j_title'] = $customer->firstname.' '.$customer->lastname.' - loan collection';
            $this->db->insert('accounting_journals', $data);

            $dataPay = $this->loanApplicationLibrary->preparePayment($payment,$amount);

            $data['principal'] = $dataPay['loan_payment_principal_collected'];
            $data['interest'] = $dataPay['loan_payment_interest_collected'];
            $data['charges_repeat'] = $dataPay['loan_payment_charges_collected'];

            $data['status'] = 'Pending';
            $data['app_key'] = $appKey;
            $data['customer'] = $customer->user_id;      

            $this->loanApplicationLibrary->collectApplicationPaymentsJournal($data);
            $this->db->where('loan_payment_id',$payment->loan_payment_id);
                $this->db->update('loan_payments',$dataPay);
                $this->db->trans_complete();
                if($this->db->trans_status()){
                    $result['message'] = 'Congratulations! You have successfully collected payment';
                    $result['status'] = true;
                }else{
                    $result['message'] = 'Unfortunately, You request could not be completed';
                    $result['status'] = false;
                }
                $amount = $amount - round(to_money($payAmount),2);
            
            }else{
                $result['message'] = 'System can not process '.number_format($balance);
                $result['status'] = false;
            }
        }
        
        print json_encode($result, JSON_PRETTY_PRINT);
    }
    
    
    function setloansstatus($password='',$activity='',$status=''){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if (empty($password)) {
            $results['status'] = false;
            $results['message'] = 'You must provide password';
            echo json_encode($results, JSON_PRETTY_PRINT);
            return;
        }

        if (!checkAccessPassword($password)) {
            $results['status'] = false;
            $results['message'] = 'You provided wrong password';
            echo json_encode($results, JSON_PRETTY_PRINT);
            return;
        }

        $this->db->trans_start();
        $data['gl_status'] = urldecode($status);
        $this->db->where('gl_activity',$activity);
        $this->db->where('gl_category',"loans");
        $this->db->update("accounting_general_ledger",$data);

        $this->db->trans_complete();
        if($this->db->trans_status() === TRUE){
            publishEventFlash("gl_updated");
            $results['message'] = 'Changes applied successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to save changes';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }



}
