<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require_once dirname(APPPATH).'/resources/includes/lib/pdf/vendor/autoload.php';
/**
* Description of Freight Forwarding
*
* @author Elieza Kalaita
*/

class Index extends MY_Controller{

    public  $pagedata;

    public function __construct() {
    parent::__construct();
    $this->require_min_level(1);
    $this->pagedata['link']= 'freight';
    $this->load->helper('freight_forward/helper');
    $this->load->helper('crm/crm_helper');
    $this->load->helper('invoices/helper');
    $this->load->library(array('qrcode/Qrcodes'=>'qrcodes'));
    $this->load->library(array('AppLibrary'=>'appLibrary'));
    $this->load->vars($this->pagedata);
    $this->load->model(array(
        'freight/FreightsModel'=>'freightsModel',
        'freight/PlansModel'=>'plansModel',
        'CountriesModel'=>'countriesModel',
        'freight/CategoriesModel'=>'categoriesModel',
        'freight/AssessedValuationModel'=>'assessedValuationModel',
        'freight/DeclaredValuationModel'=>'declaredValuationModel',
        'freight/ImportersModel'=>'importersModel',
        'freight/ExportersModel'=>'exportersModel',
        'freight/DocumentsModel'=>'documentsModel',
        'freight/StagesModel'=>'stagesModel',
        'quotations/QuotationsModel'=>'quotationsModel',
        'invoices/InvoicesModel'=>'invoicesModel',
        'invoices/InvoiceTransactionsModel'=>'invoiceTransactionsModel',
        'crm/CustomersModel' => 'customersModel',
        'freight/RequestModel' => 'requestModel',
        'freight/DeliveryNoteModel' => 'deliveryNoteModel',
        'expenses/ExpensesModel'=>'expensesModel',
        'accounting/GeneralLedgerModel'=>'generalLedgerModel'
      ));
  }
 
    public function index() {
        /** This is the core function which loads freight list page (Freight Forwarding) */
        /** @author Elieza Kalaita */

    has_control('freight_view_all','View all freights');
    $this->pagedata['title'] = 'Freight List | '.$this->config->item('application_name');
    $this->load->vars($this->pagedata);
    $this->load->view('freight/freight');
  }

    public function settings(){
        /** This function loads freight settings page (Freight Forwarding) */
        /** @author Elieza Kalaita */

      $this->pagedata['title'] = "Freight Settings |" .$this->config->item('application_name');
      $this->load->helper('form');
      $this->load->vars($this->pagedata);
      $this->load->view('freight/settings');
  }

    function create(){
        /** This function loads create freight page (Freight Forwarding) */
        /** @author Elieza Kalaita */

        has_control_ajax('freight_create','Create freights');
      $this->pagedata['title'] = "Create Freight | ".$this->config->item('application_name');
      $this->load->helper('form');
      $this->load->vars($this->pagedata);
      $this->load->view('freight/create');
  }

    function importers(){
      $this->pagedata['title'] = "Importers List | ".$this->config->item('application_name');
      $this->load->helper('form');
      $this->load->vars($this->pagedata);
      $this->load->view('freight/importers');
  }

    function exporters(){
      $this->pagedata['title'] = "Exporters List | ".$this->config->item('application_name');
      $this->load->helper('form');
      $this->load->vars($this->pagedata);
      $this->load->view('freight/exporters');
  }

    function documents($id){
        /** This function loads freight documents page (Freight Forwarding) */
        /** @author Elieza Kalaita */

        has_control('freight_view_all','View freights');
      $this->pagedata['title'] = "Freight Documentation | ".$this->config->item('application_name');
      $this->load->helper('form');
      $this->pagedata['freight'] = $this->freightsModel->find($id);
      $this->load->vars($this->pagedata);
      $this->load->view('freight/documents');
  }

    function stages($id){
        /** This function loads freight stages page (Freight Forwarding) */
        /** @author Elieza Kalaita */

        has_control('freight_view_stages', 'View Freight');
      $this->pagedata['title'] = "Freight Stages | ".$this->config->item('application_name');
      $this->load->helper('form');
      $this->pagedata['freight_key'] = $id;
      $this->load->vars($this->pagedata);
      $this->load->view('freight/stages');
  }

    function quotations($id){
        /** This function loads freight quotations page (Freight Forwarding) */
        /** @author Elieza Kalaita */

        has_control('quotation_view_all', 'View Quotation');
      $this->pagedata['title'] = "Freight Quotations | ".$this->config->item('application_name');
      $this->load->helper('form');
      $this->pagedata['freight_key'] = $id;
      $this->load->vars($this->pagedata);
      $this->load->view('freight/quotations/quotations');
  }

    function invoices($id){
        /** This function loads freight invoices page (Freight Forwarding) */
        /** @author Elieza Kalaita */

        has_control('invoice_view_all', 'View Invoice');
      $this->pagedata['title'] = "Freight Invoices | ".$this->config->item('application_name');
      $this->load->helper('form');
      $this->pagedata['freight_key'] = $id;
      $this->load->vars($this->pagedata);
      $this->load->view('freight/invoices/invoices');
  }

    function sendEmail($key=''){
        /** This function converts a quotation template to pdf then send to a client email (Freight Forwarding) */
        /** @author Elieza Kalaita */

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $this->load->model(array('taxes/taxesModel' => 'taxesModel','accounting/accounting' => 'accountingModel'));
        $this->pagedata['quotation']= $this->quotationsModel->find($key);
        $this->pagedata['items']= $this->quotationsModel->quotationItems($this->pagedata['quotation']['quot_id']);
        $this->pagedata['taxes']= $this->quotationsModel->quotationTaxes($this->pagedata['quotation']['quot_id']);
        $this->load->vars($this->pagedata);
        $this->load->helper('form');
        $this->load->helper('crm/crm_helper');
        $this->load->helper('quotations/helper');
        $this->pagedata['title'] = 'Quotation | '.$this->config->item('application_name');

        // load library
        $this->load->library('email');
        $this->load->library('pdf');
        $this->load->library(array('qrcode/Qrcodes'=>'qrcodes'));
        $this->load->view('quotations/details_print');
        
        $html = $this->load->view('quotations/details_print','',TRUE);
        // render the view into HTML
        
        //----begin: Custom vars ------//
        $fileName = md5(rand()).'.pdf';
        $filePath = uploadPath('mail_attachment/'.$fileName);
        //$output = $html;
        //----end: Custom var------//

        $this->pdf->generate_pdf($html, $filePath);

        $param['recepient'] = $this->input->post('compose_to', true);
        $param['subject'] = $this->input->post('compose_subject', true);
        $param['message'] = $this->input->post('compose_msg', true);

        if($this->appLibrary->send_quot($param, $filePath)){
            $result['status'] = true;
            $result['message'] = 'Email successfully sent';
            //unlink($filePath);
        }else{
            $result['status'] = false;
            $result['message'] = checkError($this->dbexeption());
            //unlink($filePath);
        }
        print json_encode($result);
    }

    function sendInvoice($key=''){
        /** This function converts an invoice template to pdf then send to a client email (Freight Forwarding) */
        /** @author Elieza Kalaita */

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $this->load->model(array('taxes/taxesModel' => 'taxesModel','accounting/accounting' => 'accountingModel'));
        $this->pagedata['invoice']= $this->invoicesModel->find($key);
        $this->pagedata['items']= $this->invoicesModel->invoiceItems($this->pagedata['invoice']['inv_id']);
        $this->pagedata['taxes']= $this->invoicesModel->invoiceTaxes($this->pagedata['invoice']['inv_id']);
        $this->load->vars($this->pagedata);
        $this->load->helper('form');
        $this->load->helper('crm/crm_helper');
        $this->load->helper('invoices/helper');
        $this->pagedata['title'] = 'Invoice | '.$this->config->item('application_name');

        // load library
        $this->load->library('email');
        $this->load->library('pdf');
        $this->load->library(array('qrcode/Qrcodes'=>'qrcodes'));
        $this->load->view('invoices/details_print');

        $html = $this->load->view('invoices/details_print','',TRUE);
        // render the view into HTML

        //----begin: Custom vars ------//
        $fileName = md5(rand()).'.pdf';
        $filePath = uploadPath('mail_attachment/'.$fileName);
        //$output = $html;
        //----end: Custom var------//

        $this->pdf->generate_pdf($html, $filePath);

        $param['recepient'] = $this->input->post('compose_to', true);
        $param['subject'] = $this->input->post('compose_subject', true);
        $param['message'] = $this->input->post('compose_msg', true);

        if($this->appLibrary->send_quot($param, $filePath)){
            $result['status'] = true;
            $result['message'] = 'Email successfully sent';
            //unlink($filePath);
        }else{
            $result['status'] = false;
            $result['message'] = checkError($this->dbexeption());
            //unlink($filePath);
        }
        print json_encode($result);
    }

    function send_debit_note($key){
        /** This function converts a debit note template to pdf then send to a client email (Freight Forwarding) */
        /** @author Elieza Kalaita */

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $freight_key = $this->input->post('freight', true);
        $this->load->model(array('taxes/taxesModel' => 'taxesModel','accounting/accounting' => 'accountingModel'));
        $this->pagedata['invoice']= $this->invoicesModel->find($key);
        $this->pagedata['items']= $this->invoicesModel->invoiceItems($this->pagedata['invoice']['inv_id']);
        $this->pagedata['taxes']= $this->invoicesModel->invoiceTaxes($this->pagedata['invoice']['inv_id']);
        $this->pagedata['freight'] = $this->freightsModel->find($freight_key);
        $this->load->vars($this->pagedata);
        $this->load->helper('form');
        $this->load->helper('crm/crm_helper');
        $this->load->helper('invoices/helper');
        $this->pagedata['title'] = 'Invoice | '.$this->config->item('application_name');

        // load library
        $this->load->library('email');
        $this->load->library('pdf');
        $this->load->library(array('qrcode/Qrcodes'=>'qrcodes'));
        $this->load->view('freight/debit_print');

        $html = $this->load->view('freight/debit_print','',TRUE);
        // render the view into HTML

        //----begin: Custom vars ------//
        $fileName = md5(rand()).'.pdf';
        $filePath = uploadPath('mail_attachment/'.$fileName);
        //$output = $html;
        //----end: Custom var------//

        $this->pdf->generate_pdf($html, $filePath);

        $param['recepient'] = $this->input->post('compose_to', true);
        $param['subject'] = $this->input->post('compose_subject', true);
        $param['message'] = $this->input->post('compose_msg', true);

        if($this->appLibrary->send_quot($param, $filePath)){
            $result['status'] = true;
            $result['message'] = 'Email successfully sent';
            //unlink($filePath);
        }else{
            $result['status'] = false;
            $result['message'] = checkError($this->dbexeption());
            //unlink($filePath);
        }
        print json_encode($result);
    }

    /*
     * miscs
     */

//    function collectFreightData(){
//        return inputAllPost();
//    }

    /*
     * end miscs
     */

    //----------------Countries---------------//
    public function addcountry() {
        /** This is the function for creating a new country in freight settings page (Freight Forwarding) */
        /** @author Elieza Kalaita */

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        $this->load->model(array(
            'CountriesModel'=>'countriesModel',
        ));

        $data = array(
            'country_name' => $this->input->post('country',TRUE)
        );

        if($this->countriesModel->insert($data)){
            $results['message'] = 'Country added successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to add country';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();

    }
    public function country_details($key) {
        /** This is the function for loading country details into a modal country in freight settings page (Freight Forwarding) */
        /** @author Elieza Kalaita */

        $this->load->model(array('CountriesModel'=>'countriesModel'));
        $this->load->helper('form');
        $this->pagedata['country'] = $this->countriesModel->find($key);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/country_details');
    }
    public function modify_country() {
        /** This is the function for updating country details in freight settings page (Freight Forwarding) */
        /** @author Elieza Kalaita */

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $this->load->model(array(
            'CountriesModel'=>'countriesModel',
        ));

        $data = array(
            'country_name' => $this->input->post('country',TRUE)
        );

        $key = $this->input->post('country_key',TRUE);

        if($this->countriesModel->update($key,$data)){
            $results['message'] = 'Country updated successfully '.$key;
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to update country';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();

    }
    function datasource_contries(){
        /** This is the function for loading countries data table in freight settings page (Freight Forwarding) */
        /** @author Elieza Kalaita */

       $this->load->model(array('CountriesModel'=>'countriesModel'));
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->countriesModel->find_all();
        $columns = array();
        foreach ($this->countriesModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($data,$columns);
    }
    function datasource_contries_bin(){
        /** This is the function for loading deleted countries data table in freight settings page (Freight Forwarding) */
        /** @author Elieza Kalaita */

        $this->load->model(array('CountriesModel'=>'countriesModel'));
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));

        $this->countriesModel->where('country_deleted',1);
        $data = $this->countriesModel->with_deleted()->find_all();

        $columns = array();
        foreach ($this->countriesModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($data,$columns);
    }
    function delete_country($key=''){
        /** This is the function for deleting country data in freight settings page (Freight Forwarding) */
        /** @author Elieza Kalaita */

        $this->load->model(array('CountriesModel'=>'countriesModel'));
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if($this->countriesModel->delete($key)){
            $results['message'] = 'Country deleted successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to delete Country';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }
    function restore_country($key=''){
        /** This is the function for restoring deleted countries data in freight settings page (Freight Forwarding) */
        /** @author Elieza Kalaita */

        $this->load->model(array('CountriesModel'=>'countriesModel'));

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if($this->countriesModel->update($key,['country_deleted' => 0])){
            $results['message'] = 'Country restored successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to restore Country';
            $results['status'] = false;
        }


        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }
    //---------------End Countries-------------//


    //--------------Categories---------------------//
    public function addcategory() {
        /** This is the function for creating category of goods in freight settings page (Freight Forwarding) */
        /** @author Elieza Kalaita */

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $this->load->model(array(
            'freight/CategoriesModel'=>'categoriesModel',
        ));

        $data = array(
            'fr_category_name' => $this->input->post('category',TRUE)
        );

        if($this->categoriesModel->insert($data)){
            $results['message'] = 'Category added successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to add category';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();

    }
    public function category_details($key) {
        /** This is the function for retrieving data loaded on category modal in freight settings page (Freight Forwarding) */
        /** @author Elieza Kalaita */

        $this->load->model(array('freight/CategoriesModel'=>'categoriesModel'));

        $this->load->helper('form');
        $this->pagedata['category'] = $this->categoriesModel->find($key);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/category_details');
    }
    function datasource_categories()
    {
        /** This is the function for loading categories data table in freight settings page (Freight Forwarding) */
        /** @author Elieza Kalaita */

        $this->load->model(array('freight/CategoriesModel'=>'categoriesModel'));
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->categoriesModel->find_all();
        $columns = array();
        foreach ($this->categoriesModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($data,$columns);
    }
    function datasource_categories_bin(){
        /** This is the function for loading deleted categories data table in freight settings page (Freight Forwarding) */
        /** @author Elieza Kalaita */

        $this->load->model(array('freight/CategoriesModel'=>'categoriesModel'));
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));

        $this->categoriesModel->where('fr_category_deleted',1);
        $data = $this->categoriesModel->with_deleted()->find_all();

        $columns = array();
        foreach ($this->categoriesModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($data,$columns);
    }
    function delete_category($key=''){
        /** This is the function for deleting category og goods data in freight settings page (Freight Forwarding) */
        /** @author Elieza Kalaita */

        $this->load->model(array('freight/CategoriesModel'=>'categoriesModel'));
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if($this->categoriesModel->delete($key)){
            $results['message'] = 'Category deleted successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to delete Category';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }
    function restore_category($key='')
    {
        /** This is the function for restoring deleted category data in freight settings page (Freight Forwarding) */
        /** @author Elieza Kalaita */

        $this->load->model(array('freight/CategoriesModel'=>'categoriesModel'));
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if($this->categoriesModel->update($key,['fr_category_deleted' => 0])){
            $results['message'] = 'Category restored successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to restore Category';
            $results['status'] = false;
        }


        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }
    public function modify_category() {
        /** This is the function for updating category data in freight settings page (Freight Forwarding) */
        /** @author Elieza Kalaita */

        $this->load->model(array('freight/CategoriesModel'=>'categoriesModel'));
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $data = array(
            'fr_category_name' => $this->input->post('category',TRUE)
        );

        $key = $this->input->post('fr_category_key',TRUE);

        if($this->categoriesModel->update($key,$data)){
            $results['message'] = 'Category updated successfully '.$key;
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to update category';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }
    //--------------End Categories----------------//

    //--------------Plans-------------------------//
    public function addplan() {
        /** This is the function for creating shipment type in freight settings page (Freight Forwarding) */
        /** @author Elieza Kalaita */

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $this->load->model(array(
            'freight/PlansModel'=>'plansModel',
        ));

        $data = array(
            'fr_plan_name' => $this->input->post('plan',TRUE)
        );

        if($this->plansModel->insert($data)){
            $results['message'] = 'Plan added successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to add plan';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();

    }
    public function plan_details($key) {
        /** This is the function for loading shipment type data into a shipment modal in freight settings page (Freight Forwarding) */
        /** @author Elieza Kalaita */

        $this->load->model(array('freight/PlansModel'=>'plansModel'));

        $this->load->helper('form');
        $this->pagedata['plan'] = $this->plansModel->find($key);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/plan_details');
    }
    function datasource_plans()
    {
        /** This is the function for loading shipments data table in freight settings page (Freight Forwarding) */
        /** @author Elieza Kalaita */

        $this->load->model(array('freight/PlansModel'=>'plansModel'));
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->plansModel->find_all();
        $columns = array();
        foreach ($this->plansModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($data,$columns);
    }
    function datasource_plans_bin(){
        /** This is the function for loading deleted shipment type data table in freight settings page (Freight Forwarding) */
        /** @author Elieza Kalaita */

        $this->load->model(array('freight/PlansModel'=>'plansModel'));
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));

        $this->plansModel->where('fr_plan_deleted',1);
        $data = $this->plansModel->with_deleted()->find_all();

        $columns = array();
        foreach ($this->plansModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($data,$columns);
    }
    function delete_plan($key=''){
        /** This is the function for deleting shipment type data in freight settings page (Freight Forwarding) */
        /** @author Elieza Kalaita */

        $this->load->model(array('freight/PlansModel'=>'plansModel'));
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if($this->plansModel->delete($key)){
            $results['message'] = 'Plan deleted successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to delete Plan';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }
    function restore_plan($key='')
    {
        /** This is the function for restoring shipment data in freight settings page (Freight Forwarding) */
        /** @author Elieza Kalaita */

        $this->load->model(array('freight/PlansModel'=>'plansModel'));
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if($this->plansModel->update($key,['fr_plan_deleted' => 0])){
            $results['message'] = 'Plan restored successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to restore Plan';
            $results['status'] = false;
        }


        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }
    public function modify_plan() {
        /** This is the function for updating shipment type data in freight settings page (Freight Forwarding) */
        /** @author Elieza Kalaita */

        $this->load->model(array('freight/PlansModel'=>'plansModel'));
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $data = array(
            'fr_plan_name' => $this->input->post('plan',TRUE)
        );

        $key = $this->input->post('fr_plan_key',TRUE);

        if($this->plansModel->update($key,$data)){
            $results['message'] = 'Plan updated successfully '.$key;
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to update plan';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }
    //--------------End Plans---------------------//

    //-------------- Freights---------------------//
    function createfreight(){
        /** This is the function for creating new freight (Freight Forwarding) */
        /** @author Elieza Kalaita */

        has_control('freight_create', 'Create Freight');
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        //$data = inputAllPost();
        $data['fr_agent_reference_number'] = $this->input->post('fr_agent_reference_number');
        $data['fr_processing_office'] = $this->input->post('fr_processing_office');
        $data['fr_cargo_details'] = $this->input->post('fr_cargo_details');
        $data['fr_vessel'] = $this->input->post('fr_vessel');
        $data['fr_client'] = $this->input->post('fr_client');
        $data['fr_eta_etd'] = $this->input->post('fr_eta_etd');
        $data['fr_importer'] = $this->input->post('fr_importer');
        $data['fr_loading_port'] = $this->input->post('fr_loading_port');
        $data['fr_discharge_port'] = $this->input->post('fr_discharge_port');
        $data['fr_max_number'] = $this->input->post('fr_max_number');
        $data['fr_container_seal'] = $this->input->post('fr_container_seal');
        $data['fr_gross_measure'] = $this->input->post('fr_gross_measure');
        $data['fr_gross_weight'] = $this->input->post('fr_gross_weight');
        $data['fr_delivery_place'] = $this->input->post('fr_delivery_place');
        $data['fr_category_of_goods'] = $this->input->post('fr_category_of_goods');
        $data['fr_cl_plan'] = $this->input->post('fr_cl_plan');

        if (!empty($this->input->post('uploadedfiles'))) {
            $raw = explode('LM-55', $_POST['uploadedfiles']);
            foreach ($raw as $key => $file) {
                $file = unserialize($file);
                if (is_array($file)) {
                    foreach ($file as $dt) {
                        if (!empty($dt)) {
                            $data['fr_doc'] = $dt['doc_file'];
                        }
                    }
                }
            }
        }
        $profile = profile();
        if($this->freightsModel->insert($data)){
            $res['message'] = 'Freight records added successfully';
            $res['status'] = true;

            /** Here we alert users on a new freight creation */
            $data['role_action'] = "freight_view_all";
            $data['title'] = "New freight created by ".$profile->firstname." ".$profile->lastname;
            $data['link']= base_url('freight');
            $data['content'] = "New freight was created";
            $data['sender'] = $this->auth_user_id;
            $data['type'] = 'freight';
            $data['target'] = 'system';
            $data['receiver'] = 'system';
            $data['time'] = date("H:i:s");
            publishEventFlash('freight', $data);
        }else{
            $res['message'] = 'Failed to add freight records';
            $res['status'] = false;
        }

        echo json_encode($res, JSON_PRETTY_PRINT);
        exit();
    }
    function add_freight_history(){
        /** This is the function for creating freight stage (Freight Forwarding) */
        /** @author Elieza Kalaita */

        has_control('freight_create_stages', 'Create Freight');
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        //$data = inputAllPost();
        $data['fr_stage_location'] = $this->input->post('fr_stage_location');
        $data['fr_stage_date'] = $this->input->post('fr_stage_date');
        $data['fr_stage_time'] = $this->input->post('fr_stage_time');
        $data['fr_stage_desc'] = $this->input->post('fr_stage_desc');
        $data['fr_key'] = $this->input->post('fr_key');

        if($this->stagesModel->insert($data)){
            $result['message'] = 'Freight history added successfully';
            $result['status'] = true;
        }else{
            $result['message'] = 'Failed to add freight history';
            $result['status'] = false;
        }

        echo json_encode($result, JSON_PRETTY_PRINT);
        exit();
    }
    function approve_freight_delivery(){
        /** This is the function for approving freight delivery (Freight Forwarding) */
        /** @author Elieza Kalaita */

        has_control('freight_update_stages', 'View Freight');
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        //$data = inputAllPost();
        $data['fr_stage_location'] = $this->input->post('fr_stage_location');
        $data['fr_stage_date'] = $this->input->post('fr_stage_date');
        $data['fr_stage_time'] = $this->input->post('fr_stage_time');
        $data['fr_stage_desc'] = $this->input->post('fr_stage_desc');
        $data['fr_key'] = $this->input->post('fr_key');


        $this->db->trans_start();
        $id = $this->stagesModel->insert($data);
        $rawData = $this->stagesModel->find_by(["fr_stage_id" => $id]);
        $status['fr_stage_status'] = 'Approved';
        $this->stagesModel->update_by(['fr_key'=>$rawData['fr_key']], $status);
        $this->db->trans_complete();

        if($this->db->trans_status() === TRUE){
            $result['message'] = 'Freight delivery successfully approved';
            $result['status'] = true;
        }else{
            $result['message'] = 'Failed to approve freight delivery';
            $result['status'] = false;
        }

        echo json_encode($result, JSON_PRETTY_PRINT);
        exit();
    }
    function modify_freight_history()
    {
        /** This is the function for updating freight stages data (Freight Forwarding) */
        /** @author Elieza Kalaita */

        has_control('freight_update_stages', 'Update Freight');
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $data['fr_stage_location'] = $this->input->post('fr_stage_location',TRUE);
        $data['fr_stage_date'] = $this->input->post('fr_stage_date',TRUE);
        $data['fr_stage_time'] = $this->input->post('fr_stage_time',TRUE);
        $data['fr_stage_desc'] = $this->input->post('fr_stage_desc',TRUE);

        $key = $this->input->post('fr_stage_key',TRUE);

        if($this->stagesModel->update($key,$data)){
            $results['message'] = 'Freight history successfully updated'.$key;
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to update freight history';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }

    function freight_details($key)
    {
        /** This is the function for loading summarized freight report (Freight Forwarding) */
        /** @author Elieza Kalaita */

        has_control('freight_view_report', 'View Freight');
        $this->load->helper('form');
        $this->pagedata['title'] = 'Freight Details | '.$this->config->item('application_name');
        $this->pagedata['freight'] = $this->freightsModel->find($key);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/freight_details');
        //echo json_encode($this->pagedata['freight'], JSON_PRETTY_PRINT);
        //exit();
    }
    function debit_note($key)
    {
        /** This is the function for loading debit note report (Freight Forwarding) */
        /** @author Elieza Kalaita */

        has_control('freight_view_report', 'View Freight');
        $this->load->helper('form');
        $this->pagedata['title'] = 'Freight Debit Note | '.$this->config->item('application_name');
        $this->pagedata['freight'] = $this->freightsModel->find($key);
        $this->pagedata['invoice'] = $this->invoicesModel->find_by(['freight_ref'=>$key]);
        $this->pagedata['payments'] = $this->invoiceTransactionsModel->find_by(['inv_pay_invoice'=>$this->pagedata['invoice']['inv_key']]);
        $this->pagedata['items']= $this->invoicesModel->invoiceItems($this->pagedata['invoice']['inv_id']);
        $this->pagedata['taxes']= $this->invoicesModel->invoiceTaxes($this->pagedata['invoice']['inv_id']);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/debit_note');
    }

    function datasource_freights($when='')
    {
        /** This is the function for loading freights data table (Freight Forwarding) */
        /** @author Elieza Kalaita */

        has_control('freight_view_all', 'View Freight');
        $this->load->model(array('freight/FreightsModel'=>'freightsModel'));
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));

        if(!empty($when)){
            $data = $this->freightsModel->order_by('fr_created_on', 'DESC')->group_by('fr_key')->find_many_by(["fr_created_on" => $when]);
        }else{
            $data = $this->freightsModel->order_by('fr_created_on', 'DESC')->group_by('fr_key')->find_all();
        }

        //$data = $this->freightsModel->order_by('fr_created_on', 'DESC')->find_all();
        $columns = array();
        foreach ($this->freightsModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        //$columns['country_name'] = TRUE;
        //$columns['country_name'] = TRUE;
        print $this->datasourceLibrary->server($data,$columns);
    }
    function datasource_freights1($when =''){
        /** This is the function for loading freights data table (Freight Forwarding) */
        /** @author Elieza Kalaita */

        has_control('freight_view_all', 'View Freight');
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->freightsModel->getFreights($when);
        $columns = [
            'fr_id' => true,
            'fr_key' => true,
            'firstname' => true,
            'lastname' => true,
            'company_name' => true,
            'fr_cargo_details'=> true,
            'fr_vessel'=> true,
            'fr_eta_etd'=> true,
            'fr_client'=> true,
            'fr_doc'=> true,
            'inv_key'=> true,
            'fr_file_status'=> true,
        ];
        print $this->datasourceLibrary->server($data,$columns);
    }
    function datasource_freight_stages($key)
    {
        /** This is the function for loading freight stages data table (Freight Forwarding) */
        /** @author Elieza Kalaita */

        has_control('freight_view_stages', 'View Freight');
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->stagesModel->getFreight($key);
        $columns = array();
        foreach ($this->stagesModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($data,$columns);
    }
    function freight_history_details($key)
    {
        /** This is the function for loading freight stage details modal (Freight Forwarding) */
        /** @author Elieza Kalaita */

        has_control('freight_view_stages', 'View Freight');
        $this->load->helper('form');
        $this->pagedata['history'] = $this->stagesModel->find($key);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/freight_history_details');
    }
    function datasource_freights_bin1($when='')
    {
        /** This is the function for loading deleted freights data table (Freight Forwarding) */
        /** @author Elieza Kalaita */

        has_control('freight_view_all', 'View Freight');
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->freightsModel->getFreightsBin($when);
        $columns = [
            'fr_id' => true,
            'fr_key' => true,
            'firstname' => true,
            'lastname' => true,
            'company_name' => true,
            'fr_cargo_details'=> true,
            'fr_vessel'=> true,
            'fr_eta_etd'=> true,
            'fr_client'=> true,
            'fr_doc'=> true,
            'inv_key'=> true,
            'fr_file_status'=> true,
        ];
        print $this->datasourceLibrary->server($data,$columns);
    }
    function datasource_freights_bin($when='')
    {
        /** This is the function for loading deleted freights data table (Freight Forwarding) */
        /** @author Elieza Kalaita */

        has_control('freight_view_all', 'View Freight');
        $this->load->model(array('freight/FreightsModel'=>'freightsModel'));
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $this->freightsModel->where('fr_deleted',1);
        if(!empty($when)){
            $data = $this->freightsModel->with_deleted()->order_by('fr_modified_on', 'DESC')->group_by('fr_key')->find_many_by(["fr_modified_on" => $when]);
        }else{
            $data = $this->freightsModel->with_deleted()->order_by('fr_modified_on', 'DESC')->group_by('fr_key')->find_all();
        }
        //$data = $this->freightsModel->with_deleted()->find_all();
        $columns = array();
        foreach ($this->freightsModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
//        $columns['country_name'] = TRUE;
//        $columns['country_name'] = TRUE;
        print $this->datasourceLibrary->server($data,$columns);
    }
    function close_freight($key){
        /** This is the function for closing file (Freight Forwarding) */
        /** @author Elieza Kalaita */

        has_control_ajax('freight_delete', 'Close File');
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $data['fr_file_status'] = 'Closed';
        if($this->freightsModel->update($key, $data)){
            $results['message'] = 'File successfully closed';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to close File';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }
    function delete_freight($key){
        /** This is the function for deleting freights data (Freight Forwarding) */
        /** @author Elieza Kalaita */

        has_control_ajax('freight_delete', 'Delete Freight');
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if($this->freightsModel->delete($key)){
            $results['message'] = 'Freight deleted successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to delete Freight';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }
    function restore_freight($key='')
    {
        /** This is the function for restoring deleted freights (Freight Forwarding) */
        /** @author Elieza Kalaita */

        has_control('freight_update', 'Restore Freight');
        $this->load->model(array('freight/FreightsModel'=>'freightsModel'));
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if($this->freightsModel->update($key,['fr_deleted' => 0])){
            $results['message'] = 'Freight restored successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to restore Freight';
            $results['status'] = false;
        }


        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }
    function editfreight($id)
    {
        /** This is the function for loading edit freight page (Freight Forwarding) */
        /** @author Elieza Kalaita */

        has_control('freight_update', 'Edit Freight Details');
        $this->pagedata['title'] = "Edit Freight |" .$this->config->item('application_name');
        $this->load->helper('form');
        $this->pagedata['data'] = $this->freightsModel->find($id);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/edit_freight');
    }
    function edit_freight($id)
    {
        /** This is the function for updating freight data (Freight Forwarding) */
        /** @author Elieza Kalaita */

        has_control_ajax('freight_update', 'Edit Freight Details');
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        //$data = inputAllGet();
        
        $data['fr_agent_reference_number'] = $this->input->post('fr_agent_reference_number');
        $data['fr_processing_office'] = $this->input->post('fr_processing_office');
        $data['fr_cargo_details'] = $this->input->post('fr_cargo_details');
        $data['fr_vessel'] = $this->input->post('fr_vessel');
        $data['fr_client'] = $this->input->post('fr_client');
        $data['fr_eta_etd'] = $this->input->post('fr_eta_etd');
        $data['fr_importer'] = $this->input->post('fr_importer');
        $data['fr_loading_port'] = $this->input->post('fr_loading_port');
        $data['fr_discharge_port'] = $this->input->post('fr_discharge_port');
        $data['fr_max_number'] = $this->input->post('fr_max_number');
        $data['fr_container_seal'] = $this->input->post('fr_container_seal');
        $data['fr_gross_measure'] = $this->input->post('fr_gross_measure');
        $data['fr_gross_weight'] = $this->input->post('fr_gross_weight');
        $data['fr_delivery_place'] = $this->input->post('fr_delivery_place');
        $data['fr_category_of_goods'] = $this->input->post('fr_category_of_goods');
        $data['fr_cl_plan'] = $this->input->post('fr_cl_plan');
        
        if (!empty($this->input->post('uploadedfiles'))) {
            $raw = explode('LM-55', $_POST['uploadedfiles']);
            foreach ($raw as $key => $file) {
                $file = unserialize($file);
                if (is_array($file)) {
                    foreach ($file as $dt) {
                        if (!empty($dt)) {
                            $data['fr_doc'] = $dt['doc_file'];
                        }
                    }
                }
            }
        }

        if($this->freightsModel->update($id,$data)){
            $res['message'] = 'Freight records successfully updated';
            $res['status'] = true;
        }else{
            $res['message'] = 'Failed to update freight records';
            $res['status'] = false;
        }

        echo json_encode($res, JSON_PRETTY_PRINT);
        exit();
    }
    //--------------End Freights-----------------//

    //-------------- Importers ------------------//
    function datasource_importers(){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->importersModel->find_all();
        $columns = array();
        foreach ($this->importersModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        //$columns['country_name'] = TRUE;
        //$columns['country_name'] = TRUE;
        print $this->datasourceLibrary->server($data,$columns);
    }
    function importer_details($num)
    {
        /** This is the function for loading consignee freights (Freight Forwarding) */
        /** @author Elieza Kalaita */

        $this->load->helper('form');
        $this->pagedata['title'] = 'Importer Details | '.$this->config->item('application_name');
        $this->pagedata['importer'] = $this->freightsModel->find_many_by(["fr_client" => $num]);
        $this->pagedata['users'] = profile($num);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/importer_details');

        //var_dump($this->pagedata['importer']);
        //echo json_encode($this->pagedata['importer'], JSON_PRETTY_PRINT);
       // exit();
    }
    function datasource_importer_freights($key, $when='')
    {
        /** This is the function for loading consignee freights data table (Freight Forwarding) */
        /** @author Elieza Kalaita */

        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->freightsModel->getFreight($key, $when);
        $columns = [
            'fr_id' => true,
            'fr_key' => true,
            'firstname' => true,
            'lastname' => true,
            'company_name' => true,
            'fr_cargo_details'=> true,
            'fr_vessel'=> true,
            'fr_eta_etd'=> true,
            'fr_doc'=> true,
            'inv_key'=> true,
            'fr_status'=> true,
            'fr_file_status'=> true,
        ];
        print $this->datasourceLibrary->server($data,$columns);
    }
    function datasource_importer_freights1($key)
    {
        /** This is the function for loading consignee freights data table (Freight Forwarding) */
        /** @author Elieza Kalaita */

        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));

        $data = $this->freightsModel->order_by('fr_created_on', 'DESC')->find_many_by(["fr_client" => $key]);
        $columns = array();
        foreach ($this->freightsModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($data,$columns);
    }
    function datasource_importer_freights_bin($key, $when='')
    {
        /** This is the function for loading deleted consignee freights data table (Freight Forwarding) */
        /** @author Elieza Kalaita */

        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->freightsModel->getFreightBin($key, $when);
        $columns = [
            'fr_id' => true,
            'fr_key' => true,
            'firstname' => true,
            'lastname' => true,
            'company_name' => true,
            'fr_cargo_details'=> true,
            'fr_vessel'=> true,
            'fr_eta_etd'=> true,
            'fr_doc'=> true,
            'fr_status'=> true,
            'inv_key'=> true,
            'fr_file_status'=> true,
        ];
        print $this->datasourceLibrary->server($data,$columns);
    }
    function datasource_importer_freights_bin1($key)
    {
        /** This is the function for loading deleted consignee freights data table (Freight Forwarding) */
        /** @author Elieza Kalaita */

        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));

        $this->freightsModel->where('fr_deleted', 1);
        $data = $this->freightsModel->with_deleted()->find_many_by(["fr_client" => $key]);

        $columns = array();
        foreach ($this->freightsModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($data,$columns);
    }
    //-------------- End Importers ------------------//

    //-------------- Exporters ------------------//
    function datasource_exporters(){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->exportersModel->find_all();
        $columns = array();
        foreach ($this->exportersModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($data,$columns);
    }
    function exporter_details($num)
    {
        $this->load->helper('form');
        $this->pagedata['title'] = 'Importer Details | '.$this->config->item('application_name');
        $this->pagedata['exporter'] = $this->freightsModel->find_many_by(["fr_exporter" => $num]);
        $this->pagedata['users'] = $this->exportersModel->find($num);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/exporter_details');

        //var_dump($this->pagedata['importer']);
        //echo json_encode($this->pagedata['importer'], JSON_PRETTY_PRINT);
       // exit();
    }
    function datasource_exporter_freights($key)
    {
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->freightsModel->find_many_by(["fr_exporter" => $key]);
        $columns = array();
        foreach ($this->freightsModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($data,$columns);
    }
    //-------------- End Exporters ------------------//

    //-------------- Documents ----------------------//
    function newDocumentation($key){
        /** This is the function for creating freight document (Freight Forwarding) */
        /** @author Elieza Kalaita */

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        $this->load->helper('form');

        $data['doc_fr_key'] = $key;
        $data['doc_name'] = $this->input->get('doc_name',TRUE);
        $data['doc_type'] = $this->input->get('doc_type',TRUE);
        $data['doc_description'] = $this->input->get('doc_description',TRUE);
        //$data['doc_file'] = $this->input->get('doc_file',TRUE);

        if (!empty($this->input->get('uploadedfiles'))) {
            $raw = explode('LM-55', $_GET['uploadedfiles']);
            foreach ($raw as $key => $file) {
                $file = unserialize($file);
                if (is_array($file)) {
                    foreach ($file as $dt) {
                        if (!empty($dt)) {
                            $data['doc_file'] = $dt['doc_file'];
                        }
                    }
                }
            }
        }
        $profile = profile();
        if($this->documentsModel->insert($data)){
            $results['message'] = 'Document added successfully';
            $results['status'] = true;

            /** Here we push notification to task assignee on his/her new task assignment */
            $data['role_action'] = "freight_view_all";
            $data['title'] = "New document attached";
            //$data['link']= base_url('task/mytask');
            $data['content'] = $profile->firstname." ".$profile->lastname." Attached ".$data['doc_name']." on file number ".$data['doc_fr_key'];
            $data['sender'] = $this->auth_user_id;
            $data['type'] = 'freight';
            $data['target'] = 'system';
            $data['receiver'] = 'system';
            $data['time'] = date("H:i:s");
            publishEventFlash('freight', $data);
        }else{
            $results['message'] = 'Failed to add document';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }
    function uploadfrdoc(){
        /** This is the function for uploading freight attachment (Freight Forwarding) */
        /** @author Elieza Kalaita */

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        $uploadPath = uploadPath('freight_docs/');
        $config['upload_path'] = $uploadPath;
        $config['file_ext_tolower']     = TRUE;
        $config['encrypt_name']         = TRUE;
        $config['allowed_types'] = 'jpg|jpeg|png|docx|doc|pdf|xls|xlsx|zip|txt';

        // Load and initialize upload library
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        $i  = 0;
        if($this->upload->do_upload('file')){
            // Uploaded file data
            $fileData = $this->upload->data();
            $uploadData[$i]['doc_file'] = $fileData['file_name'];
        }

        if(!empty($uploadData)){
            $files = array();
            $result['status'] = true;
            foreach ($uploadData as $key => $file){
                $files[$key]['doc_file'] = $file['doc_file'];
            }
            $result['files'] = serialize($files);
        }else{
            $result['status'] = false;
            $result['files'] = '';
        }

        echo json_encode($result, JSON_PRETTY_PRINT);
    }
    public function loadDocumentation($key) {
        $this->pagedata['title'] = "Documentation | ".$this->config->item('application_name');
        $this->load->helper('form');
        $this->pagedata['freight']= $this->freightsModel->find($key);
        //$this->pagedata['freight_doc']= $this->documentsModel->find_many_by(['doc_fr_key'=>$key]);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/documentation');
    }
    public function loadAssessment($key) {
        $this->pagedata['title'] = "Assessment | ".$this->config->item('application_name');
        $this->load->helper('form');
        $this->pagedata['freight']= $this->freightsModel->find($key);
        //$this->pagedata['freight_doc']= $this->documentsModel->find_many_by(['doc_fr_key'=>$key]);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/assessment');
    }
    public function loadImportPermit($key) {
        $this->pagedata['title'] = "Import Permit | ".$this->config->item('application_name');
        $this->load->helper('form');
        $this->pagedata['freight']= $this->freightsModel->find($key);
        //$this->pagedata['freight_doc']= $this->documentsModel->find_many_by(['doc_fr_key'=>$key]);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/import_permit');
    }
    public function loadPaymentDuty($key) {
        $this->pagedata['title'] = "Payment of Duty | ".$this->config->item('application_name');
        $this->load->helper('form');
        $this->pagedata['freight']= $this->freightsModel->find($key);
        //$this->pagedata['freight_doc']= $this->documentsModel->find_many_by(['doc_fr_key'=>$key]);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/payment_duty');
    }
    public function loadShippingLine($key) {
        $this->pagedata['title'] = "Shipping Line | ".$this->config->item('application_name');
        $this->load->helper('form');
        $this->pagedata['freight']= $this->freightsModel->find($key);
        //$this->pagedata['freight_doc']= $this->documentsModel->find_many_by(['doc_fr_key'=>$key]);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/shipping_line');
    }
    public function loadVerificationPhysical($key) {
        $this->pagedata['title'] = "Verification Physical | ".$this->config->item('application_name');
        $this->load->helper('form');
        $this->pagedata['freight']= $this->freightsModel->find($key);
        //$this->pagedata['freight_doc']= $this->documentsModel->find_many_by(['doc_fr_key'=>$key]);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/verification_physical');
    }
    public function loadPortCharges($key) {
        $this->pagedata['title'] = "Port Charges | ".$this->config->item('application_name');
        $this->load->helper('form');
        $this->pagedata['freight']= $this->freightsModel->find($key);
        //$this->pagedata['freight_doc']= $this->documentsModel->find_many_by(['doc_fr_key'=>$key]);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/port_charges');
    }
    public function loadReleaseContainer($key) {
        $this->pagedata['title'] = "Release Container | ".$this->config->item('application_name');
        $this->load->helper('form');
        $this->pagedata['freight']= $this->freightsModel->find($key);
        //$this->pagedata['freight_doc']= $this->documentsModel->find_many_by(['doc_fr_key'=>$key]);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/release_container');
    }
    public function loadDeliveryNote($key) {
        $this->pagedata['title'] = "Delivery Note | ".$this->config->item('application_name');
        $this->load->helper('form');
        $this->pagedata['freight']= $this->freightsModel->find($key);
        //$this->pagedata['freight_doc']= $this->documentsModel->find_many_by(['doc_fr_key'=>$key]);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/delivery_note');
    }
    public function loadDeliveryConsignee($key) {
        $this->pagedata['title'] = "Delivery at Consignee | ".$this->config->item('application_name');
        $this->load->helper('form');
        $this->pagedata['freight']= $this->freightsModel->find($key);
        //$this->pagedata['freight_doc']= $this->documentsModel->find_many_by(['doc_fr_key'=>$key]);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/delivery_consignee');
    }
    public function loadReturnContainer($key='') {
        $this->load->helper('form');
        $this->pagedata['freight']= $this->freightsModel->find($key);
        //$this->pagedata['freight_doc']= $this->documentsModel->find_many_by(['doc_fr_key'=>$key]);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/return_container');
    }
    public function loadReceivedInterchange($key) {
        $this->pagedata['title'] = "Received Interchange | ".$this->config->item('application_name');
        $this->load->helper('form');
        $this->pagedata['freight']= $this->freightsModel->find($key);
        //$this->pagedata['freight_doc']= $this->documentsModel->find_many_by(['doc_fr_key'=>$key]);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/received_interchange');
    }
    function deleteDocument($key='') {
        /** This is the function for deleting freight attachment (Freight Forwarding) */
        /** @author Elieza Kalaita */

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if($this->documentsModel->delete($key)){
            $results['message'] = 'Document deleted successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to delete document';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }
    //-------------- End Documents ------------------------//

    //-------------- Begin : Delivery Note ----------------//
    function create_delivery_note(){
        /** This is the function for creating freight delivery note (Freight Forwarding) */
        /** @author Elieza Kalaita */

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $data['delivery_note_bill_no'] = $this->input->post('delivery_note_bill_no', true);
        $data['delivery_note_truck_no'] = $this->input->post('delivery_note_truck_no', true);
        $data['delivery_note_trailer_no'] = $this->input->post('delivery_note_trailer_no', true);
        $data['delivery_note_driver_name'] = $this->input->post('delivery_note_driver_name', true);
        $data['delivery_note_driver_phone'] = $this->input->post('delivery_note_driver_phone', true);
        $data['delivery_note_driver_license'] = $this->input->post('delivery_note_driver_license', true);
        $data['delivery_note_comment'] = $this->input->post('delivery_note_comment', true);
        $data['delivery_note_fr_key'] = $this->input->post('delivery_note_fr_key', true);
        $data['delivery_note_doc'] = $this->input->post('delivery_note_doc', true);
        $data['delivery_note_sender_location'] = $this->input->post('delivery_note_sender_location', true);
        $data['delivery_note_consignee_location'] = $this->input->post('delivery_note_consignee_location', true);
        $data['delivery_note_truck_owner'] = $this->input->post('delivery_note_truck_owner', true);
        $data['delivery_note_trailer_owner'] = $this->input->post('delivery_note_trailer_owner', true);

        //var_dump($data);

        /**
        if (!empty($this->input->post('uploadedfiles'))) {
            $raw = explode('LM-55', $_POST['uploadedfiles']);
            foreach ($raw as $key => $file) {
                $file = unserialize($file);
                if (is_array($file)) {
                    foreach ($file as $dt) {
                        if (!empty($dt)) {
                            $data['delivery_note_doc'] = $dt['doc_file'];
                        }
                    }
                }
            }
        }
        **/

        if($this->deliveryNoteModel->insert($data)){
            $res['message'] = 'Delivery Note Successfully Created';
            $res['status'] = true;
        }else{
            $res['message'] = 'Failed to create delivery note';
            $res['status'] = false;
        }

        echo json_encode($res, JSON_PRETTY_PRINT);
        exit();
    }
    function modify_delivery_note(){
        /** This is the function for updating freight delivery note (Freight Forwarding) */
        /** @author Elieza Kalaita */

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $data['delivery_note_bill_no'] = $this->input->post('delivery_note_bill_no', true);
        $data['delivery_note_truck_no'] = $this->input->post('delivery_note_truck_no', true);
        $data['delivery_note_trailer_no'] = $this->input->post('delivery_note_trailer_no', true);
        $data['delivery_note_driver_name'] = $this->input->post('delivery_note_driver_name', true);
        $data['delivery_note_driver_phone'] = $this->input->post('delivery_note_driver_phone', true);
        $data['delivery_note_driver_license'] = $this->input->post('delivery_note_driver_license', true);
        $data['delivery_note_comment'] = $this->input->post('delivery_note_comment', true);
        //$data['delivery_note_fr_key'] = $this->input->post('delivery_note_fr_key', true);
        //$data['delivery_note_doc'] = $this->input->post('delivery_note_doc', true);
        $data['delivery_note_sender_location'] = $this->input->post('delivery_note_sender_location', true);
        $data['delivery_note_consignee_location'] = $this->input->post('delivery_note_consignee_location', true);
        $data['delivery_note_truck_owner'] = $this->input->post('delivery_note_truck_owner', true);
        $data['delivery_note_trailer_owner'] = $this->input->post('delivery_note_trailer_owner', true);

        $key = $this->input->post('delivery_note_key', true);
        //var_dump($data);

        /**
        if (!empty($this->input->post('uploadedfiles'))) {
            $raw = explode('LM-55', $_POST['uploadedfiles']);
            foreach ($raw as $key => $file) {
                $file = unserialize($file);
                if (is_array($file)) {
                    foreach ($file as $dt) {
                        if (!empty($dt)) {
                            $data['delivery_note_doc'] = $dt['doc_file'];
                        }
                    }
                }
            }
        }
        **/

        if($this->deliveryNoteModel->update($key, $data)){
            $res['message'] = 'Delivery Note Successfully Updated';
            $res['status'] = true;
        }else{
            $res['message'] = 'Failed to update delivery note';
            $res['status'] = false;
        }

        echo json_encode($res, JSON_PRETTY_PRINT);
        exit();
    }
    //-------------- End : Delivery Note ------------------//

    //-------------- Begin : Quotations -------------------//
    function create_quotation($key) {
        /** This is the function for creating freight quotation (Freight Forwarding) */
        /** @author Elieza Kalaita */

        $this->load->model(array('taxes/taxesModel' => 'taxesModel','accounting/accounting' => 'accountingModel'));
        if($this->tokens->match) {
            $this->db->trans_start();
            $invoice = array(
                'quot_payer' => $this->input->post('bms_client',TRUE),
                'quot_issued_date' => date('Y-m-d H:i:s', strtotime($this->input->post('quot_issued_date', TRUE))),
                'quot_status' => $this->input->post('quot_status',TRUE),
                'quot_total_before_tax' => to_dollar(toNumber($this->input->post('quot_sub_total', TRUE))),
                'quot_total_tax' => to_dollar(toNumber($this->input->post('quot_total_tax', TRUE))),
                'quot_total_after_tax' => to_dollar(toNumber($this->input->post('quot_total_after_tax', TRUE))),
                'quot_total_paid' => 0,
                'quot_total_balance' => to_dollar(toNumber($this->input->post('quot_total_after_tax', TRUE))),
                'quot_address' => $this->input->post('quot_address', TRUE),
                'quot_details' => $this->input->post('quot_details', TRUE),
                'freight_ref' => $this->input->post('freight_ref', TRUE),
            );
            $invoiceKey = $this->quotationsModel->insert($invoice);
            if(!empty($items = $this->input->post('group_items'))){
                foreach ($items as $item){
                    $itemData['quot_data_item_tax_inclusive'] = $item['quot_item_tax_inclusive'];
                    $itemData['quot_data_item'] = $item['quot_item'];
                    $itemData['quot_data_item_details'] = $item['quot_item_details'];
                    $itemData['quot_data_item_qty'] = $item['quot_item_qty'];
                    $itemData['quot_data_item_price'] = to_dollar(toNumber($item['quot_item_price']));
                    $itemData['quot_data_item_before_tax'] = to_dollar(toNumber($item['quot_item_before_tax']));
                    $itemData['quot_data_item_tax'] = $item['quot_item_tax'];
                    $itemData['quot_data_item_tax_percent'] = $item['quot_item_tax_percent'];
                    $itemData['quot_data_item_tax_value'] = to_dollar(toNumber($item['quot_item_tax_value']));
                    $itemData['quot_data_item_after_tax'] = to_dollar(toNumber($item['quot_item_after_tax']));
                    $itemData['quot_data_item_quotation'] = $invoiceKey;
                    $this->db->insert('quotation_data_items',$itemData);
                }
            }
            if(!empty($taxes = $this->input->post('taxes'))){
                foreach ($taxes as $item){
                    $taxData['quot_data_tax_tax'] = $item;
                    $taxData['quot_data_tax_value'] = $this->taxesModel->taxDetails($item)->tax_type_value;
                    $taxData['quot_data_tax_quotation'] = $invoiceKey ;
                    $this->db->insert('quotation_data_taxes',$taxData);
                }
            }
            $this->db->trans_complete();
            if ($this->db->trans_status() === TRUE) {
                $this->pagedata['form_action'] = TRUE;
                $this->pagedata['form_message'] = "Congratulation! Quotation created successfully";
                $this->pagedata['form_class'] = "success";
            } else {
                $this->pagedata['form_action'] = FALSE;
                $this->pagedata['form_message'] = "We could not process request successfully please try again later";
                $this->pagedata['form_class'] = "danger";
            }
        }

        $this->load->helper('form');
        $this->pagedata['link']= 'freight';
        $this->pagedata['title'] = "Create Quotation | ".$this->config->item('application_name');
        $this->pagedata['freight_key']= $key;
        $this->load->vars($this->pagedata);
        $this->load->view('freight/quotations/create');
    }
    function  datasource_quotation($key)
    {
        /** This is the function for loading freight quotation data table (Freight Forwarding) */
        /** @author Elieza Kalaita */

        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->quotationsModel->order_by('quot_created_on', 'DESC')->find_many_by(['freight_ref'=>$key]);
        $columns = array();
        foreach ($this->quotationsModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($data,$columns);
    }
    function  datasource_quotation_bin($key)
    {
        /** This is the function for loading freight deleted quotations data table (Freight Forwarding) */
        /** @author Elieza Kalaita */

        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $this->quotationsModel->where('quot_deleted',1);
        $data = $this->quotationsModel->order_by('quot_modified_on', 'DESC')->with_deleted()->find_many_by(['freight_ref'=>$key]);
        $columns = array();
        foreach ($this->quotationsModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($data,$columns);
    }
    function quot_to_freight($key=''){
        /** This is the function for linking quotation to freight (Freight Forwarding) */
        /** @author Elieza Kalaita */

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $data['freight_ref'] = $key;
        $quot_key = $this->input->post('quot_key', TRUE);

        //check if the provided file number is exist and file status is active on freights
        $find_freight = $this->freightsModel->find($key);

        if(empty($find_freight)){
            $results['message'] = 'Sorry, the provided file number doesn\'t exist, please try again!';
            $results['status'] = false;
        }
        else{
            if($find_freight['fr_file_status'] == 'Closed'){
                $results['message'] = 'Sorry, the file you are trying to link is already CLOSED!';
                $results['status'] = false;
            }
            else{
                //check if freight ref key is already exist
                $check_key = $this->quotationsModel->find_by(['quot_key'=>$quot_key, 'freight_ref'=>$key]);
                if(!empty($check_key)){
                    $results['message'] = 'This quotation is already linked to the provided file number!';
                    $results['status'] = false;
                }
                else{
                    if($this->quotationsModel->update($quot_key, $data)){
                        $results['message'] = 'Quot successfully linked';
                        $results['status'] = true;
                    }else{
                        $results['message'] = 'Failed to link quot';
                        $results['status'] = false;
                    }
                }
            }
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }
    //-------------- End : Quotations ---------------------//

    //-------------- Begin : Invoices ---------------------//
    function create_invoice($key) {
        /** This is the function for creating freight invoice (Freight Forwarding) */
        /** @author Elieza Kalaita */

        $this->load->model(array('taxes/taxesModel' => 'taxesModel','accounting/Accounting' => 'accountingModel'));
        if($this->tokens->match) {
            $this->db->trans_start();
            $invoice = array(
                'inv_payer' => $this->input->post('bms_client',TRUE),
                'inv_issued_date' => date('Y-m-d H:i:s', strtotime($this->input->post('inv_issued_date', TRUE))),
                'inv_expiring_date' => date('Y-m-d H:i:s', strtotime($this->input->post('inv_expiring_date', TRUE))),
                'inv_status' => $this->input->post('inv_status',TRUE),
                'inv_total_after_tax' => to_dollar(toNumber($this->input->post('inv_total_after_tax', TRUE))),
                'inv_total_before_tax' => to_dollar(toNumber($this->input->post('inv_sub_total', TRUE))),
                'inv_total_tax' => to_dollar(toNumber($this->input->post('inv_total_tax', TRUE))),
                'inv_total_balance' => to_dollar(toNumber($this->input->post('inv_total_after_tax', TRUE))),
                'inv_total_paid' => 0,
                'inv_address' => $this->input->post('inv_address', TRUE),
                'inv_details' => $this->input->post('inv_details', TRUE),
                'inv_credit_account' => $this->input->post('inv_receivable_account', TRUE),
                'inv_debit_account' => $this->input->post('inv_revenue_account', TRUE),
                'freight_ref' => $this->input->post('freight_ref', TRUE),
            );
            $invoiceKey = $this->invoicesModel->insert($invoice);

            if(!empty($items = $this->input->post('group_items'))){
                foreach ($items as $item){
                    $itemData['inv_data_item_tax_inclusive'] = $item['inv_item_tax_inclusive'];
                    $itemData['inv_data_item'] = $item['inv_item'];
                    $itemData['inv_data_item_details'] = $item['inv_item_details'];
                    $itemData['inv_data_item_qty'] = $item['inv_item_qty'];
                    $itemData['inv_data_item_price'] = to_dollar(toNumber($item['inv_item_price']));
                    $itemData['inv_data_item_before_tax'] = to_dollar(toNumber($item['inv_item_before_tax']));
                    $itemData['inv_data_item_tax'] = $item['inv_item_tax'];
                    $itemData['inv_data_item_tax_percent'] = $item['inv_item_tax_percent'];
                    $itemData['inv_data_item_tax_value'] = to_dollar(toNumber($item['inv_item_tax_value']));
                    $itemData['inv_data_item_after_tax'] = to_dollar(toNumber($item['inv_item_after_tax']));
                    $itemData['inv_data_item_invoice'] = $invoiceKey;
                    $this->db->insert('invoice_data_items',$itemData);
                }
            }
            if(!empty($taxes = $this->input->post('taxes'))){
                foreach ($taxes as $item){
                    $taxData['inv_data_tax_tax'] = $item;
                    $taxData['inv_data_tax_value'] = $this->taxesModel->taxDetails($item)->tax_type_value;
                    $taxData['inv_data_tax_invoice'] = $invoiceKey ;
                    $this->db->insert('invoice_data_taxes',$taxData);
                }
            }

            $freight_key = $this->input->post('freight_ref', TRUE);
            $freight['fr_status'] = 'Approved';
            $this->freightsModel->update_by(['fr_key'=>$freight_key], $freight);

            $this->db->trans_complete();
            if ($this->db->trans_status() === TRUE) {
                $this->pagedata['form_action'] = TRUE;
                $this->pagedata['form_message'] = "Congratulation! Invoice created successfully";
                $this->pagedata['form_class'] = "success";
            } else {
                $this->pagedata['form_action'] = FALSE;
                $this->pagedata['form_message'] = "We could not process request successfully please try again later";
                $this->pagedata['form_class'] = "danger";
            }
        }

        $this->load->helper('form');
        $this->pagedata['title'] = "Create Invoice | ".$this->config->item('application_name');
        $this->pagedata['link']= 'freight';
        $this->pagedata['freight_key']= $key;
        $this->pagedata['invoice'] = $this->invoicesModel->find_by(['freight_ref'=>$key]);
        $this->pagedata['items']= $this->generalLedgerModel->get_file($key);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/invoices/generate');
    }
    function  datasource_invoice($key)
    {
        /** This is the function for loading freight invoice data table (Freight Forwarding) */
        /** @author Elieza Kalaita */

        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->invoicesModel->order_by('inv_created_on', 'DESC')->find_many_by(['freight_ref'=>$key,'inv_deleted'=>0]);
        $columns = array();
        foreach ($this->invoicesModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($data,$columns);
    }
    function  datasource_invoice_bin($key){
        /** This is the function for loading deleted freight invoice data table (Freight Forwarding) */
        /** @author Elieza Kalaita */

        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $this->invoicesModel->where('inv_deleted',1);
        $data = $this->invoicesModel->order_by('inv_modified_on','DESC')->with_deleted()->find_many_by(['freight_ref'=>$key]);
        $columns = array();
        foreach ($this->invoicesModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($data,$columns);
    }
    function inv_to_freight($key=''){
        /** This is the function for linking invoice to freight (Freight Forwarding) */
        /** @author Elieza Kalaita */

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $data['freight_ref'] = $key;
        $inv_key = $this->input->post('inv_key', TRUE);

        //check if the provided file number is exist and file status is active on freights
        $find_freight = $this->freightsModel->find($key);

        if(empty($find_freight)){
            $results['message'] = 'Sorry, the provided file number doesn\'t exist, please try again!';
            $results['status'] = false;
        }
        else{
            if($find_freight['fr_file_status'] == 'Closed'){
                $results['message'] = 'Sorry, the file you are trying to link is already CLOSED!';
                $results['status'] = false;
            }
            else{
                //check if freight ref key is already exist
                $check_key = $this->invoicesModel->find_by(['inv_key'=>$inv_key, 'freight_ref'=>$key]);
                if(!empty($check_key)){
                    $results['message'] = 'This invoice is already linked to the provided file number!';
                    $results['status'] = false;
                }
                else{
                    if($this->invoicesModel->update($inv_key, $data)){
                        $results['message'] = 'Invoice successfully linked';
                        $results['status'] = true;
                    }else{
                        $results['message'] = 'Failed to link invoice';
                        $results['status'] = false;
                    }
                }
            }
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }
    //-------------- End : Invoices ----------------------//


    //---------------------Begin : Freight Tasks ---------//
    public function loadTaskFreight($key) {
        $this->pagedata['title'] = "Freight Assign Task | ".$this->config->item('application_name');
        $this->load->helper('form');
        $this->pagedata['freight']= $this->freightsModel->find($key);
        $this->pagedata['freights']= $this->freightsModel->freight_task($key);
        $this->pagedata['employees'] = $this->freightsModel->employees();
        $this->load->vars($this->pagedata);
        $this->load->view('freight/freight_task');
    }
    function datasourceFreightTask($key=''){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->freightsModel->freight_task($key);
        $columns = [
            'freight_task_id' => true,
            'freight_task_key' => true,
            'firstname' => true,
            'lastname' => true,
            'freight_task_employee_key' => true,
            'freight_task_freight_key' => true,
            'freight_task_start' => true,
            'freight_task_payment' => true,
            'freight_task_deadline' => true,
            'freight_task_desc'=> true,
            'freight_task_status'=> true,
        ];
        print $this->datasourceLibrary->server($data,$columns);
    }
    function newFreightTask(){
        $task['freight_task_employee_key'] = $this->input->get('freight_task_employee_key',TRUE);
        $task['freight_task_freight_key'] = $this->input->get('freight_task_freight_key',TRUE);
        $task['freight_task_start'] = $this->input->get('freight_task_start',TRUE);
        $task['freight_task_deadline'] = $this->input->get('freight_task_deadline',TRUE);
        $task['freight_task_desc'] = $this->input->get('freight_task_desc',TRUE);
        $task['freight_task_client'] = $this->input->get('freight_task_client',TRUE);
        $task['freight_task_client_name'] = $this->input->get('freight_task_client_name',TRUE);
        $task['freight_task_date_created'] = date('Y-m-d');
        $task['freight_task_created_by'] = $this->auth_user_id;
        $profile = profile();
        if($this->freightsModel->createFreightTask($task)){
            $result['status'] = 'ok';
            $result['message'] = 'Freight task created successfully';

            /** Here we push notification to task assignee on his/her new task assignment */
            $data['role_action'] = "freight_view_all";
            $data['title'] = "New task from ".$profile->firstname." ".$profile->lastname;
            $data['link']= base_url('task/mytask');
            $data['content'] = "You have assigned a new task";
            $data['sender'] = $this->auth_user_id;
            $data['type'] = 'task';
            $data['target'] = 'system';
            $data['receiver'] = $task['freight_task_employee_key'];
            $data['time'] = date("H:i:s");
            publishEventFlash('task', $data);
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }
    function detailsFreightTask($task=''){
        $this->load->helper('form');
        $this->pagedata['taskdetails'] = $this->freightsModel->freightTaskMore($task);
        $this->load->vars($this->pagedata);
        $this->load->view('freight/detailsFreightTask');
    }
    function updateFreightTask($task=''){
        $this->load->helper('form');
        $this->pagedata['taskdetails'] = $this->freightsModel->freightTaskMore($task);
        $this->pagedata['employees'] = $this->freightsModel->employees();
        $this->load->vars($this->pagedata);
        $this->load->view('freight/updateFreightTask');
    }
    function modifyFreightTask($taskKey=''){
        $data['freight_task_client_name'] = $this->input->get('freight_task_client_name',TRUE);
        $data['freight_task_freight_key'] = $this->input->get('freight_task_freight_key',TRUE);
        $data['freight_task_employee_key'] = $this->input->get('freight_task_employee_key',TRUE);
        $data['freight_task_payment'] = $this->input->get('freight_task_payment',TRUE);
        $data['freight_task_start'] = $this->input->get('freight_task_start',TRUE);
        $data['freight_task_deadline'] = $this->input->get('freight_task_deadline',TRUE);
        $data['freight_task_desc'] = $this->input->get('freight_task_desc',TRUE);
        if($this->freightsModel->taskFreightUpdate($taskKey,$data)){
            $result['status'] = 'ok';
            $result['message'] = 'Task updated successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }
    public function deleteFreightTask($flag,$key) {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        switch ($flag) {
            case 'task':
                if($this->freightsModel->deleteFreightTask($key)){
                    $result['status'] = 'ok';
                    $result['message'] = 'Task deleted';
                }else{
                    $result['status'] = 'no';
                    $result['message'] = checkError($this->dbexeption());
                }
                print json_encode($result);
                break;
            default:
                $result['status'] = 'no';
                $result['message'] = 'No action';
                print json_encode($result);
                break;
        }
    }
    //---------------------End : Freight Tasks ---------//

    /** Backup database **/
    public function db_backup()
    {
        $this->load->helper('file');
        $this->load->helper('download');
        $this->load->library('zip');
        $this->load->dbutil();

        $database = $this->db->database;
        $db_format = array('format'=>'zip','filename'=>$database.'.sql');
        $backup = $this->dbutil->backup($db_format);
        $dbname = 'freight-backup-on-'.date('Y-m-d\TH:i:s').'.zip';
        $path = backupPath($dbname);
        write_file($path,$backup);
        force_download($dbname,$backup);

        $data['success'] = "Backup successfully completed";
        $this->load->view('dashboard',$data);
    }
}