<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Dashboard
 *
 * @author test
 */
class Index extends MY_Controller{

    public  $appdata;

    public function __construct() {
        parent::__construct();

        $this->require_min_level(1);
        $this->load->helper('expenses/helper');
        $this->appdata['title']= 'Expense Manager';
        $this->load->model(array(
            'expenses/ExpensesModel'=>'expensesModel',
            'expenses/ExpensesCategoriesModel'=>'expensesCategoriesModel',
            'expenses/ExpensesTypesModel'=>'expensesTypesModel'            
        ));
    } 

    public function index() {
        $this->load->helper('form');
        $this->load->vars($this->appdata);
        $this->load->view('expenses/types/overview');
    }

    public function details($type ='') {
        $this->appdata['type'] = $this->expensesTypesModel->details($type);
        $this->load->helper('form');
        $this->load->vars($this->appdata);
        $this->load->view('expenses/types/details');
    }

    function save()
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        
        $data['type_title'] = $this->input->post('type_title',TRUE);
        $data['type_details'] = $this->input->post('type_details',TRUE);
        $data['type_status'] = $this->input->post('type_status',TRUE);
        $data['type_category'] = $this->input->post('type_category',TRUE);
        $key = $this->input->post('key',TRUE);

        $status = $this->expensesTypesModel->update($key,$data);

        if($status){
            $results['message'] = 'Changes applied successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to save changes';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function create()
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $data['type_title'] = $this->input->post('type_title',TRUE);
        $data['type_details'] = $this->input->post('type_details',TRUE);
        $data['type_status'] = $this->input->post('type_status',TRUE);
        $data['type_category'] = $this->input->post('type_category',TRUE);

        $status = $this->expensesTypesModel->insert($data);

        if($status){
            $results['message'] = 'Type created successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to create Type';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function delete($type)
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $status = $this->expensesTypesModel->delete($type);

        if($status){
            $results['message'] = 'Type deleted successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to delete type';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    public function expenditure($type ='') {
        $this->appdata['type'] = $this->expensesTypesModel->details($type);
        $this->load->vars($this->appdata);
        $this->load->view('expenses/types/expenditure');
    }

    function datasource(){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->expensesTypesModel->find_all();
        $columns = array();
        foreach ($this->expensesTypesModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($data,$columns);
    }

    function datasourceexpendicture($type='',$when=''){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $types = $this->expensesTypesModel->expendicture($type,$when);
        $columns = [
            'user' => true,
            'expense_date' => true,
            'category_title' => true,
            'type_title' => true,
            'expense_details' => true,
            'expense_payee' => true,
            'expense_paid' => true,
            'expense_status' => true,
            'expense_amount' => true,
            'account_id' => true,
            'expense_key' => true,
        ];
        print $this->datasourceLibrary->server($types,$columns);
    }

}
