<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Dashboard
 *
 * @author test
 */
class Index extends MY_Controller{

    public  $appdata;

    public function __construct() {
        parent::__construct();

        ( $this->require_min_level(1));
        $this->load->helper('expenses/helper');
        $this->appdata['title']= 'Expense Manager';
        $this->load->model(array(
            'expenses/ExpensesModel'=>'expensesModel',
            'expenses/ExpensesBudgetsModel'=>'expensesBudgetsModel'
        ));
    }

    public function index() {
        if(!empty($this->input->get('remove')) && !empty($this->input->get('cat'))){
            if($this->expensesModel->removeBudget($this->input->get('cat'))){
                $this->appdata['msg'] = 'Budget removed successfully';
            }else{
                $this->appdata['msg'] = 'Could not remove budget';
            }
        }

        if($this->tokens->match){
            $data['budget_value'] = str_ireplace(',','',$this->input->post('budget_value',TRUE));
            $data['budget_title'] = $this->input->post('budget_title',TRUE);
            if($this->expensesModel->createBudget($data)){
                $this->appdata['msg'] = 'Budget created successfully';
            }else{
                $this->appdata['msg'] = 'Could not create budget';
            }
        }

        $this->load->helper('form');
        $this->load->vars($this->appdata);
        $this->load->view('expenses/budgets/overview');
    }

    function showbalance($password='',$budget=''){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if (empty($password)) {
            $results['status'] = false;
            $results['message'] = 'You must provide password';
            echo json_encode($results, JSON_PRETTY_PRINT);
            return;
        }

        if (!checkAccessPassword($password)) {
            $results['status'] = false;
            $results['message'] = 'You provided wrong password';
            echo json_encode($results, JSON_PRETTY_PRINT);
            return;
        }

        $balance = $this->expensesBudgetsModel->getBalance($budget);
        $results['status'] = true;
        $results['message'] = "<h1>Balance is <b>".number_format(to_money($balance),2).'</b></h1>';
        echo json_encode($results, JSON_PRETTY_PRINT);

    }

    function showtotalexpenditure($password='',$budget=''){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if (empty($password)) {
            $results['status'] = false;
            $results['message'] = 'You must provide password';
            echo json_encode($results, JSON_PRETTY_PRINT);
            return;
        }
 
        if (!checkAccessPassword($password)) {
            $results['status'] = false;
            $results['message'] = 'You provided wrong password';
            echo json_encode($results, JSON_PRETTY_PRINT);
            return;
        }

        $results['status'] = true;
        $results['message'] = "<h1>Total Expenditure is <b>".number_format(to_money($this->expensesBudgetsModel->getTotalExpenditure($budget)),2).'</b></h1>';
        echo json_encode($results, JSON_PRETTY_PRINT);

    }

    public function details($budget ='') {
        $this->appdata['budget'] = $this->expensesBudgetsModel->details($budget);
        $this->load->helper('form');
        $this->load->vars($this->appdata);
        $this->load->view('expenses/budgets/details');
    }

    public function transactions($budget ='') {
        $this->appdata['budget'] = $this->expensesBudgetsModel->details($budget);
        $this->load->vars($this->appdata);
        $this->load->view('expenses/budgets/transactions');
    }

    public function expenditure($budget ='') {
        $this->appdata['budget'] = $this->expensesBudgetsModel->details($budget);
        $this->load->vars($this->appdata);
        $this->load->view('expenses/budgets/expenditure');
    }

    public function deposits($budget ='') {
        $this->appdata['budget'] = $this->expensesBudgetsModel->details($budget);
        $this->load->helper('form');
        $this->load->vars($this->appdata);
        $this->load->view('expenses/budgets/deposits');
    }

    public function withdraws($budget ='') {
        $this->appdata['budget'] = $this->expensesBudgetsModel->details($budget);
        $this->load->helper('form');
        $this->load->vars($this->appdata);
        $this->load->view('expenses/budgets/withdraws');
    }

    function create() {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $data['budget_title'] = $this->input->post('budget_title',TRUE);
        $data['budget_details'] = $this->input->post('budget_details',TRUE);
        $data['budget_status'] = $this->input->post('budget_status',TRUE);
        $data['budget_date'] = date('Y-m-d');
        if($this->expensesBudgetsModel->insert($data)){
            $results['message'] = 'Budget added successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to add budget';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function datasource(){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->expensesBudgetsModel->find_all(0);
        $columns = array();
        foreach ($this->expensesBudgetsModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }

        print $this->datasourceLibrary->server($data,$columns);
    }

    function datasourcebin(){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->expensesBudgetsModel->with_deleted()->find_all(1);
        $columns = array();

        foreach ($this->expensesBudgetsModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }

        print $this->datasourceLibrary->server($data);

    }

    function delete_budget($key=''){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        if($this->expensesBudgetsModel->delete($key)){
            $results['message'] = 'Budget deleted successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to delete Budget';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }

    function restore_budget($key=''){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if($this->expensesBudgetsModel->update($key,['budget_deleted' => 0])){
            $results['message'] = 'Budget restored successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to restore Budget';
            $results['status'] = false;
        }
        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }

    function datasourcedeposits($budget=''){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $budgets = $this->expensesBudgetsModel->deposits($budget);
        $columns = array();
        foreach ($this->expensesBudgetsModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($budgets,$columns);
    }

    function save($key='') {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        $data['budget_title'] = $this->input->post('budget_title',TRUE);
        $data['budget_details'] = $this->input->post('budget_details',TRUE);
        $data['budget_status'] = $this->input->post('budget_status',TRUE);
        if($this->expensesBudgetsModel->update($key,$data)){
            $results['message'] = 'Changes applied successfully';
            $results['status'] = true;

        }else{
            $results['message'] = 'Failed to save changes';
            $results['status'] = false;
        }
        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function makewithdraw() {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $data['bg_withdraw'] = to_dollar(str_ireplace(",","",$this->input->post('amount',TRUE)));
        $data['bg_date'] = date("Y-m-d",strtotime($this->input->post('date',TRUE)));
        $data['bg_budget'] = $this->input->post('key',TRUE);
        $data['bg_user'] = $this->auth_user_id;
        $this->db->insert('expense_budget_transactions',$data);
        //$this->expensesBudgetsModel->insert($data)

        if($this->db->affected_rows()>0){
            $results['message'] = 'Withdraw successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to Withdraw';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function makedeposit() {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $data['bg_deposit'] = to_dollar(str_ireplace(",","",$this->input->post('amount',TRUE)));
        $data['bg_date'] = date("Y-m-d",strtotime($this->input->post('date',TRUE)));
        $data['bg_budget'] = $this->input->post('key',TRUE);
        $data['bg_user'] = $this->auth_user_id;
        $this->db->insert('expense_budget_transactions',$data);
        //$this->expensesBudgetsModel->insert($data)

        if($this->db->affected_rows()>0){
            $results['message'] = 'Deposit successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to Deposit';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function datasourcetransactions($budget=''){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $budgets = $this->expensesBudgetsModel->transactions($budget);
        $columns = array();
        foreach ($this->expensesBudgetsModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($budgets,$columns);
    }

    function datasourceexpendicture1($budget='',$when=''){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $budgets = $this->expensesBudgetsModel->expendicture($budget,$when);
        $columns = [
            'expense_created_by' => true,
            'expense_date' => true,
            'expense_details' => true,
            'expense_payee' => true,
            'expense_amount' => true,
        ];
        print $this->datasourceLibrary->server($budgets,$columns);
    }

    function datasourceexpendicture($budget=''){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $budgets = $this->expensesBudgetsModel->expendicture($budget);
        $columns = array();
        foreach ($this->expensesBudgetsModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($budgets,$columns);
    }

    function datasourcewithdraws($budget=''){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $budgets = $this->expensesBudgetsModel->withdraws($budget);
        $columns = array();
        foreach ($this->expensesBudgetsModel->selectable_fields2 as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($budgets,$columns);
    }


}