<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of Dashboard
 *
 * @author test
 */
class Expenses extends MY_Controller{

  public $pagedata;

  public function __construct() {
    parent::__construct();
    ($this->require_min_level(1));
    $this->pagedata['link']= 'expenses';
  }

  public function index() {
    $this->load->helper('form');
    $this->pagedata['employees'] = $this->employeesModel->employees();
    $this->pagedata['title'] = 'Expense Types | '.$this->config->item('application_name');
    $this->load->vars($this->pagedata);
    $this->load->view('expenses/expenses.php');
  }

  function expenseDetails($expense=''){
    $this->load->view('expenses/expenseDetails', ['expense' => $this->expensesModel->expenseDetails($expense)]);
  }

  function expenseModify($expense=''){
    $this->load->view('expenses/expenseModify', ['expense' => $this->expensesModel->expenseDetails($expense)]);
  }

  public function expenseModifyAction($expenseKey=''){

     if (!$this->input->is_ajax_request())
     exit('not direct script allowed');

       $expense['expense_type_type'] = $this->input->get('expense_type_type', TRUE);
       $expense['expense_credit_account'] = $this->input->get('expense_credit_account', TRUE);
       $expense['expense_amount'] = to_dollar(str_replace(',','',$this->input->get('expense_amount', TRUE)));
       $expense['expense_payee'] = $this->input->get('expense_payee', TRUE);
       $expense['expense_details'] = $this->input->get('expense_details', TRUE);
       $expense['expense_modifier'] = config_item('auth_user_id');
       $expense['expense_creator'] = config_item('auth_user_id');
       $expense['expense_date'] = date('Y-m-d');
         if($this->expensesModel->updateExpense($expenseKey,$expense)){
           $result['status'] = 'ok';
           $result['message'] = 'An Expense updated successfull';
         }else{
           $result['status'] = 'no';
           $result['message'] = checkError();
         }
         print json_encode($result);
  }

  public function newexpense(){

    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');

       $expense['expense_type_type'] = $this->input->get('expense_type_type', TRUE);
       $expense['expense_credit_account'] = $this->input->get('expense_credit_account', TRUE);
       $expense['expense_amount'] = to_dollar(str_replace(',','',$this->input->get('expense_amount', TRUE)));
       $expense['expense_payee'] = $this->input->get('expense_payee', TRUE);
       $expense['expense_details'] = $this->input->get('expense_details', TRUE);
       $expense['expense_creator'] = config_item('auth_user_id');
       $expense['expense_date'] = date('Y-m-d');
         if($this->expensesModel->newExpense($expense)){
           $result['status'] = 'ok';
           $result['message'] = 'An Expense added successfull';
         }else{
           $result['status'] = 'no';
           $result['message'] = checkError();
         }
         print json_encode($result);
  }

  function searchexpense($search=''){
    $q = filter_var($search, FILTER_SANITIZE_STRING);
    if(!empty($q)){
      $store = $this->storesModel->store()->store_key;
      $this->db->or_like('expense_type',$q);
      $this->db->like('expense_payee',$q);
      $this->db->where('expense_store',$store);
      $this->db->join('expense_types','expense_types.expense_type_key='.'expenses.expense_type_type','left');
      $query = $this->db->get('expenses');
      if($query->num_rows()>0){
        $result = $query->result_array();
        foreach ($result as $key => $rlt) {
          if($key%2){
            $color = '#f5f5f5';
          }else{
            $color = '#fafafa';
          }
          ?>
          <style>
          a:hover {
            color: red;
            }
            /* selected link */
          a:active {
            color: yellow;
            }
          </style>
          <a onmouseout="this.style.background=this.dataset.color" data-color="<?php echo $color;?>" onmouseover="this.style.background = 'orange'" class="text-dark" style="padding:5px 10px; margin: 0px; width: 100%; clear:both; float: left; background:<?php echo $color;?>;" href="javascript:(0);"><?php echo $rlt['expense_type'];?></a>
        <?php }
      }else{
        print '<b><span style="padding:5px 10px; margin: 0px; width: 100%; clear:both; float: left;">No record fouund</span></b>';
      }
    }else{
      print '<b>No record to show</b>';
    }
  }

  public function delete($flag,$key) {
    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');
      switch ($flag) {
          case 'expense':
          if($this->expensesModel->deleteExpense($key)){
                    $result['status'] = 'ok';
                    $result['message'] = 'Expense Type deleted';
                  }else{
                    $result['status'] = 'no';
                    $result['message'] = checkError($this->dbexeption());
                  }
            print json_encode($result);
          break;
          default:
            $result['status'] = 'no';
            $result['message'] = 'No action';
             print json_encode($result);
          break;
      }
  }

  function datasource(){
  include dirname(APPPATH).'/resources/includes/lib/class-list-util.php';

  $data = $alldata = $this->expensesModel->expenses();

  $datatable = array_merge(['pagination' => [], 'sort' => [], 'query' => []], $_REQUEST);

  // search filter by keywords
  $filter = isset($datatable['query']['generalSearch']) && is_string($datatable['query']['generalSearch'])
    ? $datatable['query']['generalSearch'] : '';
  if ( ! empty($filter)) {
    $data = array_filter($data, function ($a) use ($filter) {
        return (boolean)preg_grep("/$filter/i", (array)$a);
    });
    unset($datatable['query']['generalSearch']);
  }

  // filter by field query
  $query = isset($datatable['query']) && is_array($datatable['query']) ? $datatable['query'] : null;
  if (is_array($query)) {
    $query = array_filter($query);
    foreach ($query as $key => $val) {
        $data = list_filter($data, [$key => $val]);
    }
  }

  $sort  = ! empty($datatable['sort']['sort']) ? $datatable['sort']['sort'] : 'asc';
  $field = ! empty($datatable['sort']['field']) ? $datatable['sort']['field'] : 'RecordID';

  $meta    = [];
  $page    = ! empty($datatable['pagination']['page']) ? (int)$datatable['pagination']['page'] : 1;
  $perpage = ! empty($datatable['pagination']['perpage']) ? (int)$datatable['pagination']['perpage'] : -1;

  $pages = 1;
  $total = count($data); // total items in array

  // sort
  usort($data, function ($a, $b) use ($sort, $field) {
    if ( ! isset($a->$field) || ! isset($b->$field)) {
        return false;
    }

    if ($sort === 'asc') {
        return $a->$field > $b->$field ? true : false;
    }

    return $a->$field < $b->$field ? true : false;
  });

  // $perpage 0; get all data
  if ($perpage > 0) {
    $pages  = ceil($total / $perpage); // calculate total pages
    $page   = max($page, 1); // get 1 page when $_REQUEST['page'] <= 0
    $page   = min($page, $pages); // get last page when $_REQUEST['page'] > $totalPages
    $offset = ($page - 1) * $perpage;
    if ($offset < 0) {
        $offset = 0;
    }

    $data = array_slice($data, $offset, $perpage, true);
  }

  $meta = [
    'page'    => $page,
    'pages'   => $pages,
    'perpage' => $perpage,
    'total'   => $total,
  ];

  // if selected all records enabled, provide all the ids
  if (isset($datatable['requestIds']) && filter_var($datatable['requestIds'], FILTER_VALIDATE_BOOLEAN)) {
    $meta['rowIds'] = array_map(function ($row) {
        foreach($row as $first) break;
        return $first;
    }, $alldata);
  }


  header('Content-Type: application/json');
  header('Access-Control-Allow-Origin: *');
  header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
  header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

  $result = [
    'meta' => $meta + [
            'sort'  => $sort,
            'field' => $field,
        ],
    'data' => $data,
  ];

  echo json_encode($result, JSON_PRETTY_PRINT);
  }
}