<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of Dashboard
 *
 * @author test
 */
class Departments extends MY_Controller{

  public $pagedata;
  public $store;
  public $business;

  public function __construct() {
    parent::__construct();
    ($this->require_min_level(1));
    $this->pagedata['link']= 'administration';
    $this->store = $this->storesModel->store()->store_key;
    $this->business = $this->businessModel->business(profile()->user_business)->business_key;
  }

  public function index() {
    $this->load->helper('form');
    $this->pagedata['title'] = 'Departments | '.$this->config->item('application_name');
    $this->load->vars($this->pagedata);
    $this->load->view('administration/employees/departments/departments');
  }

function details($department=''){
  $this->load->helper('form');
  $this->pagedata['department'] = $this->departmentsModel->department($department);
  $this->load->vars($this->pagedata);
  $this->load->view('administration/employees/departments/details');
}

function modify($department=''){
  $this->load->helper('form');
  $this->pagedata['department'] = $this->departmentsModel->department($department);
  $this->load->vars($this->pagedata);
  $this->load->view('administration/employees/departments/detailsModify');
}

function update($departmentKey=''){
  $department['department_name'] = $this->input->get('department_name',TRUE);
  $department['department_details'] = $this->input->get('department_details',TRUE);
  if($this->departmentsModel->departmentUpdate($departmentKey,$department)){
            $result['status'] = 'ok';
            $result['message'] = 'Department updated successifully';
          }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
          }
 print json_encode($result);
}

function newDepartment(){
    $department['department_name'] = $this->input->get('department_name',TRUE);
    $department['department_details'] = $this->input->get('details_name',TRUE);
    if($this->departmentsModel->departmentRegister($department)){
              $result['status'] = 'ok';
              $result['message'] = 'Department registered successifully';
            }else{
              $result['status'] = 'no';
              $result['message'] = checkError($this->dbexeption());
            }
   print json_encode($result);
  }


  public function delete($flag,$key) {
    // if (!$this->input->is_ajax_request())
    //  exit('not direct script allowed');
      switch ($flag) {
          case 'department':
          if($this->departmentsModel->deleteDepartment($key)){
                    $result['status'] = 'ok';
                    $result['message'] = 'Department deleted';
                  }else{
                    $result['status'] = 'no';
                    $result['message'] = checkError($this->dbexeption());
                  }
            print json_encode($result);
          break;
          default:
            $result['status'] = 'no';
            $result['message'] = 'No action';
             print json_encode($result);
          break;
      }
  }

function datasource(){
include dirname(APPPATH).'/resources/includes/lib/class-list-util.php';

$data = $alldata = $this->departmentsModel->departments();

$datatable = array_merge(['pagination' => [], 'sort' => [], 'query' => []], $_REQUEST);

// search filter by keywords
$filter = isset($datatable['query']['generalSearch']) && is_string($datatable['query']['generalSearch'])
  ? $datatable['query']['generalSearch'] : '';
if ( ! empty($filter)) {
  $data = array_filter($data, function ($a) use ($filter) {
      return (boolean)preg_grep("/$filter/i", (array)$a);
  });
  unset($datatable['query']['generalSearch']);
}

// filter by field query
$query = isset($datatable['query']) && is_array($datatable['query']) ? $datatable['query'] : null;
if (is_array($query)) {
  $query = array_filter($query);
  foreach ($query as $key => $val) {
      $data = list_filter($data, [$key => $val]);
  }
}

$sort  = ! empty($datatable['sort']['sort']) ? $datatable['sort']['sort'] : 'asc';
$field = ! empty($datatable['sort']['field']) ? $datatable['sort']['field'] : 'RecordID';

$meta    = [];
$page    = ! empty($datatable['pagination']['page']) ? (int)$datatable['pagination']['page'] : 1;
$perpage = ! empty($datatable['pagination']['perpage']) ? (int)$datatable['pagination']['perpage'] : -1;

$pages = 1;
$total = count($data); // total items in array

// sort
usort($data, function ($a, $b) use ($sort, $field) {
  if ( ! isset($a->$field) || ! isset($b->$field)) {
      return false;
  }

  if ($sort === 'asc') {
      return $a->$field > $b->$field ? true : false;
  }

  return $a->$field < $b->$field ? true : false;
});

// $perpage 0; get all data
if ($perpage > 0) {
  $pages  = ceil($total / $perpage); // calculate total pages
  $page   = max($page, 1); // get 1 page when $_REQUEST['page'] <= 0
  $page   = min($page, $pages); // get last page when $_REQUEST['page'] > $totalPages
  $offset = ($page - 1) * $perpage;
  if ($offset < 0) {
      $offset = 0;
  }

  $data = array_slice($data, $offset, $perpage, true);
}

$meta = [
  'page'    => $page,
  'pages'   => $pages,
  'perpage' => $perpage,
  'total'   => $total,
];

// if selected all records enabled, provide all the ids
if (isset($datatable['requestIds']) && filter_var($datatable['requestIds'], FILTER_VALIDATE_BOOLEAN)) {
  $meta['rowIds'] = array_map(function ($row) {
      foreach($row as $first) break;
      return $first;
  }, $alldata);
}

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

$result = [
  'meta' => $meta + [
          'sort'  => $sort,
          'field' => $field,
      ],
  'data' => $data,
];

echo json_encode($result, JSON_PRETTY_PRINT);
}

}