<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of Dashboard
 *
 * @author test
 */
class Category extends MY_Controller{

  public function __construct() {
    parent::__construct();
    ($this->require_min_level(1));
    $this->load->helper('crm/crm_helper');
    $this->pagedata['link']= 'administration';
      $this->load->model(array(
          'crm/customersModel' => 'customersModel',
          'crm/groupsModel' => 'groupsModel'
      ));
  }

  public function index() {
    $this->load->helper('form');
    $this->pagedata['title'] = 'Groups | '.$this->config->item('application_name');
    $this->load->vars($this->pagedata);
    $this->load->view('crm/customers/category/category');
  }

function details($group=''){
  $this->load->helper('form');
  $this->pagedata['group'] = $this->groupsModel->group($group);
  $this->load->vars($this->pagedata);
  $this->load->view('crm/customers/category/details');
}

function modify($group=''){
  $this->load->helper('form');
  $this->pagedata['group'] = $this->groupsModel->group($group);
  $this->load->vars($this->pagedata);
  $this->load->view('crm/customers/category/detailsModify');
}

function update($groupKey=''){
  $group['group_name'] = $this->input->get('group_name',TRUE);
  $group['group_details'] = $this->input->get('group_details',TRUE);
  $group['group_branch'] = $this->input->get('group_branch',TRUE);
  if($this->groupsModel->groupUpdate($groupKey,$group)){
            $result['status'] = 'ok';
            $result['message'] = 'Group updated successifully';
          }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
          }
 print json_encode($result);
}

function newGroup(){
    $group['group_name'] = $this->input->get('group_name',TRUE);
    $group['group_details'] = $this->input->get('group_details',TRUE);
    if($this->groupsModel->groupRegister($group)){
              $result['status'] = 'ok';
              $result['message'] = 'Group registered successifully';
            }else{
              $result['status'] = 'no';
              $result['message'] = checkError($this->dbexeption());
            }
   print json_encode($result);
  }

  function deleteselected(){
    $rawids = $this->input->get('data');
    if(!empty($rawids)){
      $this->db->trans_start();
      foreach ($rawids as $y => $row) {
        $this->groupsModel->deleteGroup($row);
      }

      $this->db->trans_complete();
      if($this->db->trans_status() == TRUE){
        $result['status'] = 'ok';
        $result['message'] = 'Congratulations! You have successifully Deleted Group(S)';
        $result['type'] = 'success';
      }else{
        $result['status'] = 'no';
        $result['message'] = 'Unfortunatelly, You request could not be completed';
        $result['type'] = 'warning';
      }
    }else{
      $result['status'] = 'no';
      $result['message'] = 'Please select Group(s) to delete';
      $result['type'] = 'warning';
    }
    echo json_encode( $result);
  }

  public function delete($flag,$key) {
    if (!$this->input->is_ajax_request())
     exit('not direct script allowed');
      switch ($flag) {
          case 'group':
          if($this->groupsModel->deleteGroup($key)){
                    $result['status'] = 'ok';
                    $result['message'] = 'Group deleted';
                  }else{
                    $result['status'] = 'no';
                    $result['message'] = checkError($this->dbexeption());
                  }
            print json_encode($result);
          break;
          default:
            $result['status'] = 'no';
            $result['message'] = 'No action';
             print json_encode($result);
          break;
      }
  }

  function datasource(){
    $data =  $this->groupsModel->groups();
    $columnsDefault = [
      'group_key'     => true,
      'group_name'     => true,
      'group_details'  => true,
      'group_created'     => true,
    ];
    $this->sourcedataserver($data,$columnsDefault);
  }

}