<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of Dashboard
 *
 * @author test
 */
class Index extends MY_Controller{

  public $pagedata;
  public $branch;
  public $business;

  public function __construct() {
    parent::__construct();
    ($this->require_min_level(1));
    $this->pagedata['link']= 'customers';
    $this->load->model(array(
            'communication/communicationsModel' => 'communicationsModel',
            'crm/customersModel' => 'customersModel',
             'bms/branchesModel' => 'branchesModel',
            'crm/groupsModel' => 'groupsModel'
            ));
    $this->load->helper('crm/crm_helper');
     $this->load->library(array('AppLibrary'=>'appLibrary'));
    $this->load->model(array('hrm/TitlesModel'=>'titlesModel'));
    $this->load->model('documents/documentsModel');
  }

  public function index() {
    has_control('customers_view_all','View all customers');
    $this->pagedata['customers'] = $this->customersModel->customers();
    $this->pagedata['title'] = 'Communication Email | '.$this->config->item('application_name');
    $this->load->vars($this->pagedata);
    $this->load->view('communication/email/emails');
  }

  public function modifyCostomer($customerKey='') {
        $this->pagedata['customer'] = $this->communicationsModel->customer_modify($customerKey);
        $this->load->vars($this->pagedata);
        $this->load->view('communication/email/edit');
  }

    function sendEmail($customerKey=''){
        $this->load->helper('form');
        $param['recepient'] = $this->input->get('email', true);
        $param['subject'] = $this->input->get('subject', true);
        $param['message'] = $this->input->get('message', true);

        if($this->appLibrary->send_email($param,$customerKey)){
            $results['message'] = 'Email sent successfully';
            $results['status'] = 'true';
        }else{
            $results['message'] = 'Email not sent';
            $results['status'] = 'false';
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

}