<?php


class SentList extends MY_Controller
{
    public  $appdata;

    function __construct() {
        parent::__construct();

        $this->require_min_level(1);
        $this->appdata['title']= 'Sent';
        $this->load->model(array(
            'taxes/TaxesModel'=>'taxesModel',
            'communication/SentList_model' =>'sentList_model',
            'communication/ViewInbox_model' =>'viewInbox_model',
        ));

        $this->load->vars($this->appdata);
        $this->load->helper('taxes/helper');
        $this->load->helper('form');
        $this->appdata['link']= 'communication';
        $this->load->library("pagination");
        $this->load->helper('url');
    }

    function index() {
        $email = profile()->email;
        $this->appdata['link']= 'communication';

        //for pagination
        $config = array();
        $config["base_url"] = base_url() . "sent";
        $config["total_rows"] = $this->sentList_model->countSent($email);
        $config["per_page"] = 10;
        $config["uri_segment"] = 2;

        $this->pagination->initialize($config);

        $page = ($this->uri->segment(2)) ? $this->uri->segment(2) : 0;

        $data["links"] = $this->pagination->create_links();

        //$data['authors'] = $this->authors_model->get_authors($config["per_page"], $page);
        $data['msg'] = $this->sentList_model->get_msg($config["per_page"], $page);
        $this->load->view('communication/sent', $data);

//        $query= $this->sentList_model->getSentList($email);
//        //$result['data'] = null;
//        if(!empty($query)){
//            $result['data'] =  $query;
//            $this->load->view('communication/sent', $result);
//        }
//        else
//        {
//            $this->load->view('communication/sent');
//        }



    }

    function viewSent($msg_id = NULL)
    {
        $query = $this->sentList_model->getMsg($msg_id);
        //$this->appdata['data']= $this->sentList_model->getMsg($msg_id);
        $this->appdata['title']= 'View Message';
        $this->appdata['link']= 'communication';
        $this->load->vars($this->appdata);
        if (!empty($query))
        {
            $result['data'] = $query;
            $this->load->view('communication/viewsent', $result);
        }
        else
        {
            show_404();
        }
    }
}