<?php
/**
compose msg
 */

class Send extends MY_Controller
{
    public  $appdata;

    function __construct()
    {
        parent::__construct();

        $this->require_min_level(1);
        $this->appdata['title']= 'Inbox';
        $this->load->model('communication/Sendmsg_model');
        $this->load->helper('taxes/helper');
        $this->appdata['link']= 'communication';
        $this->load->library('form_validation');
        $this->load->helper('form');
    }

    function index() {
        $this->load->helper('form');
        $this->appdata['link']= 'communication';
        $this->load->vars($this->appdata);
        $this->load->view('communication/taxes');
    }

    function sendMsg()
    {
        $this->form_validation->set_rules('compose_to', 'Receipient Address', 'required|valid_email');
        $this->form_validation->set_rules('compose_subject', 'Subject', 'required|trim');
        $this->form_validation->set_rules('compose_msg', 'Message', 'required|trim');

        if($this->form_validation->run()) {
            // Create a random user id between 1200 and 4294967295
            $key = 2147483648 + mt_rand(-2147482448, 2147483647);
            if ($this->input->post('compose_to') != profile()->email) {
                $data = array(
                    'msg_id' => $key,
                    'sender_id' => profile()->email,
                    'receiver_id' => $this->input->post('compose_to'),
                    'msg_subject' => $this->input->post('compose_subject'),
                    'msg_body' => $this->input->post('compose_msg'),
                );

                $data2 = array(
                    'msg_id' => $key,
                    'sender_id' => profile()->email,
                    'receiver_id' => $this->input->post('compose_to'),
                    'msg_subject' => $this->input->post('compose_subject'),
                    'msg_body' => $this->input->post('compose_msg'),
                );
                $this->Sendmsg_model->insertOutbox($data);
                $this->Sendmsg_model->insertInbox($data2);
                header('location:communication?success=1');
            }
            else
            {
                header('location:communication?err=1');
            }
        }
    }

    function sendReply()
    {
        $data = array('msg_id' => $this->input->post('msg_id'),
                    'sender_id' => $this->input->post('sender_id'),
                    'reply_body' => $this->input->post('compose_msg'),
                );

                $this->Sendmsg_model->insertReply($data);
                header('location:sent?success=1');
    }
    function sendReplyInbox()
    {
        $data = array('msg_id' => $this->input->post('msg_id'),
                    'sender_id' => $this->input->post('sender_id'),
                    'reply_body' => $this->input->post('compose_msg'),
                );

                $this->Sendmsg_model->insertReply($data);
                header('location:taxes?success=1');
    }

    function saveAsDraft()
    {
        // Create a random user id between 1200 and 4294967295
        $key = 2147483648 + mt_rand(-2147482448, 2147483647);
        $email = profile()->email;
        $data = array(
            'msg_id' => $key,
            'sender_id' => $email,
            'receiver_id' => $this->input->get('compose_to'),
            'msg_subject' => $this->input->get('title'),
            'msg_body' => $this->input->get('body'),
            'status'=>$this->input->get('status'),
        );
        $this->Sendmsg_model->insertDraft($data);
        header('location:taxes?success=1');
    }
}