<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of Dashboard
 *
 * @author test
 */
class IndexOld extends MY_Controller{

  public $pagedata;
  public $branch;
  public $business;

  public function __construct() {
    parent::__construct();
    ($this->require_min_level(1));
    $this->pagedata['link']= 'customers';
    $this->load->model(array(
            'communication/communicationsModel' => 'communicationsModel',
            'crm/customersModel' => 'customersModel',
             'bms/branchesModel' => 'branchesModel',
            'crm/groupsModel' => 'groupsModel'
            ));
    $this->load->helper('crm/crm_helper');
    $this->load->library(array('infobip/infobipLibrary'=>'infobipLibrary'));
    $this->load->model(array('hrm/TitlesModel'=>'titlesModel'));
    $this->load->model('documents/documentsModel');
  }

  public function index() {
    has_control('customers_view_all','View all customers');
    $this->load->helper('form');
    $this->pagedata['customers'] = $this->customersModel->customers();
    $this->pagedata['title'] = 'Communication Email | '.$this->config->item('application_name');
    $this->load->vars($this->pagedata);
    $this->load->view('communication/sms/sms');
  }

    function bulksms(){
        //$farmers = $this->db->get('farmtypes')->result_array();
        $this->pagedata['title'] = 'Sent Bulk SMS';
        $this->pagedata['link']= 'sendbulksms';
        $this->pagedata['customers'] = customers();
        //$this->pagedata['farmers'] = $farmers;
        $this->load->vars($this->pagedata);
        $this->load->view('communication/sms/sendbulksms');
    }

    function log(){
        $this->pagedata['title'] = 'Sent History';
        $this->pagedata['messages'] = $this->infobipLibrary->smsLog();
        $this->load->vars($this->pagedata);
        $this->load->view('communication/sms/log');
    }

    function historydelivered(){
        $this->pagedata['title'] = 'Sent History';
        $this->pagedata['messages'] = $this->infobipLibrary->deliveredSms();
        $this->load->vars($this->pagedata);
        $this->load->view('communication/sms/deliveredsms');
    }

    function sendsinglesms(){
        $recepient = $this->input->get('recepient');
        $sender = $this->input->get('senderid');
        $message = $this->input->get('message');

        if(strtolower(phone_number_format($recepient)) == 'invalid'){
            print 'Phone number is invalid, Follow format 2556537436xx';
            exit();
        }
        $result = $this->infobipLibrary->sendSmsNotify($sender,$recepient,$message);
        if($result['status']){
            $data['sms_messageId'] = $result['messageId'];
            $data['sms_to'] = $recepient;
            $data['sms_text'] = $message;
            $this->db->insert('bulksms',$data);
        }
        print messageStatus($result['message']);

    }

    function sendBulkSmsCustomers(){
        $recepients = $this->input->get('recepients');
        $sender = $this->input->get('senderid');
        $message = $this->input->get('message');
        $result = $this->infobipLibrary->sendBulk($sender,$message,$recepients);
        if($result['status']){
            print 'Sent';
        }else{
            print 'Failed';
        }
    }


}