<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of Attendance
 *
 * @author noely
 */
class Index extends MY_Controller {

    public $pagedata;
    public $branch;
    public $business;

    public function __construct() {
        parent::__construct();
        ($this->require_min_level(1));
        $this->pagedata['link']= 'clock';
        $this->load->model(array(
            'hrm/AttendanceModel'=>'attendanceModel',
            'clock/ClockModel'=>'clockModel',
            'hrm/Employees'=>'employeesModel',
        ));
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
        $this->load->helper('hrm/employees');
    }

    public function index() {
        has_control('employee_view_all','View all employees');
        $this->pagedata['link'] = 'clock';
        $this->load->helper('form');
        $this->pagedata['employees'] = $this->employeesModel->employees();
        $this->pagedata['clock'] = $this->clockModel->clocks();
        $data['show_table'] = $this->view_table();
        $this->pagedata['title'] = 'Hrm Attendance  | '.$this->config->item('application_name');
        $this->load->vars($this->pagedata);
        $this->load->view('clock/clocks',$data);
    }

    function datasourceClocks(){
        $data = $this->clockModel->clocks();
        $columnsDefault = [
            'wclock_key' => true,
            'user_id' => true,
            'firstname' => true,
            'lastname' => true,
            'wclock_user_id' => true,
            'wclock_date' => true,
            'wclock_time_in' => true,
            'wclock_time_out' => true,
            'wclock_time_pause' => true,
            'wclock_time_resume' => true,
            'wclock_status' => true,
        ];
        $this->sourcedataserver($data,$columnsDefault);
    }

    public function view_table(){
        $result = $this->clockModel->show_all_data();
        if ($result != false) {
            return $result;
        } else {
            return 'Database is empty !';
        }
    }

    public function select_by_id() {
        $this->load->helper('form');
        $this->pagedata['link'] = 'attendance';
        $this->pagedata['clock'] = $this->clockModel->clocks();
        $this->pagedata['employees'] = $this->employeesModel->employees();
        $id = $this->input->post('id');
        if ($id != "") {
            $result = $this->clockModel->show_data_by_id($id);
            if ($result != false) {
                $data['result_display'] = $result;
            } else {
                $data['result_display'] = "No record found !";
            }
        } else {
            $data = array(
                'id_error_message' => "Id field is required"
            );
        }
        $data['show_table'] = $this->view_table();
        $this->pagedata['title'] = 'Hrm Attendance  | '.$this->config->item('application_name');
        $this->load->vars($this->pagedata);
        $this->load->view('clock/clocks',$data);
    }

    public function select_by_date() {
        $this->load->helper('form');
        $this->pagedata['link'] = 'attendance';
        $this->pagedata['employees'] = $this->employeesModel->employees();
        $this->pagedata['clock'] = $this->clockModel->clocks();
        $date = $this->input->post('date');
        if ($date != "") {
            $result = $this->clockModel->show_data_by_date($date);

            if ($result != false) {
                $data['result_display'] = $result;
            } else {
                $data['result_display'] = "No record found !";
            }
        } else {
            $data['date_error_message'] = "Date field is required";
        }
        $data['show_table'] = $this->view_table();
        $this->pagedata['title'] = 'Hrm Attendance  | '.$this->config->item('application_name');
        $this->load->vars($this->pagedata);
        $this->load->view('clock/clocks',$data);
    }

    public function select_by_date_range() {
        $this->load->helper('form');
        $this->pagedata['link'] = 'attendance';
        $this->pagedata['employees'] = $this->employeesModel->employees();
        $this->pagedata['clock'] = $this->clockModel->clocks();
        $date1 = $this->input->post('date_from');
        $date2 = $this->input->post('date_to');
        $data = array(
            'date1' => $date1,
            'date2' => $date2
        );
        if ($date1 == "" || $date2 == "") {
            $data['date_range_error_message'] = "Both date fields are required";
        } else {
            $result = $this->clockModel->show_data_by_date_range($data);
            if ($result != false) {
                $data['result_display'] = $result;
            } else {
                $data['result_display'] = "No record found !";
            }
        }
        $data['show_table'] = $this->view_table();
        $this->pagedata['title'] = 'Clock Manager  | '.$this->config->item('application_name');
        $this->load->vars($this->pagedata);
        $this->load->view('clock/clocks',$data);
    }

    function newClockin(){
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        //has_control_ajax('attendance_register','Attendance Recorded');
        $data['wclock_user_id'] = $this->input->get('wclock_user_id',TRUE);
        $data['wclock_date'] = $this->input->get('wclock_date',TRUE);
        $data['wclock_time_in'] = $this->input->get('wclock_time_in',TRUE);
        $data['wclock_status'] = 'Working';
        $data['wclock_date_created'] = date('Y-m-d');

        if($this->clockModel->createWclock($data)){
            $result['status'] = 'ok';
            $result['message'] = 'Working clock recorded successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = 'hapana';
        }
        print json_encode($result);
    }

    public function clockOut($attKey='') {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        $this->pagedata['attendance'] = $this->attendanceModel->select_one_attendance($attKey);
        $this->pagedata['device'] = $this->deviceModel->devices();
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/attendance/attendanceModify');
    }

    public function clockIn($attKey='') {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        $this->pagedata['attendance'] = $this->attendanceModel->select_one_attendance($attKey);
        $this->pagedata['device'] = $this->deviceModel->devices();
        $this->load->vars($this->pagedata);
        $this->load->view('hrm/attendance/attendanceClockin');
    }

    function startWork($wclock){
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        //has_control_ajax('clock_register','Work clock Recorded');
        $data['wclock_user_id'] = $this->auth_user_id;
        $data['wclock_date'] = date('Y-m-d');
        $data['wclock_time_in'] = date('H:i:s');
        $data['wclock_status'] = 'Working';
        $data['wclock_date_created'] = date('Y-m-d');
        if($this->clockModel->createWclock($data)){
            $result['status'] = 'ok';
            $result['message'] = 'Working clock recorded successfully';
        }else{
            $result['status'] = 'no';
            $result['message'] = 'hapana';
        }
        print json_encode($result);
    }

    function breakWork($clockKey=''){
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        //has_control_ajax('clock_break','Work clock Paused');
        $data['wclock_user_id'] = $this->auth_user_id;
        $data['wclock_time_pause'] = date('H:i:s');
        $data['wclock_status'] = 'Break';
        if($this->clockModel->clockBreak($clockKey,$data)){
            $result['status'] = 'ok';
            $result['message'] = 'You are going break';
        }else{
            $result['status'] = 'no';
            $result['message'] = 'hapana';
        }
        print json_encode($result);
    }

    function continueWork($clockKey=''){
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        //has_control_ajax('clock_break','Work clock Paused');
        $data['wclock_user_id'] = $this->auth_user_id;
        $data['wclock_time_resume'] = date('H:i:s');
        $data['wclock_status'] = 'Working';
        if($this->clockModel->clockBreak($clockKey,$data)){
            $result['status'] = 'ok';
            $result['message'] = 'You restarted work';
        }else{
            $result['status'] = 'no';
            $result['message'] = 'hapana';
        }
        print json_encode($result);
    }

    function clockOutWork($clockKey=''){
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        //has_control_ajax('clock_out','Work clock out');
        $data['wclock_user_id'] = $this->auth_user_id;
        $data['wclock_time_out'] = date('H:i:s');
        $data['wclock_status'] = 'Clock Out';
        $data['wclock_time_out_status'] = 'Yes';
        if($this->clockModel->clockBreak($clockKey,$data)){
            $result['status'] = 'ok';
            $result['message'] = 'You clocked out. See you again.';
        }else{
            $result['status'] = 'no';
            $result['message'] = 'hapana';
        }
        print json_encode($result);
    }

    function noClockOutWork($clockKey=''){
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        //has_control_ajax('clock_out','Work clock out');
        $data['wclock_user_id'] = $this->auth_user_id;
        $data['wclock_time_out'] = date('H:i:s');
        $data['wclock_status'] = 'Clock Out';
        $data['wclock_time_out_status'] = 'Yes';
        $data['wclock_time_reason'] = $this->input->get('wclock_time_reason',TRUE);
        if($this->clockModel->clockBreak($clockKey,$data)){
            $result['status'] = 'ok';
            $result['message'] = 'You clocked out for yesterday. Clock In Again.';
        }else{
            $result['status'] = 'no';
            $result['message'] = 'hapana';
        }
        print json_encode($result);
    }

    function breakClock($clock){
        $data['wclock_time_pause'] = date('H:i:s');
        $data['wclock_status'] = 'Break';
        if($this->clockModel->employeeClockUpdate($clock,$data)){
            $result['status'] = 'ok';
            $result['message'] = 'You are going break';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function continueClock($clock){
        $data['wclock_time_resume'] = date('H:i:s');
        $data['wclock_status'] = 'Working';
        if($this->clockModel->employeeClockUpdate($clock,$data)){
            $result['status'] = 'ok';
            $result['message'] = 'You restarted work';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function clockuserOut($clock){
        $data['wclock_time_out'] = date('H:i:s');
        $data['wclock_status'] = 'Clock Out';
        if($this->clockModel->employeeClockUpdate($clock,$data)){
            $result['status'] = 'ok';
            $result['message'] = 'You clocked out. See you again.';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }



    public function clockPause($clockKey='') {
        if (!$this->input->is_ajax_request())
            exit('not direct script allowed');
        $this->pagedata['clock'] = $this->clockModel->select_one_clock($clockKey);
        $this->load->vars($this->pagedata);
        $this->load->view('clock/clockModify');
    }
    function updateClockBreak($clockKey='') {
        $data['wclock_user_id'] = $this->input->get('wclock_user_id',TRUE);
        $data['wclock_time_pause'] = date('H:i:s');
        $data['wclock_status'] = 'Break';
        if($this->clockModel->clockPause($clockKey,$data)){
            $result['status'] = 'ok';
            $result['message'] = 'You are going break';
        }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }


    //----------DELETE------------//

    public function deleteWclock($flag,$key) {
//        if (!$this->input->is_ajax_request())
//            exit('not direct script allowed');
        switch ($flag) {
            case 'clock':
                if($this->clockModel->deleteWClock($key)){
                    $result['status'] = 'ok';
                    $result['message'] = 'Data deleted';
                }else{
                    $result['status'] = 'no';
                    $result['message'] = checkError($this->dbexeption());
                }
                print json_encode($result);
                break;
            default:
                $result['status'] = 'no';
                $result['message'] = 'No action';
                print json_encode($result);
                break;
        }
    }


}