<?php


class Index extends MY_Controller {
    public  $pagedata;
    public $branch;
    public $business;

    public function __construct() {
        parent::__construct();
        $this->require_min_level(1);
        $this->load->model(array('calendar/CalendarModel'=>'calendarModel', 'task/TaskModel'=>'taskModel', 'hrm/Employees'=>'employeesModel',));
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
        $this->load->helper(array('calendar/calendar_helper'));
    }

    public function index() {
        $this->load->helper('form');
        $this->pagedata['link']= 'calendar';
        $this->pagedata['events']= $this->calendarModel->events();
        $this->pagedata['eventside']= $this->calendarModel->side_events();
        $this->pagedata['tasksme'] = $this->taskModel->tasksbymec($this->auth_user_id);
        $this->pagedata['title'] = 'Calendar | '.$this->config->item('application_name');
        $this->load->vars($this->pagedata);
        $this->load->view('calendar/calendar');
    }

    function removeeventajax($key){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        $this->db->limit(1);
        $this->db->where("event_key",$key);
        $this->db->delete("events");
        if($this->db->affected_rows()>0){
            $result['status'] = true;
            $result['message'] = "Event deleted successfully";
        }else{
            $result['status'] = false;
            $result['message'] = "We could not finish your request at a time try again after some time";
        }
        print json_encode($result,JSON_PRETTY_PRINT);
    }


    function eventresizeajax(){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        $key = $this->input->get('events',TRUE);
        $data['event_start_datetime'] = date("Y-m-d H:i:s", strtotime($this->input->get('event_start_datetime',TRUE)));
        $data['event_time_start'] = date("H:i:s", strtotime($this->input->get('event_start_datetime',TRUE)));
        $data['event_end_datetime'] = date("Y-m-d H:i:s", strtotime($this->input->get('event_end_datetime',TRUE)));
        $data['event_time_end'] = date("H:i:s", strtotime($this->input->get('event_end_datetime',TRUE)));

        $this->db->limit(1);
        $this->db->where("event_key",$key);
        $this->db->update("events",$data);
        if($this->db->affected_rows()>0){
            $result['status'] = true;
            $result['message'] = "Event updated successfully";
        }else{
            $result['status'] = false;
            $result['message'] = "We could not finish your request at a time try again after some time";
        }
        print json_encode($result,JSON_PRETTY_PRINT);
    }

    function addeventajax(){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        $data['event_key'] = $this->calendarModel->key();
        $data['event_user_id'] = $this->auth_user_id;
        $data['event_business_key'] = $this->business;
        $data['event_title'] = $this->input->get('event_title',TRUE);
        $data['event_desc'] = $this->input->get('event_desc',TRUE);
        $data['event_color'] = $this->input->get('event_color',TRUE);

        $data['event_start_datetime'] = date("Y-m-d H:i:s", strtotime($this->input->get('event_start_datetime',TRUE)));
        $data['event_time_start'] = date("H:i:s", strtotime($this->input->get('event_start_datetime',TRUE)));
        if($this->input->get('allday',TRUE)){
            $data['event_end_datetime'] = date("Y-m-d", strtotime($this->input->get('event_start_datetime',TRUE))).' 23:59:59';
            $data['event_time_end'] =  '23:59:59';
        }else{
            $data['event_end_datetime'] = date("Y-m-d H:i:s", strtotime($this->input->get('event_end_datetime',TRUE)));
            $data['event_time_end'] = date("H:m:i", strtotime($this->input->get('event_end_datetime',TRUE)));
        }

        $this->db->limit(1);
        $this->db->insert("events",$data);
        if($this->db->affected_rows()>0){
            $data['status'] = true;
            $data['message'] = "Event added successfully";
        }else{
            $data['status'] = false;
            $data['message'] = "We could not finish your request at a time try again after some time";
        }
        print json_encode($data,JSON_PRETTY_PRINT);
    }

}