<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
* Description of Dashboard
*
* @author kelvin
*/

class Index extends MY_Controller{

  public  $pagedata;

  public $branch;
  public $business;

  public function __construct() {
    parent::__construct();
    $this->require_min_level(1);
    $this->pagedata['link']= 'accounting';
    $this->load->model(array('accounting/accounting'=>'accountingModel','FinancialPeriodsModel'=>'periodsModel'));
    $this->branch = runningBranch()->branch_key;
    $this->business = runningBusiness()->business_key;
  }

  public function index() {
      if($this->tokens->match){
          $data['setting_business'] = $this->business;
          $data['accounting_rule'] = $this->input->post("accounting_rule",TRUE);
          $data['financial_year'] = $this->input->post("financial_year",TRUE);
          $this->db->replace("accounting_settings",$data);
      }


    $this->load->helper(array('form','invoices/helper'));
    $this->pagedata['title'] = 'Accounting | '.$this->config->item('application_name');
    $this->pagedata['sub_link'] = 'settings';
    $this->pagedata['settings'] = accountSettings();
    $this->load->vars($this->pagedata);
    $this->load->view('accounting/settings/settings');
  }

  public function payroll() {

        if($this->tokens->match){
            $data['set_branch'] = $this->branch;
            $data['set_business'] = $this->business;
            $data['set_revenue_account'] = $this->input->post("revenue_account",TRUE);
            $data['set_receivable_account'] = $this->input->post("receivable_account",TRUE);
            $data['set_cash_account'] = $this->input->post("cash_account",TRUE);
            $data['set_discount_account'] = $this->input->post("discount_account",TRUE);
            $data['set_receivable_account'] = $this->input->post("receivable_account",TRUE);
            $data['set_override_account_settings'] = !empty($this->input->post("set_override_account_settings",TRUE)) ? $this->input->post("set_override_account_settings",TRUE): 0 ;
            $data['set_post_to_gl'] = !empty($this->input->post("set_post_to_gl",TRUE)) ? $this->input->post("set_post_to_gl",TRUE): 0 ;
            $this->db->replace("invoice_settings",$data);
        }

        $this->load->helper(array('form','payroll/payroll'));
        $this->pagedata['title'] = 'Payroll Settings| '.$this->config->item('application_name');
        $this->pagedata['sub_link'] = 'payroll';
        $this->pagedata['settings'] = payrollsSettings();
        $this->load->vars($this->pagedata);
        $this->load->view('accounting/settings/payrolls');
    }

  public function invoices() {

      if($this->tokens->match){
          $data['set_branch'] = $this->branch;
          $data['set_business'] = $this->business;
          $data['set_revenue_account'] = $this->input->post("revenue_account",TRUE);
          $data['set_receivable_account'] = $this->input->post("receivable_account",TRUE);
          $data['set_cash_account'] = $this->input->post("cash_account",TRUE);
          $data['set_discount_account'] = $this->input->post("discount_account",TRUE);
          $data['set_receivable_account'] = $this->input->post("receivable_account",TRUE);
          $data['set_override_account_settings'] = !empty($this->input->post("set_override_account_settings",TRUE)) ? $this->input->post("set_override_account_settings",TRUE): 0 ;
          $data['set_post_to_gl'] = !empty($this->input->post("set_post_to_gl",TRUE)) ? $this->input->post("set_post_to_gl",TRUE): 0 ;
          $this->db->replace("invoice_settings",$data);
      }

        $this->load->helper(array('form','invoices/helper'));
        $this->pagedata['title'] = 'Accounting Settings | '.$this->config->item('application_name');
        $this->pagedata['sub_link'] = 'invoices';
        $this->pagedata['settings'] = invoiceSettings();
        $this->load->vars($this->pagedata);
        $this->load->view('accounting/settings/invoices');
  }

  public function loans() {

        if($this->tokens->match){
            $data['loan_setting_branch'] = $this->branch;
            $data['loan_setting_business'] = $this->business;
            $data['loan_setting_app_referees'] = $this->input->post("loan_setting_app_referees",TRUE);
            $data['loan_setting_app_approval_levels'] = $this->input->post("loan_setting_app_approval_levels",TRUE);
            $data['loan_setting_customer_max_active_apps'] = $this->input->post("loan_setting_customer_max_active_apps",TRUE);
            $data['loan_setting_principal_receivable'] = $this->input->post("loan_setting_principal_receivable",TRUE);
            $data['loan_setting_principal_cash'] = $this->input->post("loan_setting_principal_cash",TRUE);
            $data['loan_setting_interest_receivable'] = $this->input->post("loan_setting_interest_receivable",TRUE);
            $data['loan_setting_interest_revenue'] = $this->input->post("loan_setting_interest_revenue",TRUE);
            $data['loan_setting_interest_cash'] = $this->input->post("loan_setting_interest_cash",TRUE);
            $data['loan_setting_charges_receivable'] = $this->input->post("loan_setting_charges_receivable",TRUE);
            $data['loan_setting_charges_cash'] = $this->input->post("loan_setting_charges_cash",TRUE);
            $data['loan_setting_penalty_receivable'] = $this->input->post("loan_setting_penalty_receivable",TRUE);
            $data['loan_setting_penalty_revenue'] = $this->input->post("loan_setting_penalty_revenue",TRUE);
            $data['loan_setting_penalty_cash'] = $this->input->post("loan_setting_penalty_cash",TRUE);
            $this->db->replace("loan_settings",$data);
        }

        $this->load->helper(array('form','loans/loans'));
        $this->pagedata['title'] = 'Accounting Settings | '.$this->config->item('application_name');
        $this->pagedata['sub_link'] = 'loans';
        $this->pagedata['settings'] = loanSettings();
        $this->load->vars($this->pagedata);
        $this->load->view('accounting/settings/loans');
    }
    public function assets() {

        if($this->tokens->match){
            $data['setting_branch'] = $this->branch;
            $data['setting_business'] = $this->business;
            $data['setting_source_acc'] = $this->input->post("setting_source_acc",TRUE);
            $data['setting_expense_acc'] = $this->input->post("setting_expense_acc",TRUE);
            $this->db->replace("asset_settings",$data);
        }

        $this->load->helper(array('form','assets'));
        $this->pagedata['title'] = 'Accounting Settings | '.$this->config->item('application_name');
        $this->pagedata['sub_link'] = 'assets';
        $this->pagedata['settings'] = assetSettings();
        $this->load->vars($this->pagedata);
        $this->load->view('accounting/settings/assets');
    }

    public function periods() {
        //Financial periods function
        if($this->tokens->match){
            $this->db->trans_start();
            $data['fp_start'] = $this->input->post("fp_start",TRUE);
            $data['fp_end'] = $this->input->post("fp_end",TRUE);
            $data['fp_prefix'] = $this->input->post("fp_prefix",TRUE);

            $this->periodsModel->insert($data);

            $this->db->trans_complete();
            if($this->db->trans_status() === TRUE){
                $result['status'] = true;
                $result['message'] = "Operation done successfully!";
            }
            else{
                $result['status'] = false;
                $result['message'] = "Oops! operation failed!";
            }
        }
        $this->load->helper(array('form','assets'));
        $this->pagedata['title'] = 'Accounting Settings | '.$this->config->item('application_name');
        $this->pagedata['sub_link'] = 'periods';
        $this->pagedata['settings'] = assetSettings();
        $this->load->vars($this->pagedata);
        $this->load->view('accounting/settings/financial_periods');
    }
    public function period_details($key='') {
        if($this->tokens->match){
            header('Content-Type: application/json');
            header('Access-Control-Allow-Origin: ' . base_url());
            header('Access-Control-Allow-Methods: GET, POST');
            header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

            $data['fp_start'] = $this->input->post("fp_start",TRUE);
            $data['fp_end'] = $this->input->post("fp_end",TRUE);
            $data['fp_prefix'] = $this->input->post("fp_prefix",TRUE);
            $id = $this->input->post("fp_key",TRUE);

            if($this->periodsModel->update($id, $data)){
                $result['status'] = true;
                $result['message'] = "Operation done successfully!";
            }
            else{
                $result['status'] = false;
                $result['message'] = "Oops! operation failed!";
            }
            echo json_encode($result, JSON_PRETTY_PRINT);
        }
        $this->load->helper('form');
        $this->pagedata['title'] = 'Accounting Settings | '.$this->config->item('application_name');
        $this->pagedata['period'] = $this->periodsModel->find_by(['fp_key'=>$key]);
        $this->load->vars($this->pagedata);
        $this->load->view('accounting/settings/period_modify');
    }
    public function activate_period($key) {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $data['fp_status'] = "Active";

        if($this->periodsModel->update($key, $data)){
            $result['status'] = true;
            $result['message'] = "Operation done successfully!";
        }
        else{
            $result['status'] = false;
            $result['message'] = "Oops! operation failed!";
        }
        echo json_encode($result, JSON_PRETTY_PRINT);
        exit();
    }
    public function deactivate_period($key) {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $data['fp_status'] = "Inactive";
        if($this->periodsModel->update($key, $data)){
            $result['status'] = true;
            $result['message'] = "Operation done successfully!";
        }
        else{
            $result['status'] = false;
            $result['message'] = "Oops! operation failed!";
        }
        echo json_encode($result, JSON_PRETTY_PRINT);
        exit();
    }
    public function delete_period($key) {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if($this->periodsModel->delete($key)){
            $result['status'] = true;
            $result['message'] = "Operation done successfully!";
        }
        else{
            $result['status'] = false;
            $result['message'] = "Oops! operation failed!";
        }
        echo json_encode($result, JSON_PRETTY_PRINT);
        exit();
    }
    public function restore_period($key) {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if($this->periodsModel->update($key,['fp_deleted' => 0])){
            $results['message'] = 'Period restored successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to restore period';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }

    function datasource_financial_periods($when='')
    {
        /** This is the function for loading financial periods data table (Freight Forwarding) */

        //has_control('freight_view_all', 'View Freight');
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));

        if(!empty($when)){
            $data = $this->periodsModel->order_by('fp_created', 'DESC')->find_many_by(["fp_created" => $when]);
        }else{
            $data = $this->periodsModel->order_by('fp_created', 'DESC')->find_all();
        }

        //$data = $this->freightsModel->order_by('fr_created_on', 'DESC')->find_all();
        $columns = array();
        foreach ($this->periodsModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($data,$columns);
    }
    function datasource_financial_periods_bin($when='')
    {
        /** This is the function for loading deleted financial periods data table (Freight Forwarding) */

        //has_control('freight_view_all', 'View Freight');
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $this->periodsModel->where('fp_deleted', 1);
        if(!empty($when)){
            $data = $this->periodsModel->with_deleted()->order_by('fp_modified_on', 'DESC')->find_many_by(["fp_modified_on" => $when]);
        }else{
            $data = $this->periodsModel->with_deleted()->order_by('fp_modified_on', 'DESC')->find_all();
        }
        //$data = $this->freightsModel->with_deleted()->find_all();
        $columns = array();
        foreach ($this->periodsModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($data,$columns);
    }

  public function saveconfiguration() {
        if(!$this->input->is_ajax_request())
          exit('no cirect script allowed');

      $config['config_fiscal_year'] = $this->input->post('config_fiscal_year',TRUE);
      if($this->configurationModel->saveconfiguration($config)):
            $result['status'] = 'ok';
            $result['message'] = 'Configuration saved';
          else:
            $result['status'] = 'no';
            $result['message'] = 'Configuration not saved';
      endif;

       print json_encode($result);
  }

}
