<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of Dashboard
 *
 * @author test
 */
class  Balancesheet extends MY_Controller{

  public $pagedata;

  public function __construct() {
    parent::__construct();
    ($this->require_min_level(1));
      $this->load->helper(array(
              'accounting/accounting',
          'accounting/reports/helper'
      ));
    $this->pagedata['link']= 'reports';
    $this->load->model(array('FinancialReportsModel','financialReportsModel','accounting/accounting'=>'accountingModel'));
  }

  public function index() {
      has_control('loans_view_applications','View loan applications');
      $this->load->helper('form');

      $this->pagedata['start_date'] = $this->input->get('start_date');
      $this->pagedata['end_date'] = $this->input->get('end_date');
      $this->pagedata['title'] = 'Balancesheet Financia Reports | '.$this->config->item('application_name');
      $this->pagedata['view'] = !empty($_GET['view']) ? $_GET['view'] : 'grid';
      $this->load->vars($this->pagedata);
      $this->load->view('reports/financial/balancesheet');
  }

  public function details($app='') {
    has_control('loans_view_applications','View loan applications');
    $this->pagedata['title'] = ' Loan applications | '.$this->config->item('application_name');
    $this->pagedata['application'] =  $this->loansModel->applicationDetails($app);
    $this->pagedata['loans'] = $this->loansModel->lists();
    $this->pagedata['customers'] = customers();
    $this->load->vars($this->pagedata);
    $this->load->view('employee/loans/applications/details');
  }

public function loadDetails($app=''){
  has_control_ajax_content('loans_view_applications','View loan applications');
  $this->pagedata['title'] = ' Loan applications | '.$this->config->item('application_name');
  $this->pagedata['application'] =  $this->loansModel->applicationDetails($app);
  $this->pagedata['loans'] = $this->loansModel->lists();
  $this->pagedata['customers'] = customers();
  $this->load->vars($this->pagedata);
  $this->load->view('employee/loans/applications/detailsAjax');
}

public function loadpayments($app=''){
  has_control_ajax_content('loans_view_applications','View loan applications');
  $this->pagedata['title'] = ' Loan applications | '.$this->config->item('application_name');
  $this->pagedata['application'] =  $this->loansModel->applicationDetails($app);
  $this->pagedata['payments'] = $this->loansModel->loanpayments($app);
  $this->pagedata['loans'] = $this->loansModel->lists();
  $this->pagedata['customers'] = customers();
  $this->load->vars($this->pagedata);
  $this->load->view('employee/loans/applications/paymentsAjax');
}

public function loadprocessing($app=''){
  has_control_ajax_content('loans_view_applications','View loan applications');
  $this->pagedata['title'] = ' Loan applications | '.$this->config->item('application_name');
  $this->pagedata['application'] =  $this->loansModel->applicationDetails($app);
  $this->pagedata['payments'] = $this->loansModel->loanpayments($app);
  $this->pagedata['loans'] = $this->loansModel->lists();
  $this->pagedata['customers'] = customers();
  $this->load->vars($this->pagedata);
  $this->load->view('employee/loans/applications/processingAjax');
}

  public function register() {
    has_control('loans_register_applications','Register loan applications');
    $this->pagedata['title'] = ' Loans | '.$this->config->item('application_name');
    $this->pagedata['loans'] = $this->loansModel->lists();
    $this->pagedata['customers'] = customers();
    $this->load->vars($this->pagedata);
    $this->load->view('employee/loans/applications/new');
  }

function updateapplicationapprovers($app=''){
  $data = $this->input->get('app_approver_employee',TRUE);
  if($this->loansModel->updateapplicationapprovers($app,$data)){
            $result['status'] = 'ok';
            $result['message'] = 'Charge deleted';
          }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
          }
    print json_encode($result);
}

function approve($me,$app,$act){
  if (!$this->input->is_ajax_request())
   exit('not direct script allowed');
   has_control_ajax('loans_register_applications','Register Loan Application');
  $data['app_approver_approved'] = $act;
  $this->db->where('app_approver_id',$app);
  $this->db->where('app_approver_employee',$me);
  $this->db->update('loan_application_approvers',$data);
  if($this->db->affected_rows()>0){
            $result['status'] = 'ok';
            $result['message'] = 'Changes applied successifully';
            $approvedApp = $this->loansModel->approvedapplication($app);
            if($this->loansModel->applicationapproved($approvedApp->app_approver_app)){
              $datai['app_status'] = 'Approved';
              }else{
                $datai['app_status'] = 'Pending';
              }
            $this->loansModel->simpleapplicationupdate($approvedApp->app_approver_app,$datai);
          }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
          }
    print json_encode($result);
}

function collect($app,$appkey){
  if (!$this->input->is_ajax_request())
   exit('not direct script allowed');
   has_control_ajax('loans_register_applications','Register Loan Application');

  if($this->loansModel->applicationapproved($appkey)){
    if($this->loansModel->applicationcollectpayment($app)){
            $result['status'] = 'ok';
            $result['message'] = 'Payment collected successifully';
          }else{
            $result['status'] = 'no';
            $result['message'] = checkError($this->dbexeption());
          }
    }else{
      $result['status'] = 'no';
      $result['message'] = 'Application must be full approved';
    }
    print json_encode($result);
}

function appstatus($app){
  if($this->loansModel->applicationapproved($app)){
    echo 1;
  }else{
    echo 0;
  }
}

function registerAction(){

  if (!$this->input->is_ajax_request())
   exit('not direct script allowed');

   has_control_ajax('loans_register_applications','Register Loan Application');
   $appData = $this->collectApplcationData();
   if(!$appData['status']){
     $output['status'] = 'no';
     $output['message'] = $appData['data'];
     print json_encode($output);
     exit();
   }

   $schedule = $this->loanApplicationSchedule();
   $charges = $this->loansModel->charges($appData['data']['app_loan']);
   $application = $appData['data'];
   $application['app_registra'] = $this->auth_user_id;
   $application['app_updator'] = NULL;

   if($this->loansModel->registerApplication($application,$schedule,$charges)){
         $event = 'views';
         $channel = 'loans';
         $data['not_url'] = '';
         $data['not_content'] = profile()->firstname.' '.profile()->lastname.' has registered loan application';
         $data['not_origin_content'] = 'You have successifully registered a loan application';
         $data['not_title'] = 'Loan Application';
         $data['not_origin'] = $this->auth_user_id;
         $data['not_channel'] = $channel;
         $data['not_event'] = $event;
         $this->pusher->triggerRegister($channel,$event,$data);
         $result['status'] = 'ok';
         $result['message'] = 'Application registered successifully';
       }else{
         $result['status'] = 'no';
         $result['message'] = checkError($this->dbexeption());
      }
  print json_encode($result);

}

function updateapplication($app=''){

  if (!$this->input->is_ajax_request())
   exit('not direct script allowed');

   has_control_ajax('loans_register_applications','Register Loan Application');
   $appData = $this->collectUpdateApplcationData();
   if(!$appData['status']){
     $output['status'] = 'no';
     $output['message'] = $appData['data'];
     print json_encode($output);
     exit();
   }

   $schedule = $this->loanUpdateApplicationSchedule();
   $charges = $this->loansModel->charges($appData['data']['app_loan']);
   $application = $appData['data'];
   $application['app_updator'] = $this->auth_user_id;

   if($this->loansModel->updateApplication($app,$application,$schedule,$charges)){
         $event = 'views';
         $channel = 'loans';
         $data['not_url'] = '';
         $data['not_content'] = profile()->firstname.' '.profile()->lastname.' has updated loan application';
         $data['not_origin_content'] = 'You have successifully updated a loan application';
         $data['not_title'] = 'Loan Application';
         $data['not_origin'] = $this->auth_user_id;
         $data['not_channel'] = $channel;
         $data['not_event'] = $event;
         $this->pusher->triggerRegister($channel,$event,$data);
         $result['status'] = 'ok';
         $result['message'] = 'Application updated successifully';
       }else{
         $result['status'] = 'no';
         $result['message'] = checkError($this->dbexeption());
      }
  print json_encode($result);

}


function registerpreview(){

  if (!$this->input->is_ajax_request())
   exit('not direct script allowed');

   has_control_ajax('loans_register_applications','Register Loan Application');
   $appData = $this->collectApplcationData();
   if(!$appData['status']){
     print  $appData['data'];
     exit();
   }

   $charges = $this->loansModel->charges($appData['data']['app_loan']);?>

   <table class="table table-danger">
     <thead>
       <tr>
         <th colspan="4">One time charges</th>
       </tr>
       <tr>
         <th>#</th>
         <th>Charge</th>
         <th>Type</th>
         <th>Amount</th>
       </tr>
     </thead>
     <tbody>
         <?php
       $total = 0;
       $j=1;
       if(!empty($charges)){
         foreach ($charges as $key => $charge) {
           if($charge['charge_type'] != 'saving' && $charge['charge_type'] != 'loan repayment' ){
           ?>
          <tr>
            <td><?php echo $j;?></td>
           <td><?php echo $charge['charge_name'];?></td>
           <td><?php echo ucfirst($charge['charge_type']);?></td>
           <td><?php echo number_format(to_money($charge['charge_amount']));?></td>
         </tr>
         <?php $total += to_money($charge['charge_amount']) ; $j++;}
       } } ?>
       <tr>
         <td></td>
         <td colspan="2">Total</td>
         <td><?php echo runnCurrency()->currency_symbol.number_format($total);?></td>
       </tr>
     </tbody>

   </table>
   <hr/>
     <table class="table table-info table-bordered">
      <thead>
        <tr>
          <th>#</th>
          <th>From</th>
          <th>To</th>
          <th>Principal</th>
          <th>Interest</th>
          <th colspan="2">Charges</th>
          <th>Total</th>
        </tr>
      </thead>
      <tbody>
        <?php
        $chargesc=0;
         if(!empty($chargesy = $this->loansModel->charges($appData['data']['app_loan']))){
        foreach ($chargesy as $key => $chargey) {
          if($chargey['charge_type'] === 'saving' || $chargey['charge_type'] == 'loan repayment' ){
            $chargesc += $chargey['charge_amount'];
         }}}

        $result = $this->loanApplicationSchedule();
        $principal = $appData['data']['app_principal']/$result['installments'];
        $interest =  ($appData['data']['app_principal'] * (to_money($appData['data']['app_interest_rate']) /100))/$result['installments'];
        $total = $principal + $interest + $chargesc;
        $totalPrincipal = 0;
        $totalInterest = 0;
        $totalCharges = 0;
        $grandTotal = 0;
        for ($i=1; $i <= $result['installments'] ; $i++) {
          $totalPrincipal = $totalPrincipal + $principal;
          $totalInterest = $totalInterest + $interest;
          $totalCharges =+ $totalCharges + $chargesc;
          $grandTotal = $grandTotal + $total;
          if($i == 1){
              $start = $result['datestart'];
              $dateend = strtotime(date("Y-m-d", strtotime($result['datestart'])) . " +".$result['cycle']*$i." days");
              $end = date('Y-m-d',$dateend);
            }else{
              $start = date('Y-m-d',strtotime(date("Y-m-d", strtotime($end)) . " +1 days"));
              $dateend = strtotime(date("Y-m-d", strtotime($start)) . " +".$result['cycle']." days");
              $end = date('Y-m-d',$dateend);
            }
            ?>
            <tr>
              <td><?php echo $i;?></td>
              <td><?php echo $start;?></td>
              <td><?php echo $end;?></td>
              <td><?php echo number_format(to_money($principal));?></td>
              <td><?php echo number_format(to_money($interest));?></td>
              <td>
                <?php if(!empty($chargesx = $this->loansModel->charges($appData['data']['app_loan']))){
                foreach ($chargesx as $key => $chargex) {
                  if($chargex['charge_type'] === 'saving' || $chargex['charge_type'] == 'loan repayment' ){
                    print $chargex['charge_name'].'&nbsp'.number_format(to_money($chargex['charge_amount'])).'<br/>';
                 }}} ?></td>
              <td><?php echo number_format(to_money($chargesc));?></td>
              <td><?php echo number_format(to_money($total));?></td>
            </tr>
          <?php } ?>
            <tr>
              <th colspan="2">Total Principal</th>
              <th colspan="2">Total Interest</th>
              <th colspan="2">Total Charges</th>
              <th colspan="2">Grand Total</th>
            </tr>
            <tr>
              <td colspan="2"><?php echo runnCurrency()->currency_symbol.number_format(to_money($totalPrincipal));?></td>
              <td colspan="2"><?php echo runnCurrency()->currency_symbol.number_format(to_money($totalInterest));?></td>
              <td colspan="2"><?php echo runnCurrency()->currency_symbol.number_format(to_money($totalCharges));?></td>
              <td colspan="2"><?php echo runnCurrency()->currency_symbol.number_format(to_money($grandTotal));?></td>
            </tr>
      </tbody>
     </table>
<?php
}


function updatepreview(){

  // if (!$this->input->is_ajax_request())
  //  exit('not direct script allowed');

   has_control_ajax('loans_register_applications','Register Loan Application');

   $appData = $this->collectUpdateApplcationData();
   if(!$appData['status']){
     print  $appData['data'];
     exit();
   }

   $charges = $this->loansModel->charges($appData['data']['app_loan']);?>

   <table class="table table-danger">
     <thead>
       <tr>
         <th colspan="4">One time charges</th>
       </tr>
       <tr>
         <th>#</th>
         <th>Charge</th>
         <th>Type</th>
         <th>Amount</th>
       </tr>
     </thead>
     <tbody>
         <?php
       $total = 0;
       $j=1;
       if(!empty($charges)){
         foreach ($charges as $key => $charge) {
           if($charge['charge_type'] != 'saving' && $charge['charge_type'] != 'loan repayment' ){
           ?>
          <tr>
            <td><?php echo $j;?></td>
           <td><?php echo $charge['charge_name'];?></td>
           <td><?php echo ucfirst($charge['charge_type']);?></td>
           <td><?php echo number_format(to_money($charge['charge_amount']));?></td>
         </tr>
         <?php $total += to_money($charge['charge_amount']) ; $j++;}
       } } ?>
       <tr>
         <td></td>
         <td colspan="2">Total</td>
         <td><?php echo runnCurrency()->currency_symbol.number_format($total);?></td>
       </tr>
     </tbody>

   </table>
   <hr/>
     <table class="table table-info table-bordered">
      <thead>
        <tr>
          <th>#</th>
          <th>From</th>
          <th>To</th>
          <th>Principal</th>
          <th>Interest</th>
          <th colspan="2">Charges</th>
          <th>Total</th>
        </tr>
      </thead>
      <tbody>
        <?php
        $chargesc=0;
         if(!empty($chargesy = $this->loansModel->charges($appData['data']['app_loan']))){
        foreach ($chargesy as $key => $chargey) {
          if($chargey['charge_type'] === 'saving' || $chargey['charge_type'] == 'loan repayment' ){
            $chargesc += $chargey['charge_amount'];
         }}}

        $result = $this->loanUpdateApplicationSchedule();
        $principal = $appData['data']['app_principal']/$result['installments'];
        $interest =  to_money(($appData['data']['app_principal'] * ($appData['data']['app_interest_rate'] /100)))/$result['installments'];
        $total = $principal + $interest + $chargesc;
        $totalPrincipal = 0;
        $totalInterest = 0;
        $totalCharges = 0;
        $grandTotal = 0;
        for ($i=1; $i <= $result['installments'] ; $i++) {
          $totalPrincipal = $totalPrincipal + $principal;
          $totalInterest = $totalInterest + $interest;
          $totalCharges =+ $totalCharges + $chargesc;
          $grandTotal = $grandTotal + $total;
          if($i == 1){
              $start = $result['datestart'];
              $dateend = strtotime(date("Y-m-d", strtotime($result['datestart'])) . " +".$result['cycle']*$i." days");
              $end = date('Y-m-d',$dateend);
            }else{
              $start = date('Y-m-d',strtotime(date("Y-m-d", strtotime($end)) . " +1 days"));
              $dateend = strtotime(date("Y-m-d", strtotime($start)) . " +".$result['cycle']." days");
              $end = date('Y-m-d',$dateend);
            }
            ?>
            <tr>
              <td><?php echo $i;?></td>
              <td><?php echo $start;?></td>
              <td><?php echo $end;?></td>
              <td><?php echo number_format(to_money($principal));?></td>
              <td><?php echo number_format(to_money($interest));?></td>
              <td>
                <?php if(!empty($chargesx = $this->loansModel->charges($appData['data']['app_loan']))){
                foreach ($chargesx as $key => $chargex) {
                  if($chargex['charge_type'] === 'saving' || $chargex['charge_type'] == 'loan repayment' ){
                    print $chargex['charge_name'].'&nbsp'.number_format(to_money($chargex['charge_amount'])).'<br/>';
                 }}} ?></td>
              <td><?php echo number_format(to_money($chargesc));?></td>
              <td><?php echo number_format(to_money($total));?></td>
            </tr>
          <?php } ?>
            <tr>
              <th colspan="2">Total Principal</th>
              <th colspan="2">Total Interest</th>
              <th colspan="2">Total Charges</th>
              <th colspan="2">Grand Total</th>
            </tr>
            <tr>
              <td colspan="2"><?php echo runnCurrency()->currency_symbol.number_format(to_money($totalPrincipal));?></td>
              <td colspan="2"><?php echo runnCurrency()->currency_symbol.number_format(to_money($totalInterest));?></td>
              <td colspan="2"><?php echo runnCurrency()->currency_symbol.number_format(to_money($totalCharges));?></td>
              <td colspan="2"><?php echo runnCurrency()->currency_symbol.number_format(to_money($grandTotal));?></td>
            </tr>
      </tbody>
     </table>
<?php
}

function loadproductoptions(){
  $loan = $this->input->get('loan',TRUE);
  $loan = $this->loansModel->loan($loan);
  if($loan){
    $option['status'] = 'ok';
    $option['principal'] = to_money($loan->loan_principal_default_amount);
    $option['interest'] = to_money($loan->loan_interest_default_amount);
  }else{
    $option['status'] = 'no';
  }
  print json_encode($option);
}

function collectApplcationData(){
  $data = inputAllGet();

  $loanData = $this->loansModel->loan($data['app_loan']);

  if(!$loanData){
    $return['status'] = FALSE;
    $return['data'] = 'You must select Loan Product';
    return $return;
  }

  if(to_dollar($data['app_principal']) < $loanData->loan_principal_min_amount){
    $return['status'] = FALSE;
    $return['data'] = 'Principal Amount must be greater or equal to '.number_format(to_money($loanData->loan_principal_min_amount));
    return $return;
  }

  if(to_dollar($data['app_principal']) > $loanData->loan_principal_max_amount){
    $return['status'] = FALSE;
    $return['data'] = 'Principal Amount must be less or equal to '.number_format(to_money($loanData->loan_principal_max_amount));
    return $return;
  }

  if(to_dollar($data['app_interest_rate']) < $loanData->loan_interest_min_amount){
    $return['status'] = FALSE;
    $return['data'] = 'Interest Amount must be greater or equal to '.number_format(to_money($loanData->loan_interest_min_amount));
    return $return;
  }

  if(to_dollar($data['app_interest_rate']) > $loanData->loan_interest_max_amount){
    $return['status'] = FALSE;
    $return['data'] = 'Interest Amount must be less equal to '.number_format(to_money($loanData->loan_interest_max_amount));
    return $return;
  }

  if($this->loansModel->getCustomerActiveLoanApps($data['app_customer']) >  $this->loansModel->getLoanSettings()->loan_setting_customer_max_active_apps){
    $return['status'] = FALSE;
    $return['data'] = 'Customer must have not more than '.abs($this->loansModel->getLoanSettings()->loan_setting_customer_max_active_apps).' active applications';
    return $return;
  }

  $application['app_loan'] = $data['app_loan'];
  $application['app_customer'] = $data['app_customer'];
  $application['app_disburse_method'] = $data['app_disburse_method'];
  $application['app_term'] = $loanData->loan_term;
  $application['app_schedule'] = $loanData->loan_payment_schedule;
  $application['app_term_count'] = $loanData->loan_term_count;
  $application['app_principal'] = to_dollar($data['app_principal']);
  $application['app_interest_rate'] = to_dollar($data['app_interest_rate']);
  $application['app_status'] = $data['app_status'];
  $application['app_date'] = date('Y-m-d H:i:m',strtotime($data['app_date']));
  $application['app_referees'] = json_encode($data['app_referees']);
  $return['status'] = TRUE;
  $return['data'] = $application;

  return $return;

}

function collectUpdateApplcationData(){
  $data = inputAllGet();

  $loanData = $this->loansModel->loan($data['app_loan']);

  if(!$loanData){
    $return['status'] = FALSE;
    $return['data'] = 'You must select Loan Product';
    return $return;
  }

  if(to_dollar($data['app_principal']) < $loanData->loan_principal_min_amount){
    $return['status'] = FALSE;
    $return['data'] = 'Principal Amount must be greater or equal to '.number_format(to_money($loanData->loan_principal_min_amount));
    return $return;
  }

  if(to_dollar($data['app_principal']) > $loanData->loan_principal_max_amount){
    $return['status'] = FALSE;
    $return['data'] = 'Principal Amount must be less or equal to '.number_format(to_money($loanData->loan_principal_max_amount));
    return $return;
  }

  if(to_dollar($data['app_interest_rate']) < $loanData->loan_interest_min_amount){
    $return['status'] = FALSE;
    $return['data'] = 'Interest Amount must be greater or equal to '.number_format(to_money($loanData->loan_interest_min_amount));
    return $return;
  }

  if(to_dollar($data['app_interest_rate']) > $loanData->loan_interest_max_amount){
    $return['status'] = FALSE;
    $return['data'] = 'Interest Amount must be less equal to '.number_format(to_money($loanData->loan_interest_max_amount));
    return $return;
  }

  if($this->loansModel->getCustomerActiveLoanApps($data['app_customer']) >  $this->loansModel->getLoanSettings()->loan_setting_customer_max_active_apps){
    $return['status'] = FALSE;
    $return['data'] = 'Customer must have not more than '.abs($this->loansModel->getLoanSettings()->loan_setting_customer_max_active_apps).' active applications';
    return $return;
  }

  $application['app_loan'] = $data['app_loan'];
  $application['app_customer'] = $data['app_customer'];
  $application['app_disburse_method'] = $data['app_disburse_method'];
  $application['app_term'] = $data['app_term'];
  $application['app_schedule'] = $data['app_schedule'];
  $application['app_term_count'] = $data['app_term_count'];
  $application['app_principal'] = to_dollar($data['app_principal']);
  $application['app_interest_rate'] = to_dollar($data['app_interest_rate']);
  $application['app_status'] = $data['app_status'];
  $application['app_date'] = date('Y-m-d H:i:m',strtotime($data['app_date']));
  $application['app_referees'] = json_encode($data['app_referees']);
  $return['status'] = TRUE;
  $return['data'] = $application;

  return $return;

}

function loanApplicationSchedule(){
  $data = inputAllGet();

  $loanData = $this->loansModel->loan($data['app_loan']);

  if(!$loanData){
    $return['status'] = FALSE;
    $return['data'] = 'You must select Loan Product';
    return $return;
  }

  $appDate = date('Y-m-d',strtotime($data['app_date']));
  $dateend = date('Y-m-d',strtotime($data['app_date']));

  switch ($loanData->loan_term) {
    case 'days':
      $dateend = strtotime(date("Y-m-d", strtotime($appDate)) . " +".$loanData->loan_term_count." days");
      $dateend = date('Y-m-d',$dateend);
      $dateDiff = date_difference_absolute($appDate,$dateend);
      $days = $dateDiff['days'];
      break;
    case 'weeks':
      $dateend = strtotime(date("Y-m-d", strtotime($appDate)) . " +".$loanData->loan_term_count." weeks");
      $dateend = date('Y-m-d',$dateend);
      $dateDiff = date_difference_absolute($appDate,$dateend);
      $days = $dateDiff['days'];
      break;
    case 'months':
      $dateend = strtotime(date("Y-m-d", strtotime($appDate)) . " +".$loanData->loan_term_count." months");
      $dateend = date('Y-m-d',$dateend);
      $dateDiff = date_difference_absolute($appDate,$dateend);
      $days = $dateDiff['days'];
      break;
    case 'years':
        $dateend = strtotime(date("Y-m-d", strtotime($appDate)) . " +".$loanData->loan_term_count." years");
        $dateend = date('Y-m-d',$dateend);
        $dateDiff = date_difference_absolute($appDate,$dateend);
        $days = $dateDiff['days'];
        break;
    default:
      $days = 1;
      break;
  }

  switch ($loanData->loan_payment_schedule) {
    case 'daily':
      $cycle = 1;
      break;
    case 'weekly':
      $cycle = 7;
      break;
    case 'monthly':
      $cycle = 30;
      break;
    case 'yearly':
        $cycle = 365;
        break;
    default:
      $cycle = 1;
      break;
  }

  $installments = floor($days/$cycle);

  $return['dateend'] = $dateend;
  $return['datestart'] = $appDate;
  $return['days'] = $days;
  $return['cycle'] = $cycle;
  $return['installments'] = $installments;
  return $return;

}

function loanUpdateApplicationSchedule(){
  $data = inputAllGet();

  $loanData = $this->loansModel->loan($data['app_loan']);

  if(!$loanData){
    $return['status'] = FALSE;
    $return['data'] = 'You must select Loan Product';
    return $return;
  }

  $appDate = date('Y-m-d',strtotime($data['app_date']));
  $dateend = date('Y-m-d',strtotime($data['app_date']));

  switch ($data['app_term']) {
    case 'days':
      $dateend = strtotime(date("Y-m-d", strtotime($appDate)) . " +".$data['app_term_count']." days");
      $dateend = date('Y-m-d',$dateend);
      $dateDiff = date_difference_absolute($appDate,$dateend);
      $days = $dateDiff['days'];
      break;
    case 'weeks':
      $dateend = strtotime(date("Y-m-d", strtotime($appDate)) . " +".$data['app_term_count']." weeks");
      $dateend = date('Y-m-d',$dateend);
      $dateDiff = date_difference_absolute($appDate,$dateend);
      $days = $dateDiff['days'];
      break;
    case 'months':
      $dateend = strtotime(date("Y-m-d", strtotime($appDate)) . " +".$data['app_term_count']." months");
      $dateend = date('Y-m-d',$dateend);
      $dateDiff = date_difference_absolute($appDate,$dateend);
      $days = $dateDiff['days'];
      break;
    case 'years':
        $dateend = strtotime(date("Y-m-d", strtotime($appDate)) . " +".$data['app_term_count']." years");
        $dateend = date('Y-m-d',$dateend);
        $dateDiff = date_difference_absolute($appDate,$dateend);
        $days = $dateDiff['days'];
        break;
    default:
      $days = 1;
      break;
  }

  switch ($data['app_schedule']) {
    case 'daily':
      $cycle = 1;
      break;
    case 'weekly':
      $cycle = 7;
      break;
    case 'monthly':
      $cycle = 30;
      break;
    case 'yearly':
        $cycle = 365;
        break;
    default:
      $cycle = 1;
      break;
  }

  $installments = floor($days/$cycle);

  $return['dateend'] = $dateend;
  $return['datestart'] = $appDate;
  $return['days'] = $days;
  $return['cycle'] = $cycle;
  $return['installments'] = $installments;
  return $return;

}

public function delete($flag,$key) {
      if (!$this->input->is_ajax_request())
       exit('not direct script allowed');
        switch ($flag) {
            case 'loan':
            if($this->loansModel->delete($key)){
                      $result['status'] = 'ok';
                      $result['message'] = 'Loan deleted';
                    }else{
                      $result['status'] = 'no';
                      $result['message'] = checkError($this->dbexeption());
                    }
              print json_encode($result);
            break;
            case 'charge':
            if($this->loansModel->deleteCharge($key)){
                      $result['status'] = 'ok';
                      $result['message'] = 'Charge deleted';
                    }else{
                      $result['status'] = 'no';
                      $result['message'] = checkError($this->dbexeption());
                    }
              print json_encode($result);
            break;
            default:
              $result['status'] = 'no';
              $result['message'] = 'No action';
               print json_encode($result);
            break;
        }
    }

  function datasource(){
    $data = $alldata = $this->loansModel->applications();
    $this->sourcedata($data);
  }


}
