<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
* Description of Dashboard
*
* @author test
*/

class Index extends MY_Controller{

  public  $pagedata;

  public function __construct() {
    parent::__construct();
    $this->require_min_level(1);
    $this->pagedata['link']= 'accounting';
    $this->pagedata['title'] = 'Postings | '.$this->config->item('application_name');
    $this->load->model(array(
        'accounting/accounting'=>'accountingModel',
        'accounting/GeneralLedgerModel'=>'generalLedgerModel'
    ));
  }
 
  public function index() {
    $this->pagedata['hash']= '';
    $this->pagedata['title'] = 'Postings | '.$this->config->item('application_name');
    $this->load->vars($this->pagedata);
    $this->load->view('accounting/postings/postings');
  }

  function filtered($hash="") {
    $this->pagedata['title'] = 'Postings - '.$hash.' | '.$this->config->item('application_name');
    $this->pagedata['link']= 'accounting';
    $this->pagedata['hash']= $hash;
    $this->load->vars($this->pagedata);
    $this->load->view('accounting/postings/postings');
  }

  function datasource($hash =''){
    $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
      if(!empty($hash)){
          $postings = $this->generalLedgerModel->where(array("gl_category" => $hash,"gl_status" => "PENDING"))->find_all();
      }else{
          $postings = $this->generalLedgerModel->where(array("gl_status" => "PENDING"))->find_all();
      }


      $columns = array();
    foreach ($this->generalLedgerModel->selectable_fields as $field){
        $columns[$field] = TRUE;
    }
    print $this->datasourceLibrary->server($postings,$columns);
}

  function datasourcebin($hash=''){
    $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
    $this->generalLedgerModel->where('gl_deleted',1);
      if(!empty($hash)){
          $postings = $this->generalLedgerModel->with_deleted()->find_many_by(["gl_category" => $hash]);
      }else{
          $postings = $this->generalLedgerModel->with_deleted()->find_all();
      }
    $columns = array();
    foreach ($this->generalLedgerModel->selectable_fields as $field){
        $columns[$field] = TRUE;
    }
    print $this->datasourceLibrary->server($postings,$columns);
}



}
