<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
* Description of Dashboard
*
* @author test
*/

class Overview extends MY_Controller{

  public  $pagedata;

  public function __construct() {
    parent::__construct();
    ( $this->require_min_level(1));
    $this->pagedata['link']= 'accounting';
    $this->load->helper('accounting/journals/helper');
    $this->load->model(array(
        'accounting/accounting'=>'accountingModel',
        'accounting/JournalsModel'=>'journalsModel'
    ));
  }
 
  public function index() {
    $this->pagedata['title'] = 'Journals | '.$this->config->item('application_name');
    $this->pagedata['types'] = $this->accountingModel->accountTypes();
    $this->pagedata['rules'] = $this->accountingModel->accountingRules();
    $this->load->vars($this->pagedata);
    $this->load->view('accounting/journals/overview');
  }

    function datasource($when=''){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $sales = $this->journalsModel->journals($when);
        $columns = [
            'j_id' => true,
            'j_key' => true,
            'j_title' => true,
            'gl_date' => true,
            'gl_activity' => true,
            'account_name' => true,
            'account_code' => true,
            'account_id' => true,
            'gl_credit' => true,
            'gl_debit' => true,
            'gl_category' => true,
            'gl_status' => true,
        ];
        print $this->datasourceLibrary->server($sales,$columns);
    }

    function datasourceloans($when=''){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $sales = $this->journalsModel->journalsLoans($when);
        $columns = [
            'j_id' => true,
            'j_key' => true,
            'j_title' => true,
            'gl_date' => true,
            'gl_activity' => true,
            'account_name' => true,
            'account_code' => true,
            'account_id' => true,
            'gl_credit' => true,
            'gl_debit' => true,
            'gl_category' => true,
            'gl_status' => true,
            'gl_loan_app_install_number' => true,
        ];
        print $this->datasourceLibrary->server($sales,$columns);
    }

    function datasourceexpenses($when=''){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $sales = $this->journalsModel->journalsExpenses($when);
        $columns = [
            'expense_payee' => true,
            'j_id' => true,
            'j_key' => true,
            'j_title' => true,
            'gl_date' => true,
            'gl_activity' => true,
            'account_name' => true,
            'account_code' => true,
            'account_id' => true,
            'gl_credit' => true,
            'gl_debit' => true,
            'gl_category' => true,
            'gl_status' => true,
        ];
        print $this->datasourceLibrary->server($sales,$columns);
    }

    function datasourcegeneral($when=''){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $sales = $this->journalsModel->journalsGeneral($when);
        $columns = [
            'j_id' => true,
            'j_key' => true,
            'j_title' => true,
            'gl_date' => true,
            'gl_activity' => true,
            'account_name' => true,
            'account_code' => true,
            'account_id' => true,
            'gl_credit' => true,
            'gl_debit' => true,
            'gl_category' => true,
            'gl_status' => true,
        ];
        print $this->datasourceLibrary->server($sales,$columns);
    }

}