<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
* Description of Dashboard
*
* @author Kelvin Benard
*/

class Index extends MY_Controller{

  public  $pagedata;

  public function __construct() {
    parent::__construct();
    $this->require_min_level(1);
    $this->pagedata['link']= 'accounting';
    $this->load->helper('accounting/journals/helper');
    $this->load->model(array(
          'accounting/accounting'=>'accountingModel',
          'accounting/JournalsModel'=>'journalsModel'
      ));
  }
 
   public function index() {
    $this->pagedata['title'] = 'Journals | '.$this->config->item('application_name');
    $this->load->vars($this->pagedata);
    $this->load->view('accounting/journals/journals');
  }

   public function create() {
       $this->load->helper('reports/accounting/helper');
       $this->load->model(array(
           'taxes/TaxesModel'=>'taxesModel',
           'accounting/JournalItemsModel'=>'journalItemsModel'
       ));

       if($this->tokens->match) {
           $this->db->trans_start();
           $journal = array(
               'journal_date' => date('Y-m-d H:i:s', strtotime($this->input->post('journal_date', TRUE))),
               'journal_status' => $this->input->post('journal_status',TRUE),
               'journal_type' => $this->input->post('journal_type', TRUE),
               'journal_title' => $this->input->post('journal_title', TRUE)
           );

           $journalId = $this->journalsModel->insert($journal);
           $journal = $this->journalsModel->find_by(['journal_id' => $journalId]);
           if(!empty($items = $this->input->post('group_items'))){
               $this->load->model(array('accounting/GeneralLedgerModel'=>'generalLedgerModel'));
               foreach ($items as $item){
                   $itemData['journal_item'] = $item['journal_item'];
                   $itemData['journal_item_details'] = $item['journal_item_details'];
                   $itemData['journal_item_qty'] = $item['journal_item_qty'];
                   $itemData['journal_item_debit_account'] = $item['journal_item_debit_account'];
                   $itemData['journal_item_credit_account'] = $item['journal_item_credit_account'];
                   $itemData['journal_item_price'] = to_dollar(toNumber($item['journal_item_price']));
                   $itemData['journal_item_total'] = to_dollar(toNumber($item['journal_item_total']));
                   $itemData['journal_item_journal'] = $journal['journal_key'];
                   $this->journalItemsModel->insert($itemData);
                   $itemData['journal_item_date'] = $journal['journal_date'];
                   if(strtolower($journal['journal_status']) != 'draft') {
                       $this->postPaymentLedger($journal, $this->input->post('journal_type', TRUE), $itemData);
                   }
               }
           }
           $this->db->trans_complete();
           if ($this->db->trans_status() === TRUE) {
               $this->pagedata['form_action'] = TRUE;
               $this->pagedata['form_message'] = "Congratulation! Journal created successfully";
               $this->pagedata['form_class'] = "success";
           } else {
               $this->pagedata['form_action'] = FALSE;
               $this->pagedata['form_message'] = "We could not process request successfully please try again later";
               $this->pagedata['form_class'] = "danger";
           }
       }

    $this->load->helper('form');
    $this->pagedata['title'] = 'Create Journal | '.$this->config->item('application_name');
    $this->pagedata['types'] = $this->accountingModel->accountTypes();
    $this->pagedata['rules'] = $this->accountingModel->accountingRules();
    $this->load->vars($this->pagedata);
    $this->load->view('accounting/journals/create');
   }

   public function modify($key) {
        $this->load->model(array(
            'taxes/TaxesModel'=>'taxesModel',
            'accounting/JournalItemsModel'=>'journalItemsModel'
        ));

        if($this->tokens->match) {

            $journal = $this->journalsModel->find($key);
            if(strtolower($journal['journal_status']) != "approved"){
                $this->db->trans_start();
                $journal = array(
                    'journal_date' => date('Y-m-d H:i:s', strtotime($this->input->post('journal_date', TRUE))),
                    'journal_status' => $this->input->post('journal_status',TRUE),
                    'journal_type' => $this->input->post('journal_type', TRUE),
                    'journal_title' => $this->input->post('journal_title', TRUE)
                );

                $this->journalsModel->update($key,$journal);

                $business = runningBusiness()->business_key;
                $branch = runningBranch()->branch_key;

                $this->journalItemsModel->where('journal_item_business',$business);
                $this->journalItemsModel->where('journal_item_branch',$branch);
                $this->journalItemsModel->soft_delete(FALSE);
                $this->journalItemsModel->delete_by(['journal_item_journal' => $key]);

                $this->load->model(array('accounting/GeneralLedgerModel'=>'generalLedgerModel'));
                $business = runningBusiness()->business_key;
                $branch = runningBranch()->branch_key;
                $this->generalLedgerModel->soft_delete(FALSE);
                $this->generalLedgerModel->where('gl_business',$business);
                $this->generalLedgerModel->where('gl_branch',$branch);
                $this->generalLedgerModel->delete_by(['gl_activity' => $key,'gl_category' => 'JOURNALS']);

                if(!empty($items = $this->input->post('group_items'))){
                    foreach ($items as $item){
                        $itemData['journal_item'] = $item['journal_item'];
                        $itemData['journal_item_details'] = $item['journal_item_details'];
                        $itemData['journal_item_qty'] = $item['journal_item_qty'];
                        $itemData['journal_item_debit_account'] = $item['journal_item_debit_account'];
                        $itemData['journal_item_credit_account'] = $item['journal_item_credit_account'];
                        $itemData['journal_item_price'] = to_dollar(toNumber($item['journal_item_price']));
                        $itemData['journal_item_total'] = to_dollar(toNumber($item['journal_item_total']));
                        $itemData['journal_item_journal'] = $key;
                        $this->journalItemsModel->insert($itemData);
                        $itemData['journal_item_date'] = $journal['journal_date'];
                        if(strtolower($journal['journal_status']) != 'draft') {
                            $this->postPaymentLedger($key,$this->input->post('journal_category', TRUE),$itemData);
                        }

                    }
                }

                $this->db->trans_complete();
                if ($this->db->trans_status() === TRUE) {
                    $this->pagedata['form_action'] = TRUE;
                    $this->pagedata['form_message'] = "Congratulation! Journal updated successfully";
                    $this->pagedata['form_class'] = "success";
                } else {
                    $this->pagedata['form_action'] = FALSE;
                    $this->pagedata['form_message'] = "We could not process request successfully please try again later";
                    $this->pagedata['form_class'] = "danger";
                }
            }else{
                $this->pagedata['form_action'] = FALSE;
                $this->pagedata['form_message'] = "We could not process request successfully please try again later";
                $this->pagedata['form_class'] = "danger";
            }

        }

        $this->load->helper('form');
        $this->pagedata['title'] = 'Journal Modification| '.$this->config->item('application_name');
        $this->pagedata['journal'] = $this->journalsModel->find($key);
        $this->pagedata['items'] = $this->journalItemsModel->find_many_by(['journal_item_journal' => $key]);
        $this->load->vars($this->pagedata);
        $this->load->view('accounting/journals/modify');
    }

   public function details($key) {
       $this->load->library(array('qrcode/Qrcodes'=>'qrcodes'));
        $this->load->model(array(
            'taxes/TaxesModel'=>'taxesModel',
            'accounting/JournalItemsModel'=>'journalItemsModel'
        ));

        $this->load->helper('form');
        $this->pagedata['title'] = 'Journal details | '.$this->config->item('application_name');
        $this->pagedata['journal'] = $this->journalsModel->with_deleted()->find($key);
        $this->pagedata['items'] = $this->journalItemsModel->find_many_by(['journal_item_journal' => $key]);
        $this->load->vars($this->pagedata);
        $this->load->view('accounting/journals/details');
    }

   function datasource(){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->journalsModel->find_all();
        $columns = array();
        foreach ($this->journalsModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($data,$columns);
    }

   function datasourcebin(){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $this->journalsModel->where('journal_deleted',1);
        $data = $this->journalsModel->with_deleted()->find_all();
        $columns = array();
        foreach ($this->journalsModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($data,$columns);
    }

   function restore($key=''){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        $business = runningBusiness()->business_key;
        $branch = runningBranch()->branch_key;
        $this->load->model(array('invoices/InvoiceTransactionsModel' => 'invoiceTransactionsModel'));

        $this->journalsModel->where('journal_business',$business);
        $this->journalsModel->where('journal_branch',$branch);
        if($this->journalsModel->update($key,['journal_deleted' => 0])){

            $results['message'] = 'Journal restored successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to restore Journal';
            $results['status'] = false;
        }


        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }

   function delete($key=''){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        $business = runningBusiness()->business_key;
        $branch = runningBranch()->branch_key;

       $journal = $this->journalsModel->find($key);
       if(strtolower($journal['journal_status']) != "approved"){
           $this->journalsModel->where('journal_business',$business);
           $this->journalsModel->where('journal_branch',$branch);
           if($this->journalsModel->delete($key)){
               $results['message'] = 'Journal deleted successfully';
               $results['status'] = true;
           }else{
               $results['message'] = 'Failed to delete Journal';
               $results['status'] = false;
           }
       }else{
           $results['message'] = 'Failed to delete Journal';
           $results['status'] = false;
       }



        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }

   function postPaymentLedger($journal,$category,$data){

        $ledgerDebit['gl_account'] = $data['journal_item_debit_account'];
        $ledgerDebit['gl_debit'] = $data['journal_item_total'];
        $ledgerDebit['gl_amount'] = $data['journal_item_total'];
        $ledgerDebit['gl_date'] = $data['journal_item_date'];
        $ledgerDebit['gl_status'] = "PENDING";
        $ledgerDebit['gl_type'] = $category;
        $ledgerDebit['gl_category'] = "JOURNALS";
        $ledgerDebit['gl_activity'] = $journal['journal_key'];
        $ledgerDebit['gl_details'] = $journal['journal_title'];
        $ledgerDebit['gl_reference'] = $journal['journal_key'];
        $id =$this->generalLedgerModel->insert($ledgerDebit);
        $balance['gl_balance'] = accountBalance($ledgerDebit['gl_account']);
        $this->generalLedgerModel->update_by(['gl_id'=> $id],$balance);

        $ledgerCredit['gl_account'] = $data['journal_item_credit_account'];
        $ledgerCredit['gl_credit'] = $data['journal_item_total'];
        $ledgerCredit['gl_amount'] = $data['journal_item_total'];
        $ledgerCredit['gl_reference'] = $journal['journal_key'];
        $ledgerCredit['gl_details'] = $journal['journal_title'];
        $ledgerCredit['gl_date'] = $data['journal_item_date'];
        $ledgerCredit['gl_status'] = "PENDING";
        $ledgerCredit['gl_type'] = $category;
        $ledgerCredit['gl_category'] = "JOURNALS";
        $ledgerCredit['gl_activity'] = $journal['journal_key'];
        $id =$this->generalLedgerModel->insert($ledgerCredit);
        $balance['gl_balance'] = accountBalance($ledgerCredit['gl_account']);
        $this->generalLedgerModel->update_by(['gl_id'=> $id],$balance);

    }
}
