<?php

defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Description of Dashboard
 *
 * @author
 */

class Transactions extends MY_Controller{

    public  $pagedata;

    public function __construct() {
        parent::__construct();
        $this->require_min_level(1);
        $this->pagedata['link']= 'accounting';
        $this->load->model(array(
            'accounting/accounting'=>'accountingModel',
            'accounting/GlModel'=>'glModel',
            'accounting/GeneralLedgerModel'=>'generalLedgerModel'
        ));
    }

    public function index() {
        $this->pagedata['title'] = 'General Ledger | '.$this->config->item('application_name');
        $this->load->vars($this->pagedata);
        $this->load->view('accounting/transactions/transactions');
    }

    function datasource(){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $transactions = $this->generalLedgerModel->find_all();
        $columns = array();
        foreach ($this->generalLedgerModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }

        print $this->datasourceLibrary->server($transactions,$columns);
    }

    function datasourcebin(){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $this->generalLedgerModel->where('gl_deleted',1);
        $transactions = $this->generalLedgerModel->with_deleted()->find_all();
        $columns = array();
        foreach ($this->generalLedgerModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($transactions,$columns);
    }

    function restoreledger($key=''){

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $business = runningBusiness()->business_key;
        $branch = runningBranch()->branch_key;

        $this->load->model(array('invoices/InvoiceTransactionsModel' => 'invoiceTransactionsModel'));
        $this->load->model(array('accounting/JournalsModel'=>'journalsModel'));
        $this->load->model(array('expenses/ExpensesModel'=>'expenseModel'));

        $ledger = $this->generalLedgerModel->with_deleted()->find($key);

        $this->generalLedgerModel->where('gl_business',$business);
        $this->generalLedgerModel->where('gl_branch',$branch);

        if($this->generalLedgerModel->update_by(['gl_activity' => $ledger['gl_activity']],['gl_deleted' => 0])){

            $this->journalsModel->where('journal_business',$business);
            $this->journalsModel->where('journal_branch',$branch);
            $this->journalsModel->update($ledger['gl_activity'],['journal_deleted' => 0]);

            $this->invoiceTransactionsModel->where('inv_pay_business',$business);
            $this->invoiceTransactionsModel->where('inv_pay_branch',$branch);
            $this->invoiceTransactionsModel->update($ledger['gl_activity'],['inv_pay_deleted' => 0]);

            $this->expenseModel->where('expense_business',$business);
            $this->expenseModel->where('expense_branch',$branch);
            $this->expenseModel->update($ledger['gl_activity'],['expense_deleted' => 0]);

            $results['message'] = 'Record restored successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to restore Record';
            $results['status'] = false;
        }


        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }

    function approveledger($key=''){

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $business = runningBusiness()->business_key;
        $branch = runningBranch()->branch_key;

        $this->load->model(array('invoices/InvoiceTransactionsModel' => 'invoiceTransactionsModel'));
        $this->load->model(array('accounting/JournalsModel'=>'journalsModel'));
        $this->load->model(array('expenses/ExpensesModel'=>'expenseModel'));

        $ledger = $this->generalLedgerModel->with_deleted()->find($key);

        $this->generalLedgerModel->where('gl_business',$business);
        $this->generalLedgerModel->where('gl_branch',$branch);

        if($this->generalLedgerModel->update_by(['gl_activity' => $ledger['gl_activity']],['gl_status' => 'APPROVED'])){

            $this->journalsModel->where('journal_business',$business);
            $this->journalsModel->where('journal_branch',$branch);
            $this->journalsModel->update($ledger['gl_activity'],['	journal_status' => 'APPROVED']);

            $this->invoiceTransactionsModel->where('inv_pay_business',$business);
            $this->invoiceTransactionsModel->where('inv_pay_branch',$branch);
            $this->invoiceTransactionsModel->update($ledger['gl_activity'],['inv_pay_post_status' => 1]);

            $this->expenseModel->where('expense_business',$business);
            $this->expenseModel->where('expense_branch',$branch);
            $this->expenseModel->update($ledger['gl_activity'],['expense_is_posted' => 1]);

            $results['message'] = 'Record restored successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to restore Record';
            $results['status'] = false;
        }


        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }

    function pendingledger($key=''){

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $business = runningBusiness()->business_key;
        $branch = runningBranch()->branch_key;

        $this->load->model(array('invoices/InvoiceTransactionsModel' => 'invoiceTransactionsModel'));
        $this->load->model(array('accounting/JournalsModel'=>'journalsModel'));
        $this->load->model(array('expenses/ExpensesModel'=>'expenseModel'));

        $ledger = $this->generalLedgerModel->with_deleted()->find($key);

        $this->generalLedgerModel->where('gl_business',$business);
        $this->generalLedgerModel->where('gl_branch',$branch);

        if($this->generalLedgerModel->update_by(['gl_activity' => $ledger['gl_activity']],['gl_status' => 'PENDING'])){

            $this->journalsModel->where('journal_business',$business);
            $this->journalsModel->where('journal_branch',$branch);
            $this->journalsModel->update($ledger['gl_activity'],['	journal_status' => 'PENDING']);

            $this->invoiceTransactionsModel->where('inv_pay_business',$business);
            $this->invoiceTransactionsModel->where('inv_pay_branch',$branch);
            $this->invoiceTransactionsModel->update($ledger['gl_activity'],['inv_pay_post_status' => 0]);

            $this->expenseModel->where('expense_business',$business);
            $this->expenseModel->where('expense_branch',$branch);
            $this->expenseModel->update($ledger['gl_activity'],['expense_is_posted' => 0]);

            $results['message'] = 'Record restored successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to restore Record';
            $results['status'] = false;
        }


        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }

    function deleteledger($key=''){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        $business = runningBusiness()->business_key;
        $branch = runningBranch()->branch_key;
        $this->load->model(array('invoices/InvoiceTransactionsModel' => 'invoiceTransactionsModel'));
        $this->load->model(array('accounting/JournalsModel'=>'journalsModel'));
        $this->load->model(array('expenses/ExpensesModel'=>'expenseModel'));
        $ledger = $this->generalLedgerModel->find($key);

        $this->generalLedgerModel->where('gl_business',$business);
        $this->generalLedgerModel->where('gl_branch',$branch);

        if($this->generalLedgerModel->delete_by(['gl_activity' => $ledger['gl_activity']])){

            $this->journalsModel->where('journal_business',$business);
            $this->journalsModel->where('journal_branch',$branch);
            $this->journalsModel->delete($ledger['gl_activity']);

            $this->invoiceTransactionsModel->where('inv_pay_business',$business);
            $this->invoiceTransactionsModel->where('inv_pay_branch',$branch);
            $this->invoiceTransactionsModel->delete($ledger['gl_activity']);

            $this->expenseModel->where('expense_business',$business);
            $this->expenseModel->where('expense_branch',$branch);
            $this->expenseModel->delete($ledger['gl_activity']);

            $results['message'] = 'Record deleted successfully';
            $results['status'] = true;

        }else{
            $results['message'] = 'Failed to delete Record';
            $results['status'] = false;
        }


        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }

    function printrecord($record){
        $gl = $this->glModel->gl($record);
        if(!empty($gl)){
            switch (strtolower($gl->gl_type)){
                case 'increase':
                    $this->pagedata['gl'] = $gl;
                    $this->pagedata['account'] = $this->accountingModel->account($gl->gl_account);
                    $this->load->vars($this->pagedata);
                    $output = $this->load->view('accounting/print_templates/account_increase_default',$this->pagedata,TRUE);
                    print $output;
                    break;
                case 'decrease':
                    $this->pagedata['gl'] = $gl;
                    $this->pagedata['account'] = $this->accountingModel->account($gl->gl_account);
                    $this->load->view('accounting/record_details/account_decrease','',$gl);
                    break;
            }
        }else{
            print "<h3>We could not find a record</h3>";
        }
    }

}
