<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
* Description of Dashboard
*
* @author test
*/

class Index extends MY_Controller{

  public  $pagedata;

  public function __construct() {
      parent::__construct();
      $this->require_min_level(1);
      $this->pagedata['link']= 'accounting';
      $this->load->model(array('accounting/accounting'=>'accountingModel'));
  }

  public function index() {
    $this->pagedata['title'] = 'Accounting | '.$this->config->item('application_name');
    $this->pagedata['types'] = $this->accountingModel->accountTypes();
    $this->pagedata['rules'] = $this->accountingModel->accountingRules();
    $this->load->vars($this->pagedata);
    $this->load->view('accounting/accounting');
  }

  public function newaccount() {
    // if(!$this->input->is_ajax_request())
    //   exit('no cirect script allowed');

      $account = $this->collectAccount();
      if($this->accountingModel->newaccount($account)):
            $result['status'] = 'ok';
            $result['message'] = 'Account created successfull';
          else:
            $result['status'] = 'no';
            $result['message'] = 'System was un able to complete ation at the moment, Try again after a while, contact support';
      endif;

       print json_encode($result);
  }

  public function details($acc='') {
    $this->pagedata['title'] = 'Account Details| '.$this->config->item('application_name');
    $this->pagedata['types'] = $this->accountingModel->accountTypes();
    $this->pagedata['rules'] = $this->accountingModel->accountingRules();
    $this->pagedata['account'] = $this->accountingModel->account($acc);
    $this->load->vars($this->pagedata);
    $this->load->view('accounting/accountDetails');
  }

  public function modify($acc='') {
    $this->pagedata['types'] = $this->accountingModel->accountTypes();
    $this->pagedata['rules'] = $this->accountingModel->accountingRules();
    $this->pagedata['account'] = $this->accountingModel->account($acc);
    $this->load->vars($this->pagedata);
    $this->load->view('employee/accounting/accountModify');
  }

  public function modifyaction($acc='') {
    if(!$this->input->is_ajax_request()){
      exit('no direct script allowed');
    }
      $account = $this->collectAccount();
        if($this->accountingModel->updateAccount($acc,$account)):
            $result['status'] = 'ok';
            $result['message'] = 'Account updated successfull';
          else:
            $result['status'] = 'no';
            $result['message'] = 'System was un able to complete ation at the moment, Try again after a while, contact support';
      endif;
       print json_encode($result);
  }

  function deleteselected(){
    $rawids = $this->input->get('data');
    if(!empty($rawids)){
      $this->db->trans_start();
      foreach ($rawids as $y => $row) {
        $this->accountingModel->deleteAccount($row);
      }

      $this->db->trans_complete();
      if($this->db->trans_status() == TRUE){
        $result['status'] = 'ok';
        $result['message'] = 'Congratulations! You have successifully Deleted Account(S)';
        $result['type'] = 'success';
      }else{
        $result['status'] = 'no';
        $result['message'] = 'Unfortunatelly, You request could not be completed';
        $result['type'] = 'warning';
      }
    }else{
      $result['status'] = 'no';
      $result['message'] = 'Please select Account(s) to delete';
      $result['type'] = 'warning';
    }
    echo json_encode( $result);
  }

  public function delete($flag,$key) {
    if(!$this->input->is_ajax_request()){
      exit('no direct script allowed');
    }
      switch ($flag) {
          case 'account':
          if($this->accountingModel->deleteAccount($key)){
                    $result['status'] = 'ok';
                    $result['message'] = 'Account deleted';
                  }else{
                    $result['status'] = 'no';
                    $result['message'] = checkError($this->dbexeption());
                  }
            print json_encode($result);
          break;
          default:
              print 'fail';
          break;
      }
  }

  function collectAccount(){
    $account['account_name'] = $this->input->get('account_name',TRUE);
    $account['account_type'] = $this->input->get('account_type',TRUE);
    $account['account_details'] = $this->input->get('account_details',TRUE);
    return $account;
  }

  function datasource(){
    $data =  $this->accountingModel->accounts();
    $columnsDefault = [
      'account_id'     => true,
      'account_name'     => true,
      'actype_name'  => true,
      'accountid'     => true,
      'account_bank'     => true,
      'bank_balance'    => true,
      'local_balance'    => true,
    ];
    $this->sourcedataserver($data,$columnsDefault);
  }


}
