<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Dashboard
 *
 * @author test
 */
class Taxes extends MY_Controller{

  public $pagedata;

  public function __construct() {
    parent::__construct();
    ($this->require_role('employee'));
    $this->pagedata['link']= 'taxes';
  }

  public function index() {
        $this->load->helper('form');
        $this->pagedata['title'] = 'Taxes | '.$this->config->item('application_name');
        $this->load->vars($this->pagedata);
        $this->load->view('employee/taxes/taxes');
    }

  public function classes() {
      $this->load->helper('form');
      $this->pagedata['title'] = 'Taxes | '.$this->config->item('application_name');
      $this->load->vars($this->pagedata);
      $this->load->view('employee/taxes/classes');
  }


  public function taxdetails($taxKey='') {
          $this->load->helper('form');
          if($this->tokens->match):
            $tax['tax_name'] = $this->input->post('tax_name', TRUE);
            $tax['tax_class'] = $this->input->post('tax_class', TRUE);
            $tax['tax_frequency'] = $this->input->post('tax_frequency', TRUE);
            $tax['tax_rate'] = $this->input->post('tax_rate', TRUE);
            $tax['tax_class'] = $this->input->post('tax_class', TRUE);
            $tax['tax_start_month'] = $this->input->post('tax_start_month', TRUE);
              if($this->taxesModel->updateTax($taxKey,$tax)):
                      $this->app_library->action_status('success','Tax updated successifully');
                  else:
                  $this->app_library->action_status('fail','Could not update tax');
              endif;
          endif;

          $this->pagedata['title'] = 'Tax details | '.$this->config->item('application_name');
          $this->pagedata['classes'] = $this->taxesModel->taxclasses();
          $this->pagedata['tax'] = $this->taxesModel->tax($taxKey);
          $this->load->vars($this->pagedata);
          $this->load->view('employee/taxes/taxdetails');
      }

      public function classdetails($classKey='') {
            $this->load->helper('form');
            if($this->tokens->match):
              $class['class_name'] = $this->input->post('class_name', TRUE);
              $class['class_description'] = $this->input->post('class_description', TRUE);
                if($this->taxesModel->updateClass($classKey,$class)):
                        $this->app_library->action_status('success','Class updated successifully');
                    else:
                    $this->app_library->action_status('fail','Could not update class');
                endif;
              endif;
            $this->pagedata['title'] = 'Class details | '.$this->config->item('application_name');
            $this->pagedata['class'] = $this->taxesModel->taxclass($classKey);
            $this->load->vars($this->pagedata);
            $this->load->view('employee/taxes/classdetails');
        }

    public function newtax() {
          $this->load->helper('form');
          if($this->tokens->match):
            $tax['tax_name'] = $this->input->post('tax_name', TRUE);
            $tax['tax_class'] = $this->input->post('tax_class', TRUE);
            $tax['tax_frequency'] = $this->input->post('tax_frequency', TRUE);
            $tax['tax_rate'] = $this->input->post('tax_rate', TRUE);
            $tax['tax_class'] = $this->input->post('tax_class', TRUE);
            $tax['tax_start_month'] = $this->input->post('tax_start_month', TRUE);
            if(!$this->taxesModel->checkPresence('taxes','tax_name',$tax['tax_name'])){
              if($this->taxesModel->newtax($tax)):
                      $this->app_library->action_status('success','Tax added successifully');
                  else:
                  $this->app_library->action_status('fail','Could not add tax');
              endif;
            }else{
              $this->app_library->action_status('fail','Tax name already used');
            }
          endif;

          $this->pagedata['title'] = 'New Tax | '.$this->config->item('application_name');
          $this->pagedata['classes'] = $this->taxesModel->taxclasses();
          $this->load->vars($this->pagedata);
          $this->load->view('employee/taxes/newtax');
      }

      public function newclass() {
            $this->load->helper('form');
            if($this->tokens->match):
              $class['class_name'] = $this->input->post('class_name', TRUE);
              $class['class_description'] = $this->input->post('class_description', TRUE);
              if(!$this->taxesModel->checkPresence('tax_classes','class_name',$class['class_name'])){
                if($this->taxesModel->newclass($class)):
                        $this->app_library->action_status('success','Class added successifully');
                    else:
                    $this->app_library->action_status('fail','Could not add class');
                endif;
              }else{
                $this->app_library->action_status('fail','Class name already used');
              }
            endif;

            $this->pagedata['title'] = 'New Class | '.$this->config->item('application_name');
            $this->load->vars($this->pagedata);
            $this->load->view('employee/taxes/newclass');
        }

    public function collection() {
       $this->load->model(array('owner_model'));
       $this->load->helper('form');
       $this->pagedata['link']= 'tax';

       $this->pagedata['title'] = 'Tax | '.$this->config->item('application_name');
       $this->pagedata['class_taxes'] = $this->owner_model->class_tax_get_details();
       $this->load->vars($this->pagedata);
       $this->load->view('owner/taxes_collection');
   }

     public function configs() {
        $this->load->model(array('owner_model'));
        $this->load->helper('form');
        $this->pagedata['link']= 'tax';

        $this->pagedata['title'] = 'Tax | '.$this->config->item('application_name');
        $this->pagedata['class_taxes'] = $this->owner_model->class_tax_get_details();
        $this->load->vars($this->pagedata);
        $this->load->view('owner/taxes_configuration');
    }

    public function classview($class_key=NULL) {
        $this->load->model(array('owner_model'));
        $this->load->helper('form');
        $this->pagedata['link']= 'tax';
        if($this->tokens->match):
                $user['class_name'] = $this->input->post('class_name', TRUE);
                if($this->owner_model->taxclass_update($class_key,$user)):
                        $this->owner_library->action_status('success','Updated successifully');
                else:
                    $this->owner_library->action_status('fail','Failed to be updated');
                endif;
        endif;

        $this->pagedata['title'] = 'Tax | '.$this->config->item('application_name');
        $this->pagedata['taxes'] = $this->owner_model->tax_get_details();
        $this->pagedata['class_taxes'] = $this->owner_model->tax_get_class_taxes($class_key);
        $this->pagedata['tax_class'] = $this->owner_model->taxclass_get_single_detail($class_key);
        $this->pagedata['get_class'] = $this->owner_model->taxclass_get_details();
        $this->load->vars($this->pagedata);
        $this->load->view('owner/taxes_classview');
    }

    public function taxes() {
        $this->load->model(array('owner_model'));
        $this->load->helper('form');
        $this->pagedata['link']= 'tax';
        if($this->tokens->match):
                $user['tax_name'] = $this->input->post('tax_name', TRUE);
                $user['tax_percentage'] = $this->input->post('tax_percentage', TRUE);
                if($this->owner_model->tax_create($user)):
                        $this->owner_library->action_status('success','Added successifully');
                    else:
                        $this->owner_library->action_status('fail','Could not be added');
                    endif;
        endif;

        $this->pagedata['title'] = 'Tax | '.$this->config->item('application_name');
        $this->pagedata['get_tax'] = $this->owner_model->tax_get_details();
        $this->load->vars($this->pagedata);
        $this->load->view('owner/taxes_taxes');
    }

    public function tax_updates($tax_key=NULL) {
        $this->load->model(array('owner_model'));
        $this->load->helper('form');
        $this->pagedata['link']= 'tax';
        if($this->tokens->match):
                $user['tax_name'] = $this->input->post('tax_name', TRUE);
                $user['tax_percentage'] = $this->input->post('tax_percentage', TRUE);
                if($this->owner_model->tax_update($tax_key,$user)):
                        $this->owner_library->action_status('success','Added successifully');
                    else:
                        $this->owner_library->action_status('fail','Could not be added');
                    endif;
        endif;

        $this->pagedata['title'] = 'Tax | '.$this->config->item('application_name');
        $this->pagedata['get_tax'] = $this->owner_model->tax_get_details();
        $this->pagedata['taxes'] = $this->owner_model->tax_get_single_detail($tax_key);
        $this->load->vars($this->pagedata);
        $this->load->view('owner/taxes_taxes_update');
    }

    public function delete($flag,$key) {
        switch ($flag) {
            case 'tax':
            if($this->taxesModel->deleteTax($key)){
                      $result['status'] = 'ok';
                      $result['message'] = 'Tax deleted';
                    }else{
                      $result['status'] = 'no';
                      $result['message'] = checkError($this->dbexeption());
                    }
              print json_encode($result);
            break;
            case 'class':
            if($this->taxesModel->deleteClass($key)){
                      $result['status'] = 'ok';
                      $result['message'] = 'Class deleted';
                    }else{
                      $result['status'] = 'no';
                      $result['message'] = checkError($this->dbexeption());
                    }
              print json_encode($result);
            break;
            default:
                print 'fail';
            break;
        }
    }

    function datasourcetaxes(){
    include dirname(APPPATH).'/resources/includes/lib/class-list-util.php';

    $data = $alldata = $this->taxesModel->taxes();

    $datatable = array_merge(['pagination' => [], 'sort' => [], 'query' => []], $_REQUEST);

    // search filter by keywords
    $filter = isset($datatable['query']['generalSearch']) && is_string($datatable['query']['generalSearch'])
      ? $datatable['query']['generalSearch'] : '';
    if ( ! empty($filter)) {
      $data = array_filter($data, function ($a) use ($filter) {
          return (boolean)preg_grep("/$filter/i", (array)$a);
      });
      unset($datatable['query']['generalSearch']);
    }

    // filter by field query
    $query = isset($datatable['query']) && is_array($datatable['query']) ? $datatable['query'] : null;
    if (is_array($query)) {
      $query = array_filter($query);
      foreach ($query as $key => $val) {
          $data = list_filter($data, [$key => $val]);
      }
    }

    $sort  = ! empty($datatable['sort']['sort']) ? $datatable['sort']['sort'] : 'asc';
    $field = ! empty($datatable['sort']['field']) ? $datatable['sort']['field'] : 'RecordID';

    $meta    = [];
    $page    = ! empty($datatable['pagination']['page']) ? (int)$datatable['pagination']['page'] : 1;
    $perpage = ! empty($datatable['pagination']['perpage']) ? (int)$datatable['pagination']['perpage'] : -1;

    $pages = 1;
    $total = count($data); // total items in array

    // sort
    usort($data, function ($a, $b) use ($sort, $field) {
      if ( ! isset($a->$field) || ! isset($b->$field)) {
          return false;
      }

      if ($sort === 'asc') {
          return $a->$field > $b->$field ? true : false;
      }

      return $a->$field < $b->$field ? true : false;
    });

    // $perpage 0; get all data
    if ($perpage > 0) {
      $pages  = ceil($total / $perpage); // calculate total pages
      $page   = max($page, 1); // get 1 page when $_REQUEST['page'] <= 0
      $page   = min($page, $pages); // get last page when $_REQUEST['page'] > $totalPages
      $offset = ($page - 1) * $perpage;
      if ($offset < 0) {
          $offset = 0;
      }

      $data = array_slice($data, $offset, $perpage, true);
    }

    $meta = [
      'page'    => $page,
      'pages'   => $pages,
      'perpage' => $perpage,
      'total'   => $total,
    ];

    // if selected all records enabled, provide all the ids
    if (isset($datatable['requestIds']) && filter_var($datatable['requestIds'], FILTER_VALIDATE_BOOLEAN)) {
      $meta['rowIds'] = array_map(function ($row) {
          foreach($row as $first) break;
          return $first;
      }, $alldata);
    }


    header('Content-Type: application/json');
    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
    header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

    $result = [
      'meta' => $meta + [
              'sort'  => $sort,
              'field' => $field,
          ],
      'data' => $data,
    ];

    echo json_encode($result, JSON_PRETTY_PRINT);
    }


    function datasourceclasses(){
    include dirname(APPPATH).'/resources/includes/lib/class-list-util.php';

    $data = $alldata = $this->taxesModel->taxclasses();

    $datatable = array_merge(['pagination' => [], 'sort' => [], 'query' => []], $_REQUEST);

    // search filter by keywords
    $filter = isset($datatable['query']['generalSearch']) && is_string($datatable['query']['generalSearch'])
      ? $datatable['query']['generalSearch'] : '';
    if ( ! empty($filter)) {
      $data = array_filter($data, function ($a) use ($filter) {
          return (boolean)preg_grep("/$filter/i", (array)$a);
      });
      unset($datatable['query']['generalSearch']);
    }

    // filter by field query
    $query = isset($datatable['query']) && is_array($datatable['query']) ? $datatable['query'] : null;
    if (is_array($query)) {
      $query = array_filter($query);
      foreach ($query as $key => $val) {
          $data = list_filter($data, [$key => $val]);
      }
    }

    $sort  = ! empty($datatable['sort']['sort']) ? $datatable['sort']['sort'] : 'asc';
    $field = ! empty($datatable['sort']['field']) ? $datatable['sort']['field'] : 'RecordID';

    $meta    = [];
    $page    = ! empty($datatable['pagination']['page']) ? (int)$datatable['pagination']['page'] : 1;
    $perpage = ! empty($datatable['pagination']['perpage']) ? (int)$datatable['pagination']['perpage'] : -1;

    $pages = 1;
    $total = count($data); // total items in array

    // sort
    usort($data, function ($a, $b) use ($sort, $field) {
      if ( ! isset($a->$field) || ! isset($b->$field)) {
          return false;
      }

      if ($sort === 'asc') {
          return $a->$field > $b->$field ? true : false;
      }

      return $a->$field < $b->$field ? true : false;
    });

    // $perpage 0; get all data
    if ($perpage > 0) {
      $pages  = ceil($total / $perpage); // calculate total pages
      $page   = max($page, 1); // get 1 page when $_REQUEST['page'] <= 0
      $page   = min($page, $pages); // get last page when $_REQUEST['page'] > $totalPages
      $offset = ($page - 1) * $perpage;
      if ($offset < 0) {
          $offset = 0;
      }

      $data = array_slice($data, $offset, $perpage, true);
    }

    $meta = [
      'page'    => $page,
      'pages'   => $pages,
      'perpage' => $perpage,
      'total'   => $total,
    ];

    // if selected all records enabled, provide all the ids
    if (isset($datatable['requestIds']) && filter_var($datatable['requestIds'], FILTER_VALIDATE_BOOLEAN)) {
      $meta['rowIds'] = array_map(function ($row) {
          foreach($row as $first) break;
          return $first;
      }, $alldata);
    }


    header('Content-Type: application/json');
    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
    header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

    $result = [
      'meta' => $meta + [
              'sort'  => $sort,
              'field' => $field,
          ],
      'data' => $data,
    ];

    echo json_encode($result, JSON_PRETTY_PRINT);
    }
}
