<?php

/**
 * Description of Dashboard
 *
 * @author Kelvin Benard
 */
class Payments extends MY_Controller{

    protected $pagedata;

    public function __construct() {
        parent::__construct();
        $this->require_min_level(1);
        $this->load->helper(array('payments/payments'));
        $this->load->model(array(
            'payments/PaymentsModel'=>'paymentsModel',
            'payments/PaymentsRequestItemsModel'=>'paymentItems'
        ));
        $this->load->library(array('qrcode/Qrcodes'=>'qrcodes'));
    }

    public function index() {
        $this->pagedata['hash']= '';
        $this->pagedata['link']= 'payments';
        $this->pagedata['title'] = 'Payments | '.$this->config->item('application_name');
        $this->load->vars($this->pagedata);
        $this->load->view('payments/index');
    }

    public function items() {
        if($this->tokens->match){

            $data['item_name'] = $this->input->post('item_name',true);
            $item_key = $this->input->post('item_key',true);

            if($this->input->post('action') == "create" && $this->paymentItems->insert($data)){
                $this->appdata['status'] = TRUE;
                $this->appdata['message'] = "Congratulation! Request created successfully";
            }

            if($this->input->post('action') == "update" && $this->paymentItems->update($item_key,$data)){
                $this->appdata['status'] = TRUE;
                $this->appdata['message'] = "Congratulation! Request update successfully";
            }

            if($this->input->post('action') == "delete" && $this->paymentItems->delete($item_key)){
                $this->appdata['status'] = TRUE;
                $this->appdata['message'] = "Congratulation! Request deleted successfully";
            }


        }
        $this->load->helper('form');
        $this->pagedata['hash']= '';
        $this->pagedata['link']= 'payments';
        $this->pagedata['title'] = 'Payment Items | '.$this->config->item('application_name');
        $this->load->vars($this->pagedata);
        $this->load->view('payments/items');
    }

    public function filtered($status = "pending") {
        $this->pagedata['hash']= '';
        $this->pagedata['hash']= $status;
        $this->pagedata['title'] = 'Payments | '.$this->config->item('application_name');
        $this->load->vars($this->pagedata);
        $this->load->view('payments/index');
    }


    function export(){
        $business = runningBusiness()->business_key;
        $start = $this->input->post('start',TRUE);
        $end = $this->input->post('end',TRUE);
        if(empty($start))
            $start = date('Y-m-d');
        if(empty($end))
            $end = date('Y-m-d');

        if(strtolower($this->input->post('status',TRUE)) != 'all')
            $this->db->where('request_status',strtolower($this->input->post('status',TRUE)));
        $query = $this->db->where('request_date >=',$start)->where('request_date <=',$end)->where('request_business',$business)->join('payments_requests','request_key=request_data_item_request','both')->get('payments_data_items');
        if($query->num_rows()>0){

            $this->load->library(array('Ssheet'=>'sheet'));
            $meta['author'] = config_item('app_name');
            $meta['title'] = config_item('app_name');
            $meta['subject'] = config_item('app_name');
            $meta['description'] = config_item('app_name');
            $meta['keywords'] = "Report";
            $meta['filename'] = $this->input->post('filename',TRUE).".xlsx";
            $meta['filepath'] = APPPATH.'/';
            $meta['category'] = "Lockminds, Freight, Accounting, Payroll, Expense Manager, HR, Invoices";

            $dataArray = array();
            foreach ($query->result_array() as $key => $val){
                $requester = profile($val['request_requester']);
                $client = profile($val['request_client']);
                $dataArray[$key] = [
                        $requester->firstname.' '.$requester->lastname,
                        $client->firstname.' '.$client->lastname,
                        $val['request_project'],
                        $val['request_date'],
                        $val['request_data_item_reason'],
                        $val['request_data_item_other_reason'],
                        $val['request_data_item_qty'],
                        to_money($val['request_data_item_price']),
                        to_money($val['request_data_item_sub_total']),
                        to_money($val['request_amount']),
                        to_money($val['request_paid']),
                        to_money($val['request_balance']),
                        strtoupper($val['request_status']),
                        strtoupper($val['request_retired'])
                ];
            }

            $this->sheet->createFile($meta,$dataArray);

            //Check the file exists or not
            if(file_exists(dirname(APPPATH)).'/'.$meta['filename']) {

                //Define header information
                header('Content-Description: File Transfer');
                header('Content-Type: application/octet-stream');
                header("Cache-Control: no-cache, must-revalidate");
                header("Expires: 0");
                header('Content-Disposition: attachment; filename="'.basename($meta['filename']).'"');
                header('Content-Length: ' . filesize($meta['filename']));
                header('Pragma: public');

                //Clear system output buffer
                                flush();

                //Read the size of the file
                                readfile($meta['filename']);

                //Terminate from the script
                $result['status'] = true;
                $result['message'] = "Successfully, Your report will be downloaded automatically";
            }else{
                $result['status'] = false;
                $result['message'] = "failed to complete your request";
            }

        } else{

            print '<h1>We could not find data to export</h1>';
            print '<a href="'.base_url('payments').'">return</a>';
            exit;
        }

        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        echo json_encode($result,JSON_PRETTY_PRINT);
        exit();

    }

    function transactions($hash="") {
        $this->load->helper('form');
        $this->appdata['link']= 'payments';
        $this->appdata['hash']= $hash;
        $this->load->vars($this->appdata);
        $this->load->view('payments/transactions');
    }

    function create() {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

//        if(isAjax())
//            exit('no direct script allowed');

        $this->load->model(array('taxes/taxesModel' => 'taxesModel','accounting/accounting' => 'accountingModel'));

        $this->db->trans_start();

        if(empty($this->input->post('request_receiver',TRUE))){
            $receiver_raw = profile($this->input->post('request_requester',TRUE));
            $receiver = $receiver_raw->firstname.' '.$receiver_raw->lastname;
        }else{
            $receiver = $this->input->post('request_receiver',TRUE);
        }



        $invoice = array(
            'request_requester' => $this->input->post('request_requester',TRUE),
            'request_payment_details' => $this->input->post('request_payment_details',TRUE),
            'request_project' => $this->input->post('request_project',TRUE),
            'request_receiver' => $receiver,
            'request_client' => $this->input->post('request_client',TRUE),
            'request_date' => date('Y-m-d H:i:s', strtotime($this->input->post('request_date', TRUE))),
            'request_status' => "pending",
            'request_amount' => to_dollar(toNumber($this->input->post('request_amount', TRUE))),
            'request_balance' => to_dollar(toNumber($this->input->post('request_amount', TRUE))),
            'request_paid' => 0,
            'request_payment_mode' => $this->input->post('request_payment_mode', TRUE),
        );

        $uploadPath = uploadPath('payments/');
        $config['upload_path'] = $uploadPath;
        $config['file_ext_tolower']     = TRUE;
        $config['encrypt_name']         = TRUE;
        $config['allowed_types'] = 'jpg|jpeg|png|docx|doc|pdf|xls|xlsx';

        // Load and initialize upload library
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        $i  = 0;
        if($this->upload->do_upload('file')){
            // Uploaded file data
            $fileData = $this->upload->data();
            $invoice['doc_name'] = $fileData['file_name'];
            $invoice['doc_type'] = $fileData['file_type'];
            $invoice['doc_ext'] = str_ireplace('.', '',$fileData['file_ext']);
        }
        $this->paymentsModel->insert($invoice);
        $invoiceKey = $this->paymentsModel->insert_key;
        if(!empty($items = $this->input->post('group_items'))){
            foreach ($items as $item){
                $itemData['request_data_item_currency'] = $item['request_item_currency'];
                $itemData['request_data_item_reason'] = $item['request_reason'];
                $itemData['request_data_item_other_reason'] = $item['request_other_reason'];
                $itemData['request_data_item_qty'] = $item['request_item_qty'];
                $itemData['request_data_item_price'] = to_dollar(toNumber($item['request_item_price']));
                $itemData['request_data_item_sub_total'] = to_dollar(toNumber($item['request_item_sub_total']));
                $itemData['request_data_item_request'] = $invoiceKey;
                $this->db->insert('payments_data_items',$itemData);
            }
        }


        $this->db->trans_complete();
        if ($this->db->trans_status() === TRUE) {
            $this->appdata['status'] = TRUE;
            $this->appdata['message'] = "Congratulation! Request created successfully";
        } else {
            $this->appdata['status'] = FALSE;
            $this->appdata['message'] = "We could not process request successfully please try again later";
        }

        echo json_encode($this->appdata, JSON_PRETTY_PRINT);

    }

    function details($key='') {
        $this->appdata['hash']= '';
        $this->appdata['link']= 'payments';
        $this->appdata['title'] = 'Payments | '.$this->config->item('application_name');
        $this->load->helper('form');
        $this->appdata['request']= $this->paymentsModel->find($key);
        $this->appdata['items']= $this->paymentsModel->items($this->appdata['request']['request_key']);
        $this->load->vars($this->appdata);
        $this->load->view('payments/details');
    }

    function payments($key='') {

        if(!empty($this->input->post("del",TRUE)) && $this->input->post("del",TRUE) == 'yes'){
            $business = runningBusiness()->business_key;
            $branch = runningBranch()->branch_key;
            $this->paymentTransactionsModel->where('request_pay_request',$this->input->post("inv",TRUE));
            $this->paymentTransactionsModel->where('request_pay_business',$business);
            $this->paymentTransactionsModel->where('request_pay_branch',$branch);
            $this->paymentTransactionsModel->delete($this->input->post("id",TRUE));
        }

        if(!empty($this->input->post("ush",true)) && $this->input->post("ush",true) == 'yes'){
            $flag = $this->paymentTransactionsModel->find($this->input->post("id",TRUE));
            if(strtolower($flag['request_pay_post_status']) == "draft"){
                $business = runningBusiness()->business_key;
                $branch = runningBranch()->branch_key;
                $this->paymentTransactionsModel->where('request_pay_request',$this->input->post("inv",TRUE));
                $this->paymentTransactionsModel->where('request_pay_business',$business);
                $this->paymentTransactionsModel->where('request_pay_branch',$branch);
                if($this->paymentTransactionsModel->update($this->input->post("id",TRUE),['request_pay_post_status' => "PENDING"])){
                    $payment = $this->paymentTransactionsModel->find($this->input->post("id",TRUE));
                    $invoice = $this->paymentsModel->find($this->input->post("inv",TRUE));
                    $this->load->model(array('accounting/GeneralLedgerModel'=>'generalLedgerModel'));
                    $this->generalLedgerModel->soft_delete(FALSE);
                    $this->generalLedgerModel->where('gl_business',$business);
                    $this->generalLedgerModel->where('gl_branch',$branch);
                    $this->generalLedgerModel->delete_by(['gl_activity' => $invoice,'gl_category' => 'INVOICES']);
                    $this->getPaymentLedger($payment,$invoice);
                }
            }

        }

        $this->load->model(array('taxes/taxesModel' => 'taxesModel','accounting/accounting' => 'accountingModel','payments/PaymentsTransactionsModel' => 'paymentTransactionsModel'));
        $this->load->helper('form');
        $this->appdata['title']= "Payments";
        $this->appdata['request']= $this->paymentsModel->find($key);
        $this->appdata['payments']= $this->paymentTransactionsModel->find_many_by(["request_pay_request" => $key]);
        $this->load->vars($this->appdata);
        $this->load->view('payments/payments');
    }

    function postpayment($pay)
    {
        $this->load->model(array('payments/PaymentsTransactionsModel' => 'paymentTransactionsModel'));
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        $business = runningBusiness()->business_key;
        $branch = runningBranch()->branch_key;
        $this->paymentTransactionsModel->where('request_pay_business',$business);
        $this->paymentTransactionsModel->where('request_pay_branch',$branch);
        if( $this->paymentTransactionsModel->update($pay,['request_pay_post_status' => "PENDING"])){
            $payment = $this->paymentTransactionsModel->find($pay);
            $invoice = $this->paymentsModel->find($payment['request_pay_request']);
            $this->getPaymentLedger($payment,$invoice);
            $results['message'] = 'Payment Posted successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to Post Payment';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function restorepayment($pay)
    {
        $this->load->model(array('payments/PaymentsTransactionsModel' => 'paymentTransactionsModel'));
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        $business = runningBusiness()->business_key;
        $branch = runningBranch()->branch_key;
        $this->paymentTransactionsModel->where('request_pay_business',$business);
        $this->paymentTransactionsModel->where('request_pay_branch',$branch);
        if( $this->paymentTransactionsModel->update($pay,['request_pay_deleted' => 0])){
            $results['message'] = 'Payment Restored successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to Restore Payment';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function deletepaymentforever($pay)
    {
        $this->load->model(array('payments/PaymentsTransactionsModel' => 'paymentTransactionsModel'));
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        $business = runningBusiness()->business_key;
        $branch = runningBranch()->branch_key;
        $this->paymentTransactionsModel->where('request_pay_business',$business);
        $this->paymentTransactionsModel->where('request_pay_branch',$branch);
        $this->paymentTransactionsModel->soft_delete(FALSE);
        if( $this->paymentTransactionsModel->delete($pay)){
            $results['message'] = 'Payment Deleted successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to Delete Payment';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function deletepayment($pay)
    {
        $this->load->model(array('payments/PaymentsTransactionsModel' => 'paymentTransactionsModel'));
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        $business = runningBusiness()->business_key;
        $branch = runningBranch()->branch_key;
        $this->paymentTransactionsModel->where('request_pay_business',$business);
        $this->paymentTransactionsModel->where('request_pay_branch',$branch);

        if( $this->paymentTransactionsModel->delete($pay)){
            $results['message'] = 'Payment Deleted successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to Delete Payment';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function modify($key='') {
        if($this->tokens->match) {
            $this->db->trans_start();

            if(empty($this->input->post('request_receiver',TRUE))){
                $receiver_raw = profile($this->input->post('request_requester',TRUE));
                $receiver = $receiver_raw->firstname.' '.$receiver_raw->lastname;
            }else{
                $receiver = $this->input->post('request_receiver',TRUE);
            }
            $invoice = array(
                'request_requester' => $this->input->post('request_requester',TRUE),
                'request_payment_details' => $this->input->post('request_payment_details',TRUE),
                'request_project' => $this->input->post('request_project',TRUE),
                'request_receiver' => $receiver,
                'request_client' => $this->input->post('request_client',TRUE),
                'request_date' => date('Y-m-d H:i:s', strtotime($this->input->post('request_date', TRUE))),
                'request_status' => "pending",
                'request_amount' => to_dollar(toNumber($this->input->post('request_amount', TRUE))),
                'request_payment_mode' => $this->input->post('request_payment_mode', TRUE),
            );
            $uploadPath = uploadPath('payments/');
            $config['upload_path'] = $uploadPath;
            $config['file_ext_tolower']     = TRUE;
            $config['encrypt_name']         = TRUE;
            $config['allowed_types'] = 'jpg|jpeg|png|docx|doc|pdf|xls|xlsx';

            // Load and initialize upload library
            $this->load->library('upload', $config);
            $this->upload->initialize($config);
            $i  = 0;
            if($this->upload->do_upload('file')){
                // Uploaded file data
                $fileData = $this->upload->data();
                $invoice['doc_name'] = $fileData['file_name'];
                $invoice['doc_type'] = $fileData['file_type'];
                $invoice['doc_ext'] = str_ireplace('.', '',$fileData['file_ext']);
            }
            $this->paymentsModel->update($key,$invoice);
            if(!empty($items = $this->input->post('group_items'))){
                $this->db->where('request_data_item_request',$key);
                $this->db->delete('payments_data_items');
                foreach ($items as $item){
                    $itemData['request_data_item_currency'] = $item['request_item_currency'];
                    $itemData['request_data_item_reason'] = $item['request_reason'];
                    $itemData['request_data_item_other_reason'] = $item['request_other_reason'];
                    $itemData['request_data_item_qty'] = $item['request_item_qty'];
                    $itemData['request_data_item_price'] = to_dollar(toNumber($item['request_item_price']));
                    $itemData['request_data_item_sub_total'] = to_dollar(toNumber($item['request_item_sub_total']));
                    $itemData['request_data_item_request'] = $key;
                    $this->db->insert('payments_data_items',$itemData);
                }
            }

            $request = (object) $this->paymentsModel->find($key);
            $this->paymentsModel->update_balance($request);

            $this->db->trans_complete();
            if ($this->db->trans_status() === TRUE) {
                $this->appdata['form_action'] = TRUE;
                $this->appdata['form_message'] = "Congratulation! Invoice updated successfully";
                $this->appdata['form_class'] = "success";
            } else {
                $this->appdata['form_action'] = FALSE;
                $this->appdata['form_message'] = "We could not process request successfully please try again later";
                $this->appdata['form_class'] = "danger";
            }
        }
        $this->load->helper('form');
        $this->appdata['request'] = $this->paymentsModel->find($key);
        $this->appdata['items']= $this->paymentsModel->items($this->appdata['request']['request_key']);
        $this->appdata['link']= 'payments';
        $this->appdata['title'] = 'Payments | '.$this->config->item('application_name');
        $this->load->vars($this->appdata);
        $this->load->view('payments/modify');
    }

    function datasource($hash=''){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        if(!empty($hash)){
            $invocies = $this->paymentsModel->order_by('request_created_on','DESC')->find_many_by(["request_status" => $hash]);
        }else{
            $invocies = $this->paymentsModel->order_by('request_created_on','DESC')->find_all();
        }

        $columns = array();
        foreach ($this->paymentsModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($invocies,$columns);
    }

    function datasourcebin($hash=''){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        if(!empty($hash)){
            $this->paymentsModel->where('request_deleted',1);
            $invocies = $this->paymentsModel->with_deleted()->find_many_by(["request_status" => $hash]);
        }else{
            $this->paymentsModel->where('request_deleted',1);
            $invocies = $this->paymentsModel->with_deleted()->find_all();
        }

        $columns = array();
        foreach ($this->paymentsModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($invocies,$columns);
    }

    function sourcetransactions(){
        $this->load->model(array('payments/PaymentsTransactionsModel' => 'paymentTransactionsModel'));
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $transactions = $this->paymentTransactionsModel->find_all();
        $columns = array();
        foreach ($this->paymentTransactionsModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($transactions,$columns);
    }

    function sourcetransactionsbin(){
        $this->load->model(array('payments/PaymentsTransactionsModel' => 'paymentTransactionsModel'));
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $this->paymentTransactionsModel->where('request_pay_deleted',1);
        $transactions = $this->paymentTransactionsModel->with_deleted()->find_all();
        $columns = array();
        foreach ($this->paymentTransactionsModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($transactions,$columns);
    }

    function delete($inv)
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');


        $business = runningBusiness()->business_key;
        $branch = runningBranch()->branch_key;
        $this->paymentsModel->where('request_business',$business);
        $this->paymentsModel->where('request_branch',$branch);
        if($this->paymentsModel->delete($inv)){
            $this->load->model(array('payments/PaymentsTransactionsModel' => 'paymentTransactionsModel'));
            $this->paymentTransactionsModel->delete_by(['request_pay_request' => $inv]);
            $results['message'] = 'Invoice deleted successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to delete Invoice';
            $results['status'] = false;
        }


        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function deleteinvforever($inv)
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if(invoiceIsDeletable($inv)){
            $business = runningBusiness()->business_key;
            $branch = runningBranch()->branch_key;
            $this->paymentsModel->where('request_business',$business);
            $this->paymentsModel->where('request_branch',$branch);
            $this->paymentsModel->soft_delete(FALSE);
            if($this->paymentsModel->delete($inv)){
                $this->load->model(array('payments/PaymentsTransactionsModel' => 'paymentTransactionsModel'));
                $this->paymentTransactionsModel->soft_delete(FALSE);
                $this->paymentTransactionsModel->delete_by(['request_pay_request' => $inv]);
                $results['message'] = 'Invoice deleted successfully';
                $results['status'] = true;
            }else{
                $results['message'] = 'Failed to delete Invoice';
                $results['status'] = false;
            }
        }else{
            $results['message'] = 'You can not delete Invoice as it has been posted into General Ledger';
            $results['status'] = false;
        }


        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function paynow()
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if( $this->paymentsModel->update($this->input->post('key',TRUE),['request_status'=>'paid','request_paid' => to_dollar($this->input->post('amount',TRUE))])){
            $results['message'] = 'Request dennie successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to Restore Payment';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function approve($pay)
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        $business = runningBusiness()->business_key;
        $branch = runningBranch()->branch_key;
        $this->paymentsModel->where('request_business',$business);
        $this->paymentsModel->where('request_branch',$branch);
        if( $this->paymentsModel->update($pay,['request_status' => "approved"])){
            $results['message'] = 'Request approved successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to Restore Payment';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function retire($pay)
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        $business = runningBusiness()->business_key;
        $branch = runningBranch()->branch_key;
        $this->paymentsModel->where('request_business',$business);
        $this->paymentsModel->where('request_branch',$branch);
        if( $this->paymentsModel->update($pay,['request_retired' => "YES"])){
            $results['message'] = 'Request approved successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to Restore Payment';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function dennie()
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        $business = runningBusiness()->business_key;
        $branch = runningBranch()->branch_key;
        $this->paymentsModel->where('request_business',$business);
        $this->paymentsModel->where('request_branch',$branch);
        if( $this->paymentsModel->update($this->input->post('key',TRUE),['request_status' => "denied",'request_cancel_reason'=>$this->input->post('reason',TRUE)])){
            $results['message'] = 'Request dennie successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to Restore Payment';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function restore($pay)
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        $business = runningBusiness()->business_key;
        $branch = runningBranch()->branch_key;
        $this->paymentsModel->where('request_business',$business);
        $this->paymentsModel->where('request_branch',$branch);
        if( $this->paymentsModel->update($pay,['request_deleted' => 0])){
            $this->load->model(array('payments/PaymentsTransactionsModel' => 'paymentTransactionsModel'));
            $this->paymentTransactionsModel->where('request_pay_business',$business);
            $this->paymentTransactionsModel->where('request_pay_branch',$branch);
            $this->paymentTransactionsModel->update_by(['request_pay_request' => $pay],['request_pay_deleted' => 0]);

            $results['message'] = 'Request Restored successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to Restore Payment';
            $results['status'] = false;
        }


        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function clearpayments($key){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        $this->db->trans_start();
        $this->db->where('request_pay_request',$key);
        $this->db->delete('payments_requests_payments');
        $this->db->where('gl_activity',$key);
        $this->db->delete('accounting_general_ledger');
        $request = (object) $this->paymentsModel->find($key);
        $this->paymentsModel->update_balance($request);

        $this->db->trans_complete();
        if($this->db->trans_status() === TRUE){
            $results['message'] = 'Payment added successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to add Payment';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);

    }

    function addpayment()
    {

        $this->load->model(array('payments/PaymentsTransactionsModel' => 'paymentTransactionsModel'));
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $business = runningBusiness()->business_key;
        $branch = runningBranch()->branch_key;
        $request = (object) $this->paymentsModel->find($this->input->post('request_pay_request', TRUE));

        if(round(to_money($request->request_balance)) < toNumber($this->input->post('request_pay_amount', TRUE))){
            $results['message'] = 'Amount to pay can not be greater than '.number_format(round(to_money($request->request_balance)));
            $results['status'] = false;
            echo json_encode($results, JSON_PRETTY_PRINT);
            exit();
        }


        $payments = array(
            'request_pay_business' => $business,
            'request_pay_branch' => $branch,
            'request_pay_request' => $request->request_key,
            'request_pay_details' => $this->input->post('request_pay_details', TRUE),
            'request_pay_method' => $this->input->post('request_pay_method', TRUE),
            'request_pay_reference' => $this->input->post('request_pay_reference', TRUE),
            'request_pay_amount' => to_dollar(toNumber($this->input->post('request_pay_amount', TRUE)))
        );

        $this->db->trans_start();
        $this->paymentTransactionsModel->insert($payments);
        $this->paymentsModel->update_balance($request);
        $this->db->trans_complete();

        if($this->db->trans_status() === TRUE){
            $results['message'] = 'Payment added successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to add Payment';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);

    }

    function postPaymentLedger($payment,$request){

        $this->load->helper('reports/accounting/helper');
        $this->load->model(array('accounting/GeneralLedgerModel'=>'generalLedgerModel'));

        $ledgerDebit['gl_account'] = $this->input->post('debit_account',TRUE);
        $ledgerDebit['gl_debit'] = $payment['request_pay_amount'];
        $ledgerDebit['gl_amount'] = $payment['request_pay_amount'];
        $ledgerDebit['gl_date'] = $payment['request_pay_date'];
        $ledgerDebit['gl_status'] = "APPROVED";
        $ledgerDebit['gl_category'] = "PAYMENT REQUEST";
        $ledgerDebit['gl_type'] = "PAYMENT REQUEST";
        $ledgerDebit['gl_reference'] = $payment['request_pay_reference'];
        $ledgerDebit['gl_details'] = $payment['request_pay_details'];
        $ledgerDebit['gl_activity'] = $request->request_key;
        $id = $this->generalLedgerModel->insert($ledgerDebit);
        $balance['gl_balance'] = accountBalance($ledgerDebit['gl_account']);
        $this->generalLedgerModel->update_by(['gl_id'=> $id],$balance);

        $ledgerCredit['gl_account'] = $this->input->post('crdit_account',TRUE);
        $ledgerCredit['gl_credit'] = $payment['request_pay_amount'];
        $ledgerCredit['gl_date'] = $payment['request_pay_date'];
        $ledgerCredit['gl_status'] = "APPROVED";
        $ledgerCredit['gl_category'] = "PAYMENT REQUEST";
        $ledgerCredit['gl_type'] = "PAYMENT REQUEST";
        $ledgerCredit['gl_reference'] = $payment['request_pay_reference'];
        $ledgerCredit['gl_details'] = $payment['request_pay_details'];
        $ledgerCredit['gl_activity'] = $request->request_key;
        $ledgerCredit['gl_amount'] = $payment['request_pay_amount'];
        $id = $this->generalLedgerModel->insert($ledgerCredit);
        $balance['gl_balance'] = accountBalance($ledgerCredit['gl_account']);
        $this->generalLedgerModel->update_by(['gl_id'=> $id],$balance);

    }

    function get_client_projects($key){
        $query = $this->db->where("fr_client",$key)->get('freights');
        if($query->num_rows()>0){
            $data = $query->result_array(); ?>
            <select class="form-control select" required name="request_project">
                <option value="">Select Option</option>
                <?php
                foreach ($data as $key => $value) {?>
                    <option value="<?= $value['fr_key']?>"><?= $value['fr_key'] ?></option>
                <?php }
                ?>
            </select>
            <script>
                $('select.select').select2({placeholder: "Select Option"});
            </script>
        <?php }else{
            print '<div class="alert alert-danger">Client has no project yet</div>';
        }
    }



}
