<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Dashboard
 *
 * @author test
 */
class Liabilities extends MY_Controller{

    public  $appdata;

    public function __construct() {
        parent::__construct();

        ( $this->require_role('owner'));

        $this->load->model('owner_model');
        $this->load->library('owner_library');
        $this->load->helper('owner');
        $this->appdata['userdata'] = profile();

    }

    public function index() {
        $this->load->helper('form');
        $this->appdata['link']= 'liabilities';
        $this->appdata['get_link'] = 'history';
        $this->appdata['liabilities'] = $this->owner_model->liabilities();
        $this->appdata['title'] = 'Liabilities | '.$this->config->item('application_name');
        $this->appdata['category'] = $this->owner_model->liability_category_get_details();
        $this->load->vars($this->appdata);
        $this->load->view('owner/liabilities');
    }
        public function categoryadd() {
        $this->load->model('owner_model');
        $this->appdata['link']= 'liabilities';
        $this->appdata['get_link']= 'category';
        $this->load->helper('form');
        if($this->tokens->match):
            $user['category_name'] = $this->input->post('category_name', TRUE);
            if($this->owner_model->liability_category_create($user)):
                $this->owner_library->action_status('success','Added successifully');
            else:
                $this->owner_library->action_status('fail','Could not be added');
            endif;
        endif;
        
        $this->appdata['title'] = 'Liability | '.$this->config->item('application_name');
        $this->appdata['category'] = $this->owner_model->liability_category_get_details();
        $this->load->vars($this->appdata);
        $this->load->view('owner/liabilities_category');
    }
    
    public function categoryupdates($category_key=Null ) {
        $this->load->model('owner_model');
        $this->load->helper('form');
        $this->appdata['link']= 'liabilities';
        $this->appdata['get_link']= 'category';
        if($this->tokens->match):
            $user['category_name'] = $this->input->post('category_name', TRUE);
            if($this->owner_model->liability_category_update($category_key,$user)):
                $this->owner_library->action_status('success','Updated successifully');
            else:
                $this->owner_library->action_status('fail','Could not be updated');
            endif;
        endif;
        
        $this->appdata['title'] = 'Liability | '.$this->config->item('application_name');
        $this->appdata['get_cat'] = $this->owner_model->liability_category_get_single_detail($category_key);
        $this->appdata['category'] = $this->owner_model->liability_category_get_details();
        $this->load->vars($this->appdata);
        $this->load->view('owner/liabilities_category_update');
    }
    
    public function bills() {
        $this->load->helper('form');
        $this->appdata['link']= 'liabilities';
        $this->appdata['get_link'] = 'bills';
        $this->appdata['liabilities'] = $this->owner_model->liabilities_bills();
        $this->appdata['title'] = 'Liabilities | '.$this->config->item('application_name');
        $this->load->vars($this->appdata);
        $this->load->view('owner/liabilities');
    }
    
    public function salary() {
        $this->load->helper('form');
        $this->appdata['link']= 'liabilities';
        $this->appdata['get_link'] = 'salary';
        $this->appdata['liabilities'] = $this->owner_model->liabilities_salary();
        $this->appdata['title'] = 'Liabilities | '.$this->config->item('application_name');
        $this->load->vars($this->appdata);
        $this->load->view('owner/liabilities');
    }
    
    public function damages() {
        $this->load->helper('form');
        $this->appdata['link']= 'liabilities';
        $this->appdata['get_link'] = 'damages';
        $this->appdata['liabilities'] = $this->owner_model->liabilities_damages();
        $this->appdata['title'] = 'Liabilities | '.$this->config->item('application_name');
        $this->load->vars($this->appdata);
        $this->load->view('owner/liabilities');
    }
    
    public function others() {
        $this->load->helper('form');
        $this->appdata['link']= 'liabilities';
        $this->appdata['get_link'] = 'others';
        $this->appdata['liabilities'] = $this->owner_model->liabilities_others();
        $this->appdata['title'] = 'Liabilities | '.$this->config->item('application_name');
        $this->load->vars($this->appdata);
        $this->load->view('owner/liabilities');
    }
    
    public function liabilityupdates($key=NULL) {
        $this->load->helper('form');
        $this->appdata['link']= 'liabilities';
        if($this->tokens->match):
            $user['li_date'] = $this->input->post('li_date', TRUE);
            $user['li_type'] = $this->input->post('li_type', TRUE);
            $user['li_amount'] = $this->input->post('li_amount', TRUE);
            $user['li_item'] = $this->input->post('li_item', TRUE);
            $user['li_description'] = $this->input->post('li_description', TRUE);
            if($this->owner_model->liability_update($key,$user)):
                $this->owner_library->action_status('success','Updated successifully');
            else:
                $this->owner_library->action_status('fail','Could not be updated');
            endif;
        endif;
        $this->appdata['liabilities'] = $this->owner_model->liabilities();
        $this->appdata['liability'] = $this->owner_model->liability($key);
        $this->appdata['category'] = $this->owner_model->liability_category_get_details();
        $this->appdata['title'] = 'Liabilities | '.$this->config->item('application_name');
        $this->load->vars($this->appdata);
        $this->load->view('owner/liabilities_update');
    }
    
    public function liabilityReload() {
        $this->load->helper('form');
        $liabilities = $this->owner_model->liabilities();
        ?>
             <table class="table" id="liabilities-table">
               <thead>
                 <tr>
                   <th>Date</th> 
                   <th>Type</th>
                   <th>Description</th>
                   <th>Amount</th>
                   <th>Action</th>
                 </tr>
               </thead>
               <tbody>
                 <?php if(! empty($liabilities)){
                   foreach( $liabilities as $li){?>
                     <tr id="key-<?php echo $li['li_key'];?>"><tr>
                       <td><?php echo date('d-m-Y',strtotime($li['li_date']));?></td>
                       <td><?php echo $li['li_type'];?></td>
                       <td><?php echo $li['li_description'];?></td>
                       <td><?php echo number_format($li['li_amount']);?></td>
                       <td><a href="<?php echo base_url('owner/liabilities/liabilityupdates/'.$li['li_key']);?>">View</a> | <a href="javascript:(0);" class="text-danger delete-liability" data-key="<?php echo $li['li_key'];?>">Delete</a></td>
                     </tr>
                   <?php }
                 } ?>
              </tbody>
            </table>
<script>
    $(".delete-liability").each (function(){
           $(this).click(function(){
              var key = $(this).data('key');
              swal({
                  title:"Are you sure?",
                  text:"You won't be able to revert this!",
                  type:"warning",
                  confirmButtonClass: "btn-danger btn",
                  showCancelButton:!0,
                  confirmButtonText: "Yes, Delete it",
              }).then(function(e){
                  if(e.value){
                      $.ajax({
                          url: '<?php echo base_url('owner/liabilities/delete/liability/')?>'+key,
                          type: 'get',
                          beforeSend: function(){
                              mApp.block("#liabilities-table",{
                                      overlayColor:"#000000", 
                                      type:"loader",
                                      state:"danger",
                                      message:"Deleting liability entrry..."
                                  });
                            },
                           success: function(result){
                                   if( result == 'ok'){
                                       $('tr#key-'+key).css('display','none');
//                                       window.location.reload();
                                   }
                                   mApp.unblock('#liabilities-table');
                               },
                            error: function(){
                                mApp.unblock('#liabilities-table');
                                }
                      });
                  }
              });
           });
       });
</script>    
<?php
    }
    
    public function delete($flag,$key) {
        switch ($flag) {
            case 'liability':
            if($this->owner_model->liability_delete($key)){
                print 'ok';
            }
            break;
            case 'category':
            if($this->owner_model->liability_category_delete($key)){
                print 'ok';
            }
            break;
            default:                
                print 'fail';
                break;
        } 
    }

}
