<?php


class Commonajax extends MY_Controller{

    public function __construct() {
        parent::__construct();
        $this->require_min_level(1);
    }

    function setCurrency(){
        $this->load->helper('form');
        $this->load->view('/commonajax/set_currency');
    }

    function setcurrencyaction(){
        if(empty($this->currenceModel)){
            $this->load->model("CurrenciesModel");
        }
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        $profile = profileSimple();
        $currency = explode('-',$this->input->get('bs_currency'));
        $this->db->where('bs_business',$profile->user_business);
        $this->db->delete('business_currency');
        $data['bs_key'] = $this->CurrenciesModel->currencyKey();
        $data['bs_business'] = $profile->user_business;
        $data['bs_currency'] = $currency[0];
        $data['bs_code'] = trim($currency[1]);
        $data['bs_symbol'] = trim($currency[1]);
        $data['bs_conversion'] = str_ireplace(',','',$this->input->get('bs_conversion'));
        $this->db->insert('business_currency',$data);
        if($this->db->affected_rows()>0){
            $results['status'] = true;
            $results['message'] = 'Currency has been set';
        }else{
            $results['status'] = false;
            $results['message'] = 'We could not complete your request';
        }

        echo json_encode($results, JSON_PRETTY_PRINT);

    }
    
    function customersjson(){
        $data = array();
        if(!empty($customers = customers())){
            foreach ($customers as $key => $customer){
                $data[$key]['name'] = $customer['firstname'].' '.$customer['middlename'].' '.$customer['lastname'];
                $data[$key]['image'] = uploadFilePath('/profile_pictures/').$customer['avatar'];
                $data[$key]['phonenumber'] = $customer['phonenumber'];
                $data[$key]['category'] = $customer['group_name'];
                $data[$key]['email'] = $customer['email'];
                $data[$key]['remarks'] = $customer['remarks'];
                $data[$key]['user_id'] = $customer['user_id'];
            }
        }

        print json_encode($data);
    }

    function searchcustomersjson(){
        $q = $this->input->get('q',TRUE);
        if(empty($q))
            return;
        $parts = explode(" ",$q);
        $branch = runningBranch()->branch_key;
        $business = runningBusiness()->business_key;
        $this->db->where('user_branch',$branch);
        $this->db->where('user_business',$business);
        if(count($parts) == 1){
            $this->db->like('firstname',$parts[0],'none');
        }

        if(count($parts) == 2){
            $this->db->like('firstname',$parts[0],'%');

            $this->db->or_like('middlename',$parts[1],'%');
        }

        if(count($parts) == 3){
            $this->db->like('firstname',$parts[0],'%');

            $this->db->or_like('lastname',$parts[1],'%');

            $this->db->or_like('lastname',$parts[2],'%');
        }

        $this->db->or_like('company_name',$q,'%');
        $this->db->or_like('middlename',$q,'%');
        $this->db->or_like('lastname',$q,'%');
        $this->db->or_like('firstname',$q,'%');

        $query = $this->db
            ->join('users_details','users_details.user_key=users.user_id','both')
            ->join('customer_groups','customer_groups.group_key=users.user_group','both')
            ->get( 'users' );
        $customers=  $query->result_array();
        
        if(!empty($customers)){
            foreach ($customers as $key => $customer){
                $data[$key]['name'] = $customer['company_name'].' '.$customer['firstname'].' '.$customer['middlename'].' '.$customer['lastname'];
                $data[$key]['image'] = uploadFilePath('/profile_pictures/').$customer['avatar'];
                $data[$key]['phonenumber'] = $customer['phonenumber'];
                $data[$key]['category'] = $customer['group_name'];
                $data[$key]['email'] = $customer['email'];
                $data[$key]['remarks'] = $customer['remarks'];
                $data[$key]['user_id'] = $customer['user_id'];
                $data[$key]['address'] = $customer['address'];
            }
        }

        print json_encode($data);
    }
    
}