-- MySQL Script generated by MySQL Workbench
-- Thu Apr 16 16:54:43 2020
-- Model: New Model    Version: 1.0
-- MySQL Workbench Forward Engineering

SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION';

-- -----------------------------------------------------
-- Table `bms_freight_plans`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `bms_freight_plans` (
  `fr_plan_id` INT(10) NOT NULL,
  `fr_plan_key` INT(10) UNSIGNED NULL,
  `fr_plan_created_on` DATETIME NULL,
  `fr_plan_created_by` INT(10) UNSIGNED NULL,
  `fr_plan_modified_on` DATETIME NULL,
  `fr_plan_modified_by` INT(10) UNSIGNED NULL,
  `fr_plan_deleted` TINYINT NULL DEFAULT 0,
  `fr_plan_deleted_by` INT(10) UNSIGNED NULL,
  `fr_plan_branch` INT(10) UNSIGNED NULL,
  `fr_plan_business` INT(10) UNSIGNED NULL,
  `fr_plan_name` VARCHAR(100) NULL,
  PRIMARY KEY (`fr_plan_id`),
  UNIQUE INDEX `id_UNIQUE` (`fr_plan_id` ASC),
  UNIQUE INDEX `plan_key_UNIQUE` (`fr_plan_key` ASC))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `bms_countries`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `bms_countries` (
  `country_id` INT(10) NOT NULL,
  `country_key` INT(10) UNSIGNED NULL,
  `country_created_on` DATETIME NULL,
  `country_created_by` INT(10) UNSIGNED NULL,
  `country_modified_on` DATETIME NULL,
  `country_modified_by` INT(10) UNSIGNED NULL,
  `country_deleted` TINYINT NULL DEFAULT 0,
  `country_deleted_by` INT(10) UNSIGNED NULL,
  `country_branch` INT(10) UNSIGNED NULL,
  `country_business` INT(10) UNSIGNED NULL,
  `country_name` VARCHAR(100) NULL,
  PRIMARY KEY (`country_id`),
  UNIQUE INDEX `id_UNIQUE` (`country_id` ASC),
  UNIQUE INDEX `country_key_UNIQUE` (`country_key` ASC))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `bms_freight_categories`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `bms_freight_categories` (
  `fr_category_id` INT(10) NOT NULL,
  `fr_category_key` INT(10) UNSIGNED NULL,
  `fr_category_created_on` DATETIME NULL,
  `fr_category_created_by` INT(10) UNSIGNED NULL,
  `fr_category_modified_on` DATETIME NULL,
  `fr_category_modified_by` INT(10) UNSIGNED NULL,
  `fr_category_deleted` TINYINT NULL DEFAULT 0,
  `fr_category_deleted_by` INT(10) UNSIGNED NULL,
  `fr_category_branch` INT(10) UNSIGNED NULL,
  `fr_category_business` INT(10) UNSIGNED NULL,
  `fr_category_name` VARCHAR(100) NULL,
  PRIMARY KEY (`fr_category_id`),
  UNIQUE INDEX `id_UNIQUE` (`fr_category_id` ASC),
  UNIQUE INDEX `category_key_UNIQUE` (`fr_category_key` ASC))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `bms_freights`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `bms_freights` (
  `fr_id` INT(10) NOT NULL,
  `fr_key` INT(10) UNSIGNED NULL,
  `fr_created_on` DATETIME NULL,
  `fr_created_by` INT(10) UNSIGNED NULL,
  `fr_modified_on` DATETIME NULL,
  `fr_modified_by` INT(10) UNSIGNED NULL,
  `fr_deleted` TINYINT NULL DEFAULT 0,
  `fr_deleted_by` INT(10) UNSIGNED NULL,
  `fr_branch` INT(10) UNSIGNED NULL,
  `fr_business` INT(10) UNSIGNED NULL,
  `fr_declaration_type` INT(10) UNSIGNED NULL,
  `fr_processing_office` VARCHAR(200) NULL,
  `fr_transad_number` VARCHAR(20) NULL,
  `fr_transad_date` DATE NULL,
  `fr_number_of_items` INT NULL,
  `fr_cl_plan` INT(10) UNSIGNED NULL,
  `fr_security_account_number` VARCHAR(20) NULL,
  `fr_receipt_number` INT NULL,
  `fr_receipt_date` DATE NULL,
  `fr_country_last_consignment` INT(10) UNSIGNED NULL,
  `fr_trading_country` INT(10) UNSIGNED NULL,
  `fr_country_of_export` INT(10) UNSIGNED NULL,
  `fr_importer` INT(10) UNSIGNED NULL,
  `fr_exporter` INT(10) NULL,
  `fr_country_of _destination` INT(10) UNSIGNED NULL,
  `fr_delivery_term_code` VARCHAR(10) NULL,
  `fr_delivery_place` VARCHAR(60) NULL,
  `fr_nature_of_transport` VARCHAR(5) NULL,
  `fr_exchange_rate` FLOAT NULL,
  `fr_exchange_currency` VARCHAR(3) NULL,
  `fr_total_invoice_value` FLOAT NULL,
  `fr_invoice_number` VARCHAR(45) NULL,
  `fr_invoice_date` DATE NULL,
  `fr_valuation_note` TEXT NULL,
  `fr_freight_charges` FLOAT NULL,
  `fr_freight_currency` VARCHAR(3) NULL,
  `fr_insurance` FLOAT NULL,
  `fr_insurance_currency` VARCHAR(3) NULL,
  `fr_other_charges` FLOAT NULL,
  `fr_other_currency` VARCHAR(3) NULL,
  `fr_deductions` FLOAT NULL,
  `fr_deductions_currency` VARCHAR(3) NULL,
  `fr_number_of_packages` VARCHAR(10) NULL,
  `fr_gross_weight` VARCHAR(15) NULL,
  `fr_net_weight` VARCHAR(15) NULL,
  `fr_exit_office` VARCHAR(60) NULL,
  `fr_entry_office` VARCHAR(60) NULL,
  `fr_location_goods` VARCHAR(60) NULL,
  `fr_category_of_goods` INT(10) UNSIGNED NULL,
  `fr_shipping_order` VARCHAR(45) NULL,
  `fr_agent_reference_number` varchar(25) NOT NULL,
  PRIMARY KEY (`fr_id`),
  UNIQUE INDEX `id_UNIQUE` (`fr_id` ASC),
  UNIQUE KEY `fr_agent_reference_number` (`fr_agent_reference_number` ASC),
  UNIQUE INDEX `fr_key_UNIQUE` (`fr_key` ASC),
  INDEX `fr_country_export` (`fr_country_of_export` ASC),
  INDEX `fr_country_destination` (`fr_country_of _destination` ASC),
  INDEX `fr_country_last_consignment` (`fr_country_last_consignment` ASC),
  INDEX `fr_expoert` (`fr_exporter` ASC),
  INDEX `fr_importer` (`fr_importer` ASC),
  INDEX `fr_category_of_goods` (`fr_category_of_goods` ASC),
  INDEX `fr_cl_plan` (`fr_cl_plan` ASC),
  INDEX `fr_declation_type` (`fr_declaration_type` ASC),
  INDEX `fr_country_trading_idx` (`fr_trading_country` ASC),
  CONSTRAINT `fr_plan_key`
    FOREIGN KEY (`fr_cl_plan`)
    REFERENCES `bms_freight_plans` (`fr_plan_key`)
    ON DELETE RESTRICT
    ON UPDATE CASCADE,
  CONSTRAINT `fr_country_export`
    FOREIGN KEY (`fr_country_of_export`)
    REFERENCES `bms_countries` (`country_key`)
    ON DELETE RESTRICT
    ON UPDATE CASCADE,
  CONSTRAINT `fr_country_last_consin`
    FOREIGN KEY (`fr_country_last_consignment`)
    REFERENCES `bms_countries` (`country_key`)
    ON DELETE RESTRICT
    ON UPDATE CASCADE,
  CONSTRAINT `fr_country_destination`
    FOREIGN KEY (`fr_country_of _destination`)
    REFERENCES `bms_countries` (`country_key`)
    ON DELETE CASCADE
    ON UPDATE CASCADE,
  CONSTRAINT `fr_country_trading`
    FOREIGN KEY (`fr_trading_country`)
    REFERENCES `bms_countries` (`country_key`)
    ON DELETE RESTRICT
    ON UPDATE CASCADE,
  CONSTRAINT `fr_good_category`
    FOREIGN KEY (`fr_category_of_goods`)
    REFERENCES `bms_freight_categories` (`fr_category_key`)
    ON DELETE RESTRICT
    ON UPDATE CASCADE)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `bms_freight_declared_valuation`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `bms_freight_declared_valuation` (
  `fr_de_id` INT(10) NOT NULL,
  `fr_de_key` INT(10) UNSIGNED NULL,
  `fr_de_created_on` DATETIME NULL,
  `fr_de_created_by` INT(10) UNSIGNED NULL,
  `fr_de_modified_on` DATETIME NULL,
  `fr_de_modified_by` INT(10) UNSIGNED NULL,
  `fr_de_deleted` TINYINT NULL DEFAULT 0,
  `fr_de_deleted_by` INT(10) UNSIGNED NULL,
  `fr_de_branch` INT(10) UNSIGNED NULL,
  `fr_de_business` INT(10) UNSIGNED NULL,
  `fr_de_currency` VARCHAR(3) NULL,
  `fr_de_total_fob` FLOAT NULL,
  `fr_de_freight` FLOAT NULL,
  `fr_de_insurance` FLOAT NULL,
  `fr_de_other_charges` FLOAT NULL,
  `fr_de_deductions` FLOAT UNSIGNED NULL,
  `fr_de_customs_value` FLOAT NULL,
  `fr_de_item_no` INT NULL,
  `fr_de_description` TEXT NULL,
  `fr_de_hs_code` VARCHAR(30) NULL,
  `fr_de_value_for_customs` FLOAT UNSIGNED NULL,
  `fr_de_fob_value` FLOAT UNSIGNED NULL,
  `fr_de_model` VARCHAR(30) NULL,
  `fr_de_specification` VARCHAR(200) NULL,
  `fr_de_component` VARCHAR(45) NULL,
  `fr_de_quantity` INT NULL,
  `fr_de_unit_price` FLOAT NULL,
  `fr_de_item_invoice_price` FLOAT NULL,
  `fr_de_exchange_rate` FLOAT NULL,
  `fr_de_freight_key` INT(10) UNSIGNED NULL,
  PRIMARY KEY (`fr_de_id`),
  UNIQUE INDEX `id_UNIQUE` (`fr_de_id` ASC),
  UNIQUE INDEX `de_key_UNIQUE` (`fr_de_key` ASC),
  INDEX `de_freight` (`fr_de_freight_key` ASC),
  CONSTRAINT `freight`
    FOREIGN KEY (`fr_de_freight_key`)
    REFERENCES `bms_freights` (`fr_key`)
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `bms_freight_accessed_valuation`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `bms_freight_accessed_valuation` (
  `fr_av_id` INT(10) NOT NULL,
  `fr_av_key` INT(10) UNSIGNED NULL,
  `fr_av_created_on` DATETIME NULL,
  `fr_av_created_by` INT(10) UNSIGNED NULL,
  `fr_av_modified_on` DATETIME NULL,
  `fr_av_modified_by` INT(10) UNSIGNED NULL,
  `fr_av_deleted` TINYINT NULL DEFAULT 0,
  `fr_av_deleted_by` INT(10) UNSIGNED NULL,
  `fr_av_branch` INT(10) UNSIGNED NULL,
  `fr_av_business` INT(10) UNSIGNED NULL,
  `fr_av_currency` VARCHAR(3) NULL,
  `fr_av_total_fob` FLOAT NULL,
  `fr_av_freight` FLOAT NULL,
  `fr_av_insurance` FLOAT NULL,
  `fr_av_other_charges` FLOAT NULL,
  `fr_av_deductions` FLOAT UNSIGNED NULL,
  `fr_av_customs_value` FLOAT NULL,
  `fr_av_item_no` INT NULL,
  `fr_av_description` TEXT NULL,
  `fr_av_hs_code` VARCHAR(30) NULL,
  `fr_av_value_for_customs` FLOAT UNSIGNED NULL,
  `fr_av_fob_value` FLOAT UNSIGNED NULL,
  `fr_av_model` VARCHAR(30) NULL,
  `fr_av_specification` VARCHAR(200) NULL,
  `fr_av_component` VARCHAR(45) NULL,
  `fr_av_quantity` INT NULL,
  `fr_av_unit_price` FLOAT NULL,
  `fr_av_item_invoice_price` FLOAT NULL,
  `fr_av_exchange_rate` FLOAT NULL,
  `fr_av_freight_key` INT(10) UNSIGNED NULL,
  PRIMARY KEY (`fr_av_id`),
  UNIQUE INDEX `id_UNIQUE` (`fr_av_id` ASC),
  UNIQUE INDEX `av_key_UNIQUE` (`fr_av_key` ASC),
  INDEX `av_freight` (`fr_av_freight_key` ASC),
  CONSTRAINT `freight_key`
    FOREIGN KEY (`fr_av_freight_key`)
    REFERENCES `bms_freights` (`fr_key`)
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB;


SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;
